/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.TestFinder;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTestFinder
implements TestFinder {
    public PsiClass findSourceElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaTestFinder.$$$reportNull$$$0(0);
        }
        return TestIntegrationUtils.findOuterClass(element);
    }

    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        PsiClass klass;
        if (element == null) {
            JavaTestFinder.$$$reportNull$$$0(1);
        }
        if ((klass = this.findSourceElement(element)) == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                JavaTestFinder.$$$reportNull$$$0(2);
            }
            return set;
        }
        GlobalSearchScope scope = this.getSearchScope(element, true);
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)element.getProject());
        ArrayList<Pair> classesWithWeights = new ArrayList<Pair>();
        for (Pair eachNameWithWeight : TestFinderHelper.collectPossibleClassNamesWithWeights((String)klass.getName())) {
            for (PsiClass eachClass : cache.getClassesByName((String)eachNameWithWeight.first, scope)) {
                if (!this.isTestSubjectClass(eachClass)) continue;
                classesWithWeights.add(Pair.create((Object)eachClass, (Object)eachNameWithWeight.second));
            }
        }
        List list = TestFinderHelper.getSortedElements(classesWithWeights, (boolean)false);
        if (list == null) {
            JavaTestFinder.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected GlobalSearchScope getSearchScope(PsiElement element) {
        return this.getSearchScope(element, true);
    }

    protected GlobalSearchScope getSearchScope(PsiElement element, boolean dependencies) {
        Module module = JavaTestFinder.getModule(element);
        if (module != null) {
            return dependencies ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.moduleWithDependentsScope((Module)module);
        }
        return GlobalSearchScope.projectScope((Project)element.getProject());
    }

    protected boolean isTestSubjectClass(PsiClass klass) {
        return !klass.isAnnotationType() && !TestFrameworks.getInstance().isTestClass(klass) && klass.isPhysical();
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        PsiClass klass;
        if (element == null) {
            JavaTestFinder.$$$reportNull$$$0(4);
        }
        if ((klass = this.findSourceElement(element)) == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                JavaTestFinder.$$$reportNull$$$0(5);
            }
            return set;
        }
        ArrayList classesWithProximities = new ArrayList();
        Processor processor = Processors.cancelableCollectProcessor(classesWithProximities);
        this.collectTests(klass, (Processor<Pair<? extends PsiNamedElement, Integer>>)processor);
        List list = TestFinderHelper.getSortedElements(classesWithProximities, (boolean)true);
        if (list == null) {
            JavaTestFinder.$$$reportNull$$$0(6);
        }
        return list;
    }

    private boolean collectTests(PsiClass klass, Processor<Pair<? extends PsiNamedElement, Integer>> processor) {
        GlobalSearchScope scope = this.getSearchScope((PsiElement)klass, false);
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)klass.getProject());
        String klassName = klass.getName();
        Pattern pattern = Pattern.compile(".*" + StringUtil.escapeToRegexp((String)klassName) + ".*", 2);
        for (String eachName : ContainerUtil.newHashSet((Object[])cache.getAllClassNames())) {
            if (!pattern.matcher(eachName).matches()) continue;
            for (PsiClass eachClass : cache.getClassesByName(eachName, scope)) {
                if (!this.isTestClass(eachClass, klass) || processor.process((Object)Pair.create((Object)eachClass, (Object)TestFinderHelper.calcTestNameProximity((String)klassName, (String)eachName)))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isTestClass(PsiClass eachClass, PsiClass klass) {
        TestFrameworks frameworks = TestFrameworks.getInstance();
        return eachClass.isPhysical() && (frameworks.isTestClass(eachClass) || eachClass != klass && frameworks.isPotentialTestClass(eachClass));
    }

    @Nullable
    private static Module getModule(PsiElement element) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        return file == null ? null : index.getModuleForFile(file);
    }

    public boolean isTest(@NotNull PsiElement element) {
        if (element == null) {
            JavaTestFinder.$$$reportNull$$$0(7);
        }
        return TestIntegrationUtils.isTest(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testIntegration/JavaTestFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testIntegration/JavaTestFinder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesForTest";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsForClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSourceElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findClassesForTest";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTestsForClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

