/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAssignmentToParameterInspection
extends BaseInspection {
    public boolean ignoreTransformationOfOriginalParameter = false;

    protected abstract boolean isApplicable(PsiParameter var1);

    @Override
    public final BaseInspectionVisitor buildVisitor() {
        return new AssignmentToParameterVisitor();
    }

    private class AssignmentToParameterVisitor
    extends BaseInspectionVisitor {
        private AssignmentToParameterVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (expression2 == null) {
                AssignmentToParameterVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(expression2);
            PsiExpression lhs = expression2.getLExpression();
            PsiParameter parameter2 = this.getParameter(lhs);
            if (parameter2 == null) {
                return;
            }
            if (BaseAssignmentToParameterInspection.this.ignoreTransformationOfOriginalParameter) {
                PsiExpression rhs = expression2.getRExpression();
                if (rhs != null && VariableAccessUtils.variableIsUsed((PsiVariable)parameter2, (PsiElement)rhs)) {
                    return;
                }
                IElementType tokenType = expression2.getOperationTokenType();
                if (tokenType == JavaTokenType.PLUSEQ || tokenType == JavaTokenType.MINUSEQ || tokenType == JavaTokenType.ASTERISKEQ || tokenType == JavaTokenType.DIVEQ || tokenType == JavaTokenType.ANDEQ || tokenType == JavaTokenType.OREQ || tokenType == JavaTokenType.XOREQ || tokenType == JavaTokenType.PERCEQ || tokenType == JavaTokenType.LTLTEQ || tokenType == JavaTokenType.GTGTEQ || tokenType == JavaTokenType.GTGTGTEQ) {
                    return;
                }
            }
            this.registerError((PsiElement)lhs, new Object[0]);
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression2) {
            if (expression2 == null) {
                AssignmentToParameterVisitor.$$$reportNull$$$0(1);
            }
            if (BaseAssignmentToParameterInspection.this.ignoreTransformationOfOriginalParameter) {
                return;
            }
            super.visitUnaryExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiParameter parameter2 = this.getParameter(operand2);
            if (parameter2 == null) {
                return;
            }
            this.registerError((PsiElement)operand2, new Object[0]);
        }

        @Nullable
        private PsiParameter getParameter(PsiExpression expression2) {
            if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement variable = referenceExpression.resolve();
            if (!(variable instanceof PsiParameter)) {
                return null;
            }
            PsiParameter parameter2 = (PsiParameter)variable;
            return !BaseAssignmentToParameterInspection.this.isApplicable(parameter2) ? null : parameter2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/assignment/BaseAssignmentToParameterInspection$AssignmentToParameterVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

