/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ThrowableNotThrownInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("throwable.not.thrown.display.name", new Object[0]);
        if (string == null) {
            ThrowableNotThrownInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[0];
        if (expression2 instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("throwable.result.of.method.call.ignored.problem.descriptor", new Object[0]);
            if (string == null) {
                ThrowableNotThrownInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String type2 = TypeUtils.expressionHasTypeOrSubtype(expression2, "java.lang.RuntimeException", "java.lang.Exception", "java.lang.Error");
        if ("java.lang.RuntimeException".equals(type2)) {
            String string = InspectionGadgetsBundle.message("throwable.instance.never.thrown.runtime.exception.problem.descriptor", new Object[0]);
            if (string == null) {
                ThrowableNotThrownInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        if ("java.lang.Exception".equals(type2)) {
            String string = InspectionGadgetsBundle.message("throwable.instance.never.thrown.checked.exception.problem.descriptor", new Object[0]);
            if (string == null) {
                ThrowableNotThrownInspection.$$$reportNull$$$0(3);
            }
            return string;
        }
        if ("java.lang.Error".equals(type2)) {
            String string = InspectionGadgetsBundle.message("throwable.instance.never.thrown.error.problem.descriptor", new Object[0]);
            if (string == null) {
                ThrowableNotThrownInspection.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("throwable.instance.never.thrown.problem.descriptor", new Object[0]);
        if (string == null) {
            ThrowableNotThrownInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowableResultOfMethodCallIgnoredVisitor();
    }

    static boolean isIgnoredThrowable(PsiExpression expression2) {
        if (!TypeUtils.expressionHasTypeOrSubtype(expression2, "java.lang.Throwable")) {
            return false;
        }
        return ThrowableNotThrownInspection.isIgnored((PsiElement)expression2, true);
    }

    private static boolean isIgnored(PsiElement element, boolean checkDeep) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiStatement.class, PsiExpressionList.class, PsiVariable.class, PsiLambdaExpression.class, PsiPolyadicExpression.class, PsiInstanceOfExpression.class});
        if (parent instanceof PsiVariable) {
            if (!(parent instanceof PsiLocalVariable)) {
                return false;
            }
            return checkDeep && !ThrowableNotThrownInspection.isUsedElsewhere((PsiLocalVariable)parent);
        }
        if (!(parent instanceof PsiStatement)) {
            return false;
        }
        if (parent instanceof PsiReturnStatement || parent instanceof PsiThrowStatement || parent instanceof PsiForeachStatement) {
            return false;
        }
        if (parent instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)parent;
            PsiExpression expression1 = expressionStatement.getExpression();
            if (expression1 instanceof PsiMethodCallExpression) {
                return !PsiType.VOID.equals((Object)expression1.getType());
            }
            if (expression1 instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression1;
                PsiExpression rhs = assignmentExpression.getRExpression();
                if (!PsiTreeUtil.isAncestor((PsiElement)rhs, (PsiElement)element, (boolean)false)) {
                    return false;
                }
                PsiExpression lhs = ParenthesesUtils.stripParentheses(assignmentExpression.getLExpression());
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiLocalVariable)) {
                    return false;
                }
                return checkDeep && !ThrowableNotThrownInspection.isUsedElsewhere((PsiLocalVariable)target);
            }
        }
        return true;
    }

    private static boolean isUsedElsewhere(PsiLocalVariable variable) {
        Query query = ReferencesSearch.search((PsiElement)variable);
        for (PsiReference reference : query) {
            PsiElement usage = reference.getElement();
            if (ThrowableNotThrownInspection.isIgnored(usage, false)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ThrowableNotThrownInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ThrowableResultOfMethodCallIgnoredVisitor
    extends BaseInspectionVisitor {
        private ThrowableResultOfMethodCallIgnoredVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (!ThrowableNotThrownInspection.isIgnoredThrowable((PsiExpression)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            StandardMethodContract contract;
            super.visitMethodCallExpression(expression2);
            if (!ThrowableNotThrownInspection.isIgnoredThrowable((PsiExpression)expression2)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)method.getReturnType());
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!method.hasModifierProperty("static") && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.lang.Throwable")) {
                return;
            }
            List<StandardMethodContract> contracts2 = ControlFlowAnalyzer.getMethodContracts(method);
            if (contracts2.size() == 1 && (contract = contracts2.get(0)).isTrivial() && contract.getReturnValue() == MethodContract.ValueConstraint.THROW_EXCEPTION) {
                return;
            }
            this.registerMethodCallError(expression2, expression2);
        }
    }
}

