/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.psiutils.HighlightUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ExtractParameterAsLocalVariableFix
extends InspectionGadgetsFix {
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("extract.parameter.as.local.variable.quickfix", new Object[0]);
        if (string == null) {
            ExtractParameterAsLocalVariableFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiExpression rhs;
        PsiElement body2;
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof PsiExpression)) {
            return;
        }
        PsiExpression expression2 = ParenthesesUtils.stripParentheses((PsiExpression)element);
        if (!(expression2 instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression parameterReference = (PsiReferenceExpression)expression2;
        PsiElement target = parameterReference.resolve();
        if (!(target instanceof PsiParameter)) {
            return;
        }
        PsiParameter parameter2 = (PsiParameter)target;
        PsiElement declarationScope = parameter2.getDeclarationScope();
        if (declarationScope instanceof PsiLambdaExpression) {
            RefactoringUtil.expandExpressionLambdaToCodeBlock((PsiLambdaExpression)declarationScope);
        } else if (declarationScope instanceof PsiForeachStatement) {
            body2 = ((PsiForeachStatement)declarationScope).getBody();
            if (body2 == null) {
                return;
            }
            BlockUtils.expandSingleStatementToBlockStatement(body2);
        }
        body2 = BlockUtils.getBody(declarationScope);
        if (body2 == null) {
            return;
        }
        assert (body2 instanceof PsiCodeBlock);
        String parameterName = parameter2.getName();
        PsiExpression psiExpression = rhs = parameterReference.isValid() ? ExtractParameterAsLocalVariableFix.getRightSideIfLeftSideOfSimpleAssignment(parameterReference, body2) : null;
        assert (parameterName != null);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        String variableName = javaCodeStyleManager.suggestUniqueVariableName(parameterName, body2, true);
        CommentTracker tracker = new CommentTracker();
        String initializerText = rhs == null ? parameterName : tracker.text((PsiElement)rhs);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiType type2 = parameter2.getType();
        if (type2 instanceof PsiLambdaParameterType) {
            return;
        }
        PsiDeclarationStatement newStatement = (PsiDeclarationStatement)factory.createStatementFromText(type2.getCanonicalText() + ' ' + variableName + '=' + initializerText + ';', body2);
        PsiElementProcessor.CollectFilteredElements collector = new PsiElementProcessor.CollectFilteredElements(e -> e instanceof PsiReferenceExpression && ((PsiReferenceExpression)e).resolve() == parameter2);
        PsiCodeBlock codeBlock = (PsiCodeBlock)body2;
        PsiStatement anchor = null;
        for (PsiStatement statement : codeBlock.getStatements()) {
            if (anchor == null) {
                if (rhs == null && !JavaHighlightUtil.isSuperOrThisCall(statement, true, true)) {
                    anchor = statement;
                    PsiTreeUtil.processElements((PsiElement)statement, (PsiElementProcessor)collector);
                    continue;
                }
                if (!statement.getTextRange().contains(parameterReference.getTextRange())) continue;
                anchor = statement;
                continue;
            }
            PsiTreeUtil.processElements((PsiElement)statement, (PsiElementProcessor)collector);
        }
        assert (anchor != null);
        newStatement = (PsiDeclarationStatement)(rhs == null ? codeBlock.addBefore((PsiElement)newStatement, anchor) : tracker.replaceAndRestoreComments((PsiElement)anchor, (PsiElement)newStatement));
        ExtractParameterAsLocalVariableFix.replaceReferences(collector.getCollection(), variableName, body2);
        if (this.isOnTheFly()) {
            PsiLocalVariable variable = (PsiLocalVariable)newStatement.getDeclaredElements()[0];
            HighlightUtil.showRenameTemplate(body2, (PsiNameIdentifierOwner)variable);
        }
    }

    private static void replaceReferences(Collection<PsiReferenceExpression> collection, String newVariableName, PsiElement context) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        PsiReferenceExpression newReference = (PsiReferenceExpression)factory.createExpressionFromText(newVariableName, context);
        for (PsiReferenceExpression reference : collection) {
            reference.replace((PsiElement)newReference);
        }
    }

    private static PsiExpression getRightSideIfLeftSideOfSimpleAssignment(PsiReferenceExpression reference, PsiElement block) {
        if (reference == null) {
            return null;
        }
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)reference);
        if (!(parent instanceof PsiAssignmentExpression)) {
            return null;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
        IElementType tokenType = assignmentExpression.getOperationTokenType();
        if (!JavaTokenType.EQ.equals(tokenType)) {
            return null;
        }
        PsiExpression lExpression = ParenthesesUtils.stripParentheses(assignmentExpression.getLExpression());
        if (!reference.equals(lExpression)) {
            return null;
        }
        PsiExpression rExpression = assignmentExpression.getRExpression();
        if (ParenthesesUtils.stripParentheses(rExpression) instanceof PsiAssignmentExpression) {
            return null;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof PsiExpressionStatement) || grandParent.getParent() != block) {
            return null;
        }
        return rExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/ExtractParameterAsLocalVariableFix", "getFamilyName"));
    }
}

