/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class DivideByZeroInspection
extends BaseInspection {
    private static final LongRangeSet ZERO_RANGE = LongRangeSet.point(0L);

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("divzero" == null) {
            DivideByZeroInspection.$$$reportNull$$$0(0);
        }
        return "divzero";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("divide.by.zero.display.name", new Object[0]);
        if (string == null) {
            DivideByZeroInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("divide.by.zero.problem.descriptor", new Object[0]);
        if (string == null) {
            DivideByZeroInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DivisionByZeroVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/DivideByZeroInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DivisionByZeroVisitor
    extends BaseInspectionVisitor {
        private DivisionByZeroVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!JavaTokenType.DIV.equals(tokenType) && !JavaTokenType.PERC.equals(tokenType)) {
                return;
            }
            PsiExpression[] operands2 = expression2.getOperands();
            for (int i = 1; i < operands2.length; ++i) {
                PsiExpression operand2 = operands2[i];
                if (!DivisionByZeroVisitor.isZero(operand2)) continue;
                this.registerError((PsiElement)operand2, new Object[0]);
                return;
            }
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            PsiExpression rhs = expression2.getRExpression();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.DIVEQ) && !tokenType.equals(JavaTokenType.PERCEQ) || !DivisionByZeroVisitor.isZero(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private static boolean isZero(PsiExpression expression2) {
            double constantValue;
            Object value2 = ConstantExpressionUtil.computeCastTo((PsiExpression)expression2, (PsiType)PsiType.DOUBLE);
            if (value2 instanceof Double && (constantValue = ((Double)value2).doubleValue()) == 0.0) {
                return true;
            }
            LongRangeSet range = CommonDataflow.getExpressionFact(expression2, DfaFactType.RANGE);
            return ZERO_RANGE.equals(range);
        }
    }
}

