/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SynchronizationOnLocalVariableOrMethodParameterInspection
extends BaseInspection {
    public boolean reportLocalVariables = true;
    public boolean reportMethodParameters = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("synchronization.on.local.variable.or.method.parameter.display.name", new Object[0]);
        if (string == null) {
            SynchronizationOnLocalVariableOrMethodParameterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Boolean localVariable = (Boolean)infos[0];
        if (localVariable.booleanValue()) {
            String string = InspectionGadgetsBundle.message("synchronization.on.local.variable.problem.descriptor", new Object[0]);
            if (string == null) {
                SynchronizationOnLocalVariableOrMethodParameterInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("synchronization.on.method.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            SynchronizationOnLocalVariableOrMethodParameterInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizationOnLocalVariableVisitor();
    }

    private static boolean isEscaping(PsiVariable variable) {
        PsiElement scope;
        if (variable instanceof PsiParameter) {
            PsiParameter parameter2 = (PsiParameter)variable;
            scope = parameter2.getDeclarationScope();
        } else if (variable instanceof PsiLocalVariable) {
            scope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
        } else {
            throw new AssertionError();
        }
        if (scope == null) {
            return true;
        }
        EscapeVisitor visitor = new EscapeVisitor(variable, scope);
        scope.accept((PsiElementVisitor)visitor);
        return visitor.isEscaping();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class EscapeVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiVariable myVariable;
        private final PsiElement myContext;
        private boolean escaping;

        public EscapeVisitor(@NotNull PsiVariable variable, @NotNull PsiElement context) {
            if (variable == null) {
                EscapeVisitor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                EscapeVisitor.$$$reportNull$$$0(1);
            }
            this.escaping = false;
            this.myVariable = variable;
            this.myContext = context;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (this.escaping) {
                return;
            }
            super.visitReferenceExpression(expression2);
            PsiElement target = expression2.resolve();
            if (!this.myVariable.equals(target)) {
                return;
            }
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
            if (context != null && PsiTreeUtil.isAncestor((PsiElement)this.myContext, (PsiElement)context, (boolean)true)) {
                this.escaping = true;
            }
        }

        public boolean isEscaping() {
            return this.escaping;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection$EscapeVisitor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SynchronizationOnLocalVariableVisitor
    extends BaseInspectionVisitor {
        private SynchronizationOnLocalVariableVisitor() {
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
            super.visitSynchronizedStatement(statement);
            if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables && !SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportMethodParameters) {
                return;
            }
            PsiExpression lockExpression2 = ParenthesesUtils.stripParentheses(statement.getLockExpression());
            if (!(lockExpression2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lockExpression2;
            if (referenceExpression.isQualified()) {
                return;
            }
            boolean localVariable = false;
            PsiElement target = referenceExpression.resolve();
            if (target instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)target;
                if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables || this.isSynchronizedCollection((PsiVariable)variable, referenceExpression)) {
                    return;
                }
                localVariable = true;
            } else if (target instanceof PsiParameter) {
                PsiParameter parameter2 = (PsiParameter)target;
                PsiElement scope = parameter2.getDeclarationScope();
                if (scope instanceof PsiMethod) {
                    if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportMethodParameters) {
                        return;
                    }
                } else {
                    if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables) {
                        return;
                    }
                    localVariable = true;
                }
            } else {
                return;
            }
            PsiElement statementScope = this.getScope((PsiElement)statement);
            PsiElement targetScope = this.getScope(target);
            if (statementScope != targetScope || SynchronizationOnLocalVariableOrMethodParameterInspection.isEscaping((PsiVariable)target)) {
                return;
            }
            this.registerError((PsiElement)referenceExpression, localVariable);
        }

        private PsiElement getScope(PsiElement element) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class, PsiClassInitializer.class});
        }

        private boolean isSynchronizedCollection(@NotNull PsiVariable variable, PsiReferenceExpression referenceExpression) {
            PsiExpression definition;
            if (variable == null) {
                SynchronizationOnLocalVariableVisitor.$$$reportNull$$$0(0);
            }
            if (!((definition = DeclarationSearchUtils.findDefinition(referenceExpression, variable)) instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)definition;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            String methodName = method.getName();
            if (!methodName.startsWith("synchronized")) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            return containingClass != null && "java.util.Collections".equals(containingClass.getQualifiedName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection$SynchronizationOnLocalVariableVisitor", "isSynchronizedCollection"));
        }
    }
}

