/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.enumswitch;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;
import java.util.HashSet;

class EnumSwitchPredicate
implements PsiElementPredicate {
    EnumSwitchPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiStatement[] statements;
        PsiElement prevSibling;
        if (element instanceof PsiWhiteSpace && (prevSibling = element.getPrevSibling()) instanceof PsiSwitchStatement && ErrorUtil.containsError(prevSibling)) {
            element = prevSibling;
        }
        if (!(element instanceof PsiSwitchStatement)) {
            return false;
        }
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)element;
        PsiExpression expression2 = switchStatement.getExpression();
        if (expression2 == null) {
            return false;
        }
        PsiType type2 = expression2.getType();
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClass enumClass = ((PsiClassType)type2).resolve();
        if (enumClass == null || !enumClass.isEnum()) {
            return false;
        }
        PsiField[] fields = enumClass.getFields();
        if (fields.length == 0) {
            return false;
        }
        PsiCodeBlock body2 = switchStatement.getBody();
        if (body2 == null) {
            return true;
        }
        HashSet<String> enumElements = new HashSet<String>(fields.length);
        for (PsiField field : fields) {
            PsiType fieldType = field.getType();
            if (!fieldType.equals(type2)) continue;
            String fieldName = field.getName();
            enumElements.add(fieldName);
        }
        for (PsiStatement statement : statements = body2.getStatements()) {
            PsiSwitchLabelStatement labelStatement;
            PsiExpression value2;
            if (!(statement instanceof PsiSwitchLabelStatement) || (value2 = (labelStatement = (PsiSwitchLabelStatement)statement).getCaseValue()) == null) continue;
            String valueText = value2.getText();
            enumElements.remove(valueText);
        }
        return !enumElements.isEmpty();
    }
}

