/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemSettings<SS extends AbstractExternalSystemSettings<SS, PS, L>, PS extends ExternalProjectSettings, L extends ExternalSystemSettingsListener<PS>>
implements Disposable {
    @NotNull
    private final Topic<L> myChangesTopic;
    private Project myProject;
    @NotNull
    private final Map<String, PS> myLinkedProjectsSettings;
    @NotNull
    private final Map<String, PS> myLinkedProjectsSettingsView;

    protected AbstractExternalSystemSettings(@NotNull Topic<L> topic, @NotNull Project project) {
        if (topic == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(1);
        }
        this.myLinkedProjectsSettings = ContainerUtilRt.newHashMap();
        this.myLinkedProjectsSettingsView = Collections.unmodifiableMap(this.myLinkedProjectsSettings);
        this.myChangesTopic = topic;
        this.myProject = project;
    }

    public void dispose() {
        this.myProject = null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(2);
        }
        return project;
    }

    public boolean showSelectiveImportDialogOnInitialImport() {
        return SystemProperties.is((String)"external.system.show.selective.import.dialog");
    }

    public abstract void subscribe(@NotNull ExternalSystemSettingsListener<PS> var1);

    public void copyFrom(@NotNull SS settings) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(3);
        }
        for (ExternalProjectSettings projectSettings : ((AbstractExternalSystemSettings)settings).getLinkedProjectsSettings()) {
            this.myLinkedProjectsSettings.put(projectSettings.getExternalProjectPath(), projectSettings);
        }
        this.copyExtraSettingsFrom(settings);
    }

    protected abstract void copyExtraSettingsFrom(@NotNull SS var1);

    @NotNull
    public Collection<PS> getLinkedProjectsSettings() {
        Collection<PS> collection = this.myLinkedProjectsSettingsView.values();
        if (collection == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Nullable
    public PS getLinkedProjectSettings(@NotNull String linkedProjectPath) {
        ExternalProjectSettings ps;
        if (linkedProjectPath == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(5);
        }
        if ((ps = (ExternalProjectSettings)this.myLinkedProjectsSettings.get(linkedProjectPath)) == null) {
            for (ExternalProjectSettings ps1 : this.myLinkedProjectsSettings.values()) {
                for (String modulePath : ps1.getModules()) {
                    if (!linkedProjectPath.equals(modulePath)) continue;
                    return (PS)ps1;
                }
            }
        }
        if (ps == null) {
            ps = (ExternalProjectSettings)this.myLinkedProjectsSettings.get(FileUtil.toSystemIndependentName((String)linkedProjectPath));
        }
        return (PS)ps;
    }

    public void linkProject(@NotNull PS settings) throws IllegalArgumentException {
        PS existing;
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(6);
        }
        if ((existing = this.getLinkedProjectSettings(((ExternalProjectSettings)settings).getExternalProjectPath())) != null) {
            throw new IllegalArgumentException(String.format("Can't link external project '%s'. Reason: it's already registered at the current ide project", ((ExternalProjectSettings)settings).getExternalProjectPath()));
        }
        this.myLinkedProjectsSettings.put(((ExternalProjectSettings)settings).getExternalProjectPath(), settings);
        this.getPublisher().onProjectsLinked(Collections.singleton(settings));
    }

    public boolean unlinkExternalProject(@NotNull String linkedProjectPath) {
        ExternalProjectSettings removed;
        if (linkedProjectPath == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(7);
        }
        if ((removed = (ExternalProjectSettings)this.myLinkedProjectsSettings.remove(linkedProjectPath)) == null) {
            return false;
        }
        this.getPublisher().onProjectsUnlinked(Collections.singleton(linkedProjectPath));
        return true;
    }

    public void setLinkedProjectsSettings(@NotNull Collection<PS> settings) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(8);
        }
        this.setLinkedProjectsSettings(settings, null);
    }

    private void setLinkedProjectsSettings(@NotNull Collection<PS> settings, @Nullable ExternalSystemSettingsListener listener) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(9);
        }
        settings = settings.stream().filter(ps -> ps.getExternalProjectPath() != null).collect(Collectors.toList());
        ArrayList added = ContainerUtilRt.newArrayList();
        HashMap removed = ContainerUtilRt.newHashMap(this.myLinkedProjectsSettings);
        this.myLinkedProjectsSettings.clear();
        for (ExternalProjectSettings current : settings) {
            this.myLinkedProjectsSettings.put(current.getExternalProjectPath(), current);
        }
        for (ExternalProjectSettings current : settings) {
            ExternalProjectSettings old = (ExternalProjectSettings)removed.remove(current.getExternalProjectPath());
            if (old == null) {
                added.add(current);
                continue;
            }
            if (current.isUseAutoImport() != old.isUseAutoImport()) {
                if (listener != null) {
                    listener.onUseAutoImportChange(current.isUseAutoImport(), current.getExternalProjectPath());
                }
                this.getPublisher().onUseAutoImportChange(current.isUseAutoImport(), current.getExternalProjectPath());
            }
            if (old.isCreateEmptyContentRootDirectories() != current.isCreateEmptyContentRootDirectories() || old.isUseQualifiedModuleNames() != current.isUseQualifiedModuleNames()) {
                ExternalProjectsManager.getInstance(this.getProject()).getExternalProjectsWatcher().markDirty(current.getExternalProjectPath());
            }
            this.checkSettings(old, current);
        }
        if (!added.isEmpty()) {
            if (listener != null) {
                listener.onProjectsLinked(added);
            }
            this.getPublisher().onProjectsLinked(added);
        }
        if (!removed.isEmpty()) {
            if (listener != null) {
                listener.onProjectsUnlinked(removed.keySet());
            }
            this.getPublisher().onProjectsUnlinked(removed.keySet());
        }
    }

    protected abstract void checkSettings(@NotNull PS var1, @NotNull PS var2);

    @NotNull
    public Topic<L> getChangesTopic() {
        Topic<L> topic = this.myChangesTopic;
        if (topic == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(10);
        }
        return topic;
    }

    @NotNull
    public L getPublisher() {
        ExternalSystemSettingsListener externalSystemSettingsListener = (ExternalSystemSettingsListener)this.myProject.getMessageBus().syncPublisher(this.myChangesTopic);
        if (externalSystemSettingsListener == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(11);
        }
        return (L)externalSystemSettingsListener;
    }

    protected void fillState(@NotNull State<PS> state) {
        if (state == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(12);
        }
        state.setLinkedExternalProjectsSettings(ContainerUtilRt.newTreeSet(this.myLinkedProjectsSettings.values()));
    }

    protected void loadState(@NotNull State<PS> state) {
        Set<PS> settings;
        if (state == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(13);
        }
        if ((settings = state.getLinkedExternalProjectsSettings()) != null) {
            this.setLinkedProjectsSettings(settings, new ExternalSystemSettingsListenerAdapter(){

                @Override
                public void onProjectsLinked(@NotNull Collection linked) {
                    if (linked == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
                        return;
                    }
                    for (Object o : linked) {
                        ExternalProjectSettings settings = (ExternalProjectSettings)o;
                        for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
                            AbstractExternalSystemSettings se = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)AbstractExternalSystemSettings.this.myProject);
                            ProjectSystemId externalSystemId = manager.getSystemId();
                            if (settings != se.getLinkedProjectSettings(settings.getExternalProjectPath())) continue;
                            ExternalProjectsManager.getInstance(AbstractExternalSystemSettings.this.myProject).refreshProject(settings.getExternalProjectPath(), new ImportSpecBuilder(AbstractExternalSystemSettings.this.myProject, externalSystemId).useDefaultCallback().use(ProgressExecutionMode.IN_BACKGROUND_ASYNC).build());
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linked", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings$1", "onProjectsLinked"));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkedProjectsSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesTopic";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedProjectSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "linkProject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unlinkExternalProject";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setLinkedProjectsSettings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fillState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface State<S> {
        public Set<S> getLinkedExternalProjectsSettings();

        public void setLinkedExternalProjectsSettings(Set<S> var1);
    }
}

