/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HighlightableComponent;
import com.intellij.ui.HighlightedRegion;
import java.util.ArrayList;
import java.util.List;

public class HighlightedText {
    private final StringBuilder myBuffer;
    private final List<HighlightedRegion> myHighlightedRegions = new ArrayList<HighlightedRegion>();

    public HighlightedText() {
        this.myBuffer = new StringBuilder();
    }

    public void appendText(String text, TextAttributes attributes) {
        int startOffset = this.myBuffer.length();
        this.myBuffer.append(text);
        if (attributes != null) {
            this.myHighlightedRegions.add(new HighlightedRegion(startOffset, this.myBuffer.length(), attributes));
        }
    }

    public void appendText(char[] text, TextAttributes attributes) {
        int startOffset = this.myBuffer.length();
        this.myBuffer.append(text);
        if (attributes != null) {
            this.myHighlightedRegions.add(new HighlightedRegion(startOffset, this.myBuffer.length(), attributes));
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof HighlightedText)) {
            return false;
        }
        HighlightedText highlightedText = (HighlightedText)o;
        return StringUtil.equals((CharSequence)this.myBuffer, (CharSequence)highlightedText.myBuffer) && this.myHighlightedRegions.equals(highlightedText.myHighlightedRegions);
    }

    public String getText() {
        return this.myBuffer.toString();
    }

    public void applyToComponent(HighlightableComponent renderer) {
        renderer.setText(this.myBuffer.toString());
        for (HighlightedRegion info : this.myHighlightedRegions) {
            renderer.addHighlighter(info.startOffset, info.endOffset, info.textAttributes);
        }
    }
}

