/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.ComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentIdResolveResult;

class SelectorState
implements DependencyGraphSelector {
    private final Long id;
    private final DependencyState dependencyState;
    private final DependencyMetadata dependencyMetadata;
    private final DependencyToComponentIdResolver resolver;
    private final ResolveState resolveState;
    private ModuleVersionResolveException failure;
    private ModuleResolveState targetModule;
    private ComponentState selected;
    private BuildableComponentIdResolveResult idResolveResult;
    private ResolvedVersionConstraint versionConstraint;

    SelectorState(Long id, DependencyState dependencyState, DependencyToComponentIdResolver resolver, ResolveState resolveState, ModuleIdentifier targetModuleId) {
        this.id = id;
        this.dependencyState = dependencyState;
        this.dependencyMetadata = dependencyState.getDependency();
        this.resolver = resolver;
        this.resolveState = resolveState;
        this.targetModule = resolveState.getModule(targetModuleId);
    }

    @Override
    public Long getResultId() {
        return this.id;
    }

    public String toString() {
        return this.dependencyMetadata.toString();
    }

    @Override
    public ComponentSelector getRequested() {
        return this.dependencyState.getRequested();
    }

    ModuleVersionResolveException getFailure() {
        return this.failure != null ? this.failure : this.selected.getFailure();
    }

    public ComponentSelectionReason getSelectionReason() {
        if (this.selected != null) {
            return this.selected.getSelectionReason();
        }
        return this.createReason();
    }

    public ComponentState getSelected() {
        return this.targetModule.getSelected();
    }

    public ModuleResolveState getSelectedModule() {
        return this.targetModule;
    }

    public ComponentState resolveModuleRevisionId() {
        if (this.selected != null) {
            return this.selected;
        }
        if (this.failure != null) {
            return null;
        }
        this.idResolveResult = new DefaultBuildableComponentIdResolveResult();
        if (this.dependencyState.failure != null) {
            this.idResolveResult.failed(this.dependencyState.failure);
        } else {
            if (this.dependencyMetadata.isPending()) {
                this.idResolveResult.setSelectionDescription(VersionSelectionReasons.CONSTRAINT);
            }
            this.resolver.resolve(this.dependencyMetadata, this.idResolveResult);
        }
        if (this.idResolveResult.getFailure() != null) {
            this.failure = this.idResolveResult.getFailure();
            return null;
        }
        this.selected = this.resolveState.getRevision(this.idResolveResult.getModuleVersionId());
        this.selected.selectedBy(this);
        this.selected.addCause(this.idResolveResult.getSelectionDescription());
        if (this.dependencyState.getRuleDescriptor() != null) {
            this.selected.addCause(this.dependencyState.getRuleDescriptor());
        }
        this.targetModule = this.selected.getModule();
        this.targetModule.addSelector(this);
        this.versionConstraint = this.idResolveResult.getResolvedVersionConstraint();
        return this.selected;
    }

    private ComponentSelectionReasonInternal createReason() {
        boolean hasRuleDescriptor = this.dependencyState.getRuleDescriptor() != null;
        boolean isConstraint = this.dependencyMetadata.isPending();
        ComponentSelectionDescriptorInternal description = this.idResolveResult.getSelectionDescription();
        if (!hasRuleDescriptor && !isConstraint) {
            return VersionSelectionReasons.of(description);
        }
        ArrayList descriptors = Lists.newArrayListWithCapacity((int)(isConstraint && hasRuleDescriptor ? 3 : 2));
        descriptors.add(description);
        if (hasRuleDescriptor) {
            descriptors.add(this.dependencyState.getRuleDescriptor());
        }
        return VersionSelectionReasons.of(descriptors);
    }

    public void restart(ComponentState moduleRevision) {
        this.selected = moduleRevision;
        this.targetModule = moduleRevision.getModule();
        ComponentResolveMetadata metaData = moduleRevision.getMetaData();
        if (metaData != null) {
            this.idResolveResult.resolved(metaData);
        }
    }

    public void reset() {
        this.idResolveResult = null;
        this.selected = null;
        this.targetModule = null;
    }

    public DependencyMetadata getDependencyMetadata() {
        return this.dependencyMetadata;
    }

    public ComponentIdResolveResult getResolveResult() {
        return this.idResolveResult;
    }

    public ResolvedVersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }
}

