/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.awt.Color;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.AndroidColorAnnotator;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.AndroidUtilKt;
import org.jetbrains.kotlin.android.ResourceReferenceAnnotatorUtil;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/android/AndroidResourceReferenceAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getResourceReferenceTargetDescriptor", "Lorg/jetbrains/kotlin/load/java/descriptors/JavaPropertyDescriptor;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "idea-android"})
public final class AndroidResourceReferenceAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        PsiElement psiElement = element;
        if (!(psiElement instanceof KtReferenceExpression)) {
            psiElement = null;
        }
        KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)psiElement;
        if (ktReferenceExpression == null) {
            return;
        }
        KtReferenceExpression reference = ktReferenceExpression;
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)element);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet androidFacet2 = androidFacet;
        JavaPropertyDescriptor javaPropertyDescriptor = this.getResourceReferenceTargetDescriptor(reference);
        if (javaPropertyDescriptor == null) {
            return;
        }
        JavaPropertyDescriptor referenceTarget = javaPropertyDescriptor;
        ResourceType resourceType = AndroidUtilKt.getAndroidResourceType(referenceTarget);
        if (resourceType == null) {
            return;
        }
        ResourceType resourceType2 = resourceType;
        if (resourceType2 != ResourceType.COLOR && resourceType2 != ResourceType.DRAWABLE && resourceType2 != ResourceType.MIPMAP) {
            return;
        }
        AndroidPsiUtils.ResourceReferenceType referenceType = AndroidUtilKt.getResourceReferenceType(referenceTarget);
        AndroidFacet androidFacet3 = androidFacet2;
        Intrinsics.checkExpressionValueIsNotNull((Object)androidFacet3, (String)"androidFacet");
        Configuration configuration = ResourceReferenceAnnotatorUtil.pickConfiguration(androidFacet2, androidFacet3.getModule(), ((KtReferenceExpression)element).getContainingFile());
        if (configuration == null) {
            return;
        }
        Configuration configuration2 = configuration;
        ResourceValue resourceValue = ResourceReferenceAnnotatorUtil.findResourceValue(resourceType2, reference.getText(), referenceType == AndroidPsiUtils.ResourceReferenceType.FRAMEWORK, androidFacet2.getModule(), configuration2);
        if (resourceValue == null) {
            return;
        }
        ResourceValue resourceValue2 = resourceValue;
        Configuration configuration3 = configuration2;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"configuration");
        ResourceResolver resourceResolver = configuration3.getResourceResolver();
        if (resourceResolver == null) {
            return;
        }
        ResourceResolver resourceResolver2 = resourceResolver;
        if (resourceType2 == ResourceType.COLOR) {
            ResourceResolver resourceResolver3 = resourceResolver2;
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceResolver3, (String)"resourceResolver");
            RenderResources renderResources = (RenderResources)resourceResolver3;
            Project project = ((KtReferenceExpression)element).getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
            Color color = ResourceHelper.resolveColor((RenderResources)renderResources, (ResourceValue)resourceValue2, (Project)project);
            if (color != null) {
                Annotation annotation;
                Annotation annotation2 = annotation = holder.createInfoAnnotation(element, null);
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"annotation");
                annotation2.setGutterIconRenderer((GutterIconRenderer)new ResourceReferenceAnnotatorUtil.ColorRenderer(element, color));
            }
        } else {
            File iconFile;
            ResourceResolver resourceResolver4 = resourceResolver2;
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceResolver4, (String)"resourceResolver");
            RenderResources renderResources = (RenderResources)resourceResolver4;
            Project project = ((KtReferenceExpression)element).getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
            File file = ResourceHelper.resolveDrawable((RenderResources)renderResources, (ResourceValue)resourceValue2, (Project)project);
            if (file != null) {
                String string = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
                if (StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) {
                    file = ResourceReferenceAnnotatorUtil.pickBitmapFromXml(file, resourceResolver2, ((KtReferenceExpression)element).getProject());
                }
            }
            if ((iconFile = AndroidColorAnnotator.pickBestBitmap((File)file)) != null) {
                Annotation annotation;
                Annotation annotation3 = annotation = holder.createInfoAnnotation(element, null);
                Intrinsics.checkExpressionValueIsNotNull((Object)annotation3, (String)"annotation");
                annotation3.setGutterIconRenderer((GutterIconRenderer)new com.android.tools.idea.rendering.GutterIconRenderer(resourceResolver2, element, iconFile));
            }
        }
    }

    private final JavaPropertyDescriptor getResourceReferenceTargetDescriptor(@NotNull KtReferenceExpression $receiver) {
        ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)$receiver), null, (int)1, null);
        Object object = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
        if (!(object instanceof JavaPropertyDescriptor)) {
            object = null;
        }
        return (JavaPropertyDescriptor)object;
    }
}

