/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.apk.debugging.ApkDebugging;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class ApkDebugger {
    @NotNull
    private final Project myProject;
    @NotNull
    private final DumbService myDumbService;
    @NotNull
    private final ExecutionManager myExecutionManager;

    private ApkDebugger(@NotNull Project project) {
        if (project == null) {
            ApkDebugger.$$$reportNull$$$0(0);
        }
        this(project, DumbService.getInstance((Project)project), ExecutionManager.getInstance((Project)project));
    }

    @VisibleForTesting
    ApkDebugger(@NotNull Project project, @NotNull DumbService dumbService, @NotNull ExecutionManager executionManager) {
        if (project == null) {
            ApkDebugger.$$$reportNull$$$0(1);
        }
        if (dumbService == null) {
            ApkDebugger.$$$reportNull$$$0(2);
        }
        if (executionManager == null) {
            ApkDebugger.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myDumbService = dumbService;
        this.myExecutionManager = executionManager;
    }

    public void startDebugSession() {
        this.myDumbService.smartInvokeLater(this::doStartDebugSession);
    }

    private void doStartDebugSession() {
        RunnerAndConfigurationSettings settings = RunManagerEx.getInstanceEx((Project)this.myProject).getSelectedConfiguration();
        assert (settings != null);
        try {
            RunConfiguration configuration = settings.getConfiguration();
            assert (configuration instanceof AndroidRunConfiguration);
            settings.checkSettings();
            DefaultDebugExecutor executor = new DefaultDebugExecutor();
            ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.create((Executor)executor, (RunnerAndConfigurationSettings)settings);
            this.myExecutionManager.restartRunProfile(builder.activeTarget().build());
        }
        catch (Throwable e) {
            this.showAndLog(e);
        }
    }

    private void showAndLog(@NotNull Throwable e) {
        if (e == null) {
            ApkDebugger.$$$reportNull$$$0(4);
        }
        String text = "Cannot start debugging session";
        String cause = e.getMessage();
        if (StringUtil.isNotEmpty((String)cause)) {
            text = text + ": " + cause;
        }
        AndroidNotification.getInstance((Project)this.myProject).showBalloon("APK Debugging", text, NotificationType.ERROR, new NotificationHyperlink[]{new OpenMessagesQuickFix()});
        Logger.getInstance(this.getClass()).warn(text, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/apk/ApkDebugger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showAndLog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class OpenMessagesQuickFix
    extends NotificationHyperlink {
        OpenMessagesQuickFix() {
            super("open.messages.view", "Open 'Messages' view");
        }

        protected void execute(@NotNull Project project) {
            if (project == null) {
                OpenMessagesQuickFix.$$$reportNull$$$0(0);
            }
            ExternalSystemNotificationManager.getInstance((Project)project).openMessageView(ApkDebugging.SYSTEM_ID, NotificationSource.PROJECT_SYNC);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/apk/ApkDebugger$OpenMessagesQuickFix", "execute"));
        }
    }

    public static class Factory {
        @NotNull
        public ApkDebugger createNew(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(0);
            }
            ApkDebugger apkDebugger = new ApkDebugger(project);
            if (apkDebugger == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return apkDebugger;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/apk/ApkDebugger$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/apk/ApkDebugger$Factory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNew";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNew";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

