/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.Projects;
import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.setup.module.AndroidFacetSetupStep;
import com.android.tools.idea.apk.setup.module.ApkFacetSetupStep;
import com.android.tools.idea.apk.setup.module.ApkModuleSetupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class ApkModuleFactory {
    @NotNull
    private final ApkModuleSetupStep[] mySetupSteps;

    public ApkModuleFactory() {
        this(new AndroidFacetSetupStep(), new ApkFacetSetupStep());
    }

    @VisibleForTesting
    ApkModuleFactory(ApkModuleSetupStep ... setupSteps) {
        if (setupSteps == null) {
            ApkModuleFactory.$$$reportNull$$$0(0);
        }
        this.mySetupSteps = setupSteps;
    }

    @NotNull
    ApkSetupContext createApkModule(@NotNull Project project, @NotNull VirtualFile apkFile) throws Throwable {
        ApkSetupContext apkSetupContext;
        if (project == null) {
            ApkModuleFactory.$$$reportNull$$$0(1);
        }
        if (apkFile == null) {
            ApkModuleFactory.$$$reportNull$$$0(2);
        }
        File projectRootFolderPath = Projects.getBaseDirPath((Project)project);
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(project);
        try {
            File moduleFile = new File(projectRootFolderPath, projectRootFolderPath.getName() + ".iml");
            Module module = modelsProvider.newModule(moduleFile.getPath(), StdModuleTypes.JAVA.getId());
            ApkSetupContext context = new ApkSetupContext(module, (IdeModifiableModelsProvider)modelsProvider, apkFile);
            for (ApkModuleSetupStep step : this.mySetupSteps) {
                step.setUpModule((IdeModifiableModelsProvider)modelsProvider, context);
            }
            ApkModuleFactory.commitChanges(project, (IdeModifiableModelsProvider)modelsProvider);
            apkSetupContext = context;
        }
        catch (Exception e) {
            ApkModuleFactory.disposeChanges(project, (IdeModifiableModelsProvider)modelsProvider);
            throw e;
        }
        if (apkSetupContext == null) {
            ApkModuleFactory.$$$reportNull$$$0(3);
        }
        return apkSetupContext;
    }

    private static void commitChanges(@NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (project == null) {
            ApkModuleFactory.$$$reportNull$$$0(4);
        }
        if (modelsProvider == null) {
            ApkModuleFactory.$$$reportNull$$$0(5);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                modelsProvider.commit();
            }
        });
    }

    private static void disposeChanges(@NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (project == null) {
            ApkModuleFactory.$$$reportNull$$$0(6);
        }
        if (modelsProvider == null) {
            ApkModuleFactory.$$$reportNull$$$0(7);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                modelsProvider.dispose();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupSteps";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/ApkModuleFactory";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/ApkModuleFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createApkModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createApkModule";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "commitChanges";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "disposeChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

