/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.setup.module.AndroidManifestSetupStep;
import com.android.tools.idea.apk.setup.module.AndroidSdkSetupStep;
import com.android.tools.idea.apk.setup.module.ApkModuleSetupStep;
import com.android.tools.idea.apk.setup.module.ModuleContentEntrySetupStep;
import com.android.tools.idea.apk.setup.module.NativeCodeSetupStep;
import com.android.tools.idea.project.AndroidRunConfigurations;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ApkModuleSetup {
    @NotNull
    private final ApkModuleSetupStep[] mySetupSteps;

    public ApkModuleSetup() {
        this(new ModuleContentEntrySetupStep(), new AndroidManifestSetupStep(), new AndroidSdkSetupStep(), new NativeCodeSetupStep());
    }

    @VisibleForTesting
    ApkModuleSetup(ApkModuleSetupStep ... setupSteps) {
        if (setupSteps == null) {
            ApkModuleSetup.$$$reportNull$$$0(0);
        }
        this.mySetupSteps = setupSteps;
    }

    void setUpApkModule(@NotNull Project project, @NotNull ApkSetupContext context) throws Throwable {
        if (project == null) {
            ApkModuleSetup.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ApkModuleSetup.$$$reportNull$$$0(2);
        }
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(project);
        try {
            for (ApkModuleSetupStep step : this.mySetupSteps) {
                step.setUpModule((IdeModifiableModelsProvider)modelsProvider, context);
            }
            ApkModuleSetup.commitChanges(project, (IdeModifiableModelsProvider)modelsProvider);
        }
        catch (Exception e) {
            ApkModuleSetup.disposeChanges(project, (IdeModifiableModelsProvider)modelsProvider);
            throw e;
        }
        AndroidFacet androidFacet = context.getAndroidFacet();
        assert (androidFacet != null);
        AndroidRunConfigurations.getInstance().createRunConfiguration(androidFacet);
    }

    private static void commitChanges(@NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (project == null) {
            ApkModuleSetup.$$$reportNull$$$0(3);
        }
        if (modelsProvider == null) {
            ApkModuleSetup.$$$reportNull$$$0(4);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                modelsProvider.commit();
            }
        });
    }

    private static void disposeChanges(@NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (project == null) {
            ApkModuleSetup.$$$reportNull$$$0(5);
        }
        if (modelsProvider == null) {
            ApkModuleSetup.$$$reportNull$$$0(6);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                modelsProvider.dispose();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupSteps";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/apk/ApkModuleSetup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpApkModule";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "commitChanges";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "disposeChanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

