/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.issues.SetupIssueReporter;
import com.android.tools.idea.smali.psi.SmaliFile;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkProjectComponent
extends AbstractProjectComponent {
    @NotNull
    private final SetupIssueReporter myIssueReporter;
    @NotNull
    private final PsiManager myPsiManager;
    @NotNull
    private final DaemonCodeAnalyzerEx myDaemonCodeAnalyzer;
    @NotNull
    private final SmaliCodeHighlightingBlocker.Factory myCodeHighlightingBlockerFactory;
    private MessageBusConnection myConnection;

    @NotNull
    public static ApkProjectComponent getInstance(@NotNull Project project) {
        if (project == null) {
            ApkProjectComponent.$$$reportNull$$$0(0);
        }
        ApkProjectComponent component = (ApkProjectComponent)((Object)project.getComponent(ApkProjectComponent.class));
        assert (component != null);
        ApkProjectComponent apkProjectComponent = component;
        if (apkProjectComponent == null) {
            ApkProjectComponent.$$$reportNull$$$0(1);
        }
        return apkProjectComponent;
    }

    public ApkProjectComponent(@NotNull Project project, @NotNull SetupIssueReporter issueReporter, @NotNull PsiManager psiManager, @NotNull DaemonCodeAnalyzerEx daemonCodeAnalyzer) {
        if (project == null) {
            ApkProjectComponent.$$$reportNull$$$0(2);
        }
        if (issueReporter == null) {
            ApkProjectComponent.$$$reportNull$$$0(3);
        }
        if (psiManager == null) {
            ApkProjectComponent.$$$reportNull$$$0(4);
        }
        if (daemonCodeAnalyzer == null) {
            ApkProjectComponent.$$$reportNull$$$0(5);
        }
        this(project, issueReporter, psiManager, daemonCodeAnalyzer, new SmaliCodeHighlightingBlocker.Factory());
    }

    @VisibleForTesting
    ApkProjectComponent(@NotNull Project project, @NotNull SetupIssueReporter issueReporter, @NotNull PsiManager psiManager, @NotNull DaemonCodeAnalyzerEx daemonCodeAnalyzer, @NotNull SmaliCodeHighlightingBlocker.Factory codeHighlightingBlockerFactory) {
        if (project == null) {
            ApkProjectComponent.$$$reportNull$$$0(6);
        }
        if (issueReporter == null) {
            ApkProjectComponent.$$$reportNull$$$0(7);
        }
        if (psiManager == null) {
            ApkProjectComponent.$$$reportNull$$$0(8);
        }
        if (daemonCodeAnalyzer == null) {
            ApkProjectComponent.$$$reportNull$$$0(9);
        }
        if (codeHighlightingBlockerFactory == null) {
            ApkProjectComponent.$$$reportNull$$$0(10);
        }
        super(project);
        this.myIssueReporter = issueReporter;
        this.myPsiManager = psiManager;
        this.myDaemonCodeAnalyzer = daemonCodeAnalyzer;
        this.myCodeHighlightingBlockerFactory = codeHighlightingBlockerFactory;
    }

    public void projectOpened() {
        ArrayList<ApkFacet> apkFacets = new ArrayList<ApkFacet>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ApkFacet facet = ApkFacet.getInstance((Module)module);
            if (facet == null) continue;
            apkFacets.add(facet);
        }
        if (!apkFacets.isEmpty()) {
            MessageBus messageBus = this.myProject.getMessageBus();
            this.myConnection = messageBus.connect((Disposable)this.myProject);
            this.myConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this.myCodeHighlightingBlockerFactory.create(this.myPsiManager, this.myDaemonCodeAnalyzer));
            for (ApkFacet facet : apkFacets) {
                this.myIssueReporter.reportSetupIssues(facet);
            }
        }
    }

    public void projectClosed() {
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    @VisibleForTesting
    @Nullable
    MessageBusConnection getConnection() {
        return this.myConnection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/ApkProjectComponent";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueReporter";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "daemonCodeAnalyzer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeHighlightingBlockerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/ApkProjectComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class SmaliCodeHighlightingBlocker
    implements FileEditorManagerListener {
        @NotNull
        private final PsiManager myPsiManager;
        @NotNull
        private final DaemonCodeAnalyzerEx myDaemonCodeAnalyzer;

        SmaliCodeHighlightingBlocker(@NotNull PsiManager psiManager, @NotNull DaemonCodeAnalyzerEx daemonCodeAnalyzer) {
            if (psiManager == null) {
                SmaliCodeHighlightingBlocker.$$$reportNull$$$0(0);
            }
            if (daemonCodeAnalyzer == null) {
                SmaliCodeHighlightingBlocker.$$$reportNull$$$0(1);
            }
            this.myPsiManager = psiManager;
            this.myDaemonCodeAnalyzer = daemonCodeAnalyzer;
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            PsiFile psiFile;
            if (source == null) {
                SmaliCodeHighlightingBlocker.$$$reportNull$$$0(2);
            }
            if (file == null) {
                SmaliCodeHighlightingBlocker.$$$reportNull$$$0(3);
            }
            if ((psiFile = this.myPsiManager.findFile(file)) instanceof SmaliFile) {
                this.myDaemonCodeAnalyzer.setHighlightingEnabled(psiFile, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "daemonCodeAnalyzer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/apk/ApkProjectComponent$SmaliCodeHighlightingBlocker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileOpened";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static class Factory {
            Factory() {
            }

            @NotNull
            SmaliCodeHighlightingBlocker create(@NotNull PsiManager psiManager, @NotNull DaemonCodeAnalyzerEx daemonCodeAnalyzer) {
                if (psiManager == null) {
                    Factory.$$$reportNull$$$0(0);
                }
                if (daemonCodeAnalyzer == null) {
                    Factory.$$$reportNull$$$0(1);
                }
                SmaliCodeHighlightingBlocker smaliCodeHighlightingBlocker = new SmaliCodeHighlightingBlocker(psiManager, daemonCodeAnalyzer);
                if (smaliCodeHighlightingBlocker == null) {
                    Factory.$$$reportNull$$$0(2);
                }
                return smaliCodeHighlightingBlocker;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiManager";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "daemonCodeAnalyzer";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/apk/ApkProjectComponent$SmaliCodeHighlightingBlocker$Factory";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/apk/ApkProjectComponent$SmaliCodeHighlightingBlocker$Factory";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

