/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ApkProjectFolder {
    private static final String DIALOG_TITLE = "APK Import";

    @NotNull
    VirtualFile getOrCreateNewProjectFolder(@NotNull VirtualFile apkFile) throws IOException {
        if (apkFile == null) {
            ApkProjectFolder.$$$reportNull$$$0(0);
        }
        File userHomePath = new File(SystemProperties.getUserHome());
        assert (userHomePath.isDirectory());
        String projectName = apkFile.getNameWithoutExtension();
        VirtualFile virtualFile = this.getOrCreateNewProjectFolder(projectName, userHomePath);
        if (virtualFile == null) {
            ApkProjectFolder.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @VisibleForTesting
    @NotNull
    VirtualFile getOrCreateNewProjectFolder(@NotNull String projectName, @NotNull File userHomePath) throws IOException {
        if (projectName == null) {
            ApkProjectFolder.$$$reportNull$$$0(2);
        }
        if (userHomePath == null) {
            ApkProjectFolder.$$$reportNull$$$0(3);
        }
        File apkProjectsFolderPath = new File(userHomePath, "ApkProjects");
        FileUtil.ensureExists((File)apkProjectsFolderPath);
        File projectFolderPath = new File(apkProjectsFolderPath, projectName);
        if (projectFolderPath.isDirectory()) {
            String text = String.format("The folder '%1$s' already exists. If you choose to use the existing folder, its contents will be overwritten.", projectName);
            int answer = Messages.showOkCancelDialog((Project)null, (String)text, (String)DIALOG_TITLE, (String)"Use existing folder", (String)"Create new folder", (Icon)Messages.getQuestionIcon());
            if (answer == 0) {
                VirtualFile projectFolder;
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                if (projects.length > 0) {
                    for (Project project : projects) {
                        if (!FileUtil.pathsEqual((String)projectFolderPath.getPath(), (String)project.getBasePath())) continue;
                        String message = String.format("APK project '%1$s' will be closed and recreated", project.getName());
                        Messages.showWarningDialog((Project)project, (String)message, (String)DIALOG_TITLE);
                        ProjectUtil.closeAndDispose((Project)project);
                        WelcomeFrame.showIfNoProjectOpened();
                        break;
                    }
                }
                if ((projectFolder = VfsUtil.findFileByIoFile((File)projectFolderPath, (boolean)true)) != null) {
                    ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Void, IOException>(){

                        public Void compute() throws IOException {
                            projectFolder.delete((Object)this);
                            return null;
                        }
                    });
                }
                FileUtil.delete((File)projectFolderPath);
            } else {
                File newPath = FileUtil.findSequentNonexistentFile((File)apkProjectsFolderPath, (String)projectName, (String)"");
                VirtualFile virtualFile = this.getOrCreateNewProjectFolder(newPath.getName(), userHomePath);
                if (virtualFile == null) {
                    ApkProjectFolder.$$$reportNull$$$0(4);
                }
                return virtualFile;
            }
        }
        FileUtil.ensureExists((File)projectFolderPath);
        VirtualFile newProjectFolder = VfsUtil.findFileByIoFile((File)projectFolderPath, (boolean)true);
        assert (newProjectFolder != null);
        VirtualFile virtualFile = newProjectFolder;
        if (virtualFile == null) {
            ApkProjectFolder.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFile";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/ApkProjectFolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userHomePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/ApkProjectFolder";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateNewProjectFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateNewProjectFolder";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

