/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.apk.ApkDebugger;
import com.android.tools.idea.apk.ApkDebuggingUsageTracker;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFileType;
import com.android.tools.idea.apk.ApkModuleFactory;
import com.android.tools.idea.apk.ApkModuleSetup;
import com.android.tools.idea.apk.ApkProjectFolder;
import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.AsyncResult;
import com.android.tools.idea.apk.FileOpener;
import com.android.tools.idea.apk.issues.SetupIssueReporter;
import com.android.tools.idea.apk.setup.ProjectApkFileSetup;
import com.android.tools.idea.apk.setup.project.ProjectSdkSetup;
import com.android.tools.idea.gradle.project.importing.NewProjectSetup;
import com.android.tools.idea.gradle.project.importing.ProjectFolder;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.project.CustomProjectTypeImporter;
import com.android.tools.idea.util.ToolWindows;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkProjectImporter
extends CustomProjectTypeImporter {
    @NotNull
    private final ProjectFolder.Factory myProjectFolderFactory;
    @NotNull
    private final ApkProjectFolder myProjectFolder;
    @NotNull
    private final NewProjectSetup myNewProjectSetup;
    @NotNull
    private final ProjectApkFileSetup myApkFileSetup;
    @NotNull
    private final ApkModuleFactory myApkModuleFactory;
    @NotNull
    private final ApkModuleSetup myApkModuleSetup;
    @NotNull
    private final ApkDebugger.Factory myDebuggerFactory;
    @NotNull
    private final ProjectSdkSetup myProjectSdkSetup;
    @NotNull
    private final FileOpener myFileOpener;
    private final boolean myStartDebugSession;

    public ApkProjectImporter() {
        this(new ProjectFolder.Factory(), new ApkProjectFolder(), new NewProjectSetup(), new ProjectApkFileSetup(), new ApkModuleFactory(), new ApkModuleSetup(), new ApkDebugger.Factory(), new ProjectSdkSetup(), new FileOpener(), false);
    }

    @VisibleForTesting
    public ApkProjectImporter(@NotNull ProjectFolder.Factory projectFolderFactory, @NotNull ApkProjectFolder projectFolder, @NotNull NewProjectSetup newProjectSetup, @NotNull ProjectApkFileSetup apkFileSetup, @NotNull ApkModuleFactory apkModuleFactory, @NotNull ApkModuleSetup apkModuleSetup, @NotNull ApkDebugger.Factory debuggerFactory, @NotNull ProjectSdkSetup projectSdkSetup, @NotNull FileOpener fileOpener, boolean startDebugSession) {
        if (projectFolderFactory == null) {
            ApkProjectImporter.$$$reportNull$$$0(0);
        }
        if (projectFolder == null) {
            ApkProjectImporter.$$$reportNull$$$0(1);
        }
        if (newProjectSetup == null) {
            ApkProjectImporter.$$$reportNull$$$0(2);
        }
        if (apkFileSetup == null) {
            ApkProjectImporter.$$$reportNull$$$0(3);
        }
        if (apkModuleFactory == null) {
            ApkProjectImporter.$$$reportNull$$$0(4);
        }
        if (apkModuleSetup == null) {
            ApkProjectImporter.$$$reportNull$$$0(5);
        }
        if (debuggerFactory == null) {
            ApkProjectImporter.$$$reportNull$$$0(6);
        }
        if (projectSdkSetup == null) {
            ApkProjectImporter.$$$reportNull$$$0(7);
        }
        if (fileOpener == null) {
            ApkProjectImporter.$$$reportNull$$$0(8);
        }
        this.myProjectFolderFactory = projectFolderFactory;
        this.myProjectFolder = projectFolder;
        this.myNewProjectSetup = newProjectSetup;
        this.myApkFileSetup = apkFileSetup;
        this.myApkModuleFactory = apkModuleFactory;
        this.myApkModuleSetup = apkModuleSetup;
        this.myDebuggerFactory = debuggerFactory;
        this.myProjectSdkSetup = projectSdkSetup;
        this.myFileOpener = fileOpener;
        this.myStartDebugSession = startDebugSession;
    }

    public boolean canImport(@NotNull VirtualFile file) {
        if (file == null) {
            ApkProjectImporter.$$$reportNull$$$0(9);
        }
        return FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)file, null) instanceof ApkFileType;
    }

    public void importFile(@NotNull VirtualFile apkFile) {
        if (apkFile == null) {
            ApkProjectImporter.$$$reportNull$$$0(10);
        }
        try {
            VirtualFile projectRootFolder = this.myProjectFolder.getOrCreateNewProjectFolder(apkFile);
            File projectRootFolderPath = VfsUtilCore.virtualToIoFile((VirtualFile)projectRootFolder);
            ProjectFolder projectFolder = this.myProjectFolderFactory.create(projectRootFolderPath);
            projectFolder.createIdeaProjectFolder();
            Project newProject = this.myNewProjectSetup.createProject(projectRootFolderPath.getName(), projectRootFolderPath.getPath());
            this.setUpApkProjectAsynchronous(newProject, apkFile);
        }
        catch (Throwable e) {
            ApkProjectImporter.showAndLogError(e);
        }
    }

    private void setUpApkProjectAsynchronous(@NotNull Project project, @NotNull VirtualFile apkFile) {
        if (project == null) {
            ApkProjectImporter.$$$reportNull$$$0(11);
        }
        if (apkFile == null) {
            ApkProjectImporter.$$$reportNull$$$0(12);
        }
        AsyncResult<VirtualFile> callback = this.setUpApkFile(project, apkFile, project.getBaseDir());
        callback.doWhenDone(() -> {
            if (project == null) {
                ApkProjectImporter.$$$reportNull$$$0(27);
            }
            VirtualFile projectApkFile = (VirtualFile)callback.getResult();
            assert (projectApkFile != null);
            this.createAndSetupMainModule(project, projectApkFile);
        });
        callback.doWhenRejected(() -> {
            Throwable error = callback.getUnexpectedError();
            assert (error != null);
            ApkProjectImporter.showAndLogError(error);
        });
    }

    @NotNull
    private AsyncResult<VirtualFile> setUpApkFile(@NotNull Project project, final @NotNull VirtualFile apkFile, final @NotNull VirtualFile projectRootFolder) {
        if (project == null) {
            ApkProjectImporter.$$$reportNull$$$0(13);
        }
        if (apkFile == null) {
            ApkProjectImporter.$$$reportNull$$$0(14);
        }
        if (projectRootFolder == null) {
            ApkProjectImporter.$$$reportNull$$$0(15);
        }
        final AsyncResult<VirtualFile> callback = new AsyncResult<VirtualFile>();
        Task.Modal task = new Task.Modal(project, "Set Up APK", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                try {
                    VirtualFile copy = ApkProjectImporter.this.setUpApkFile(apkFile, projectRootFolder, indicator);
                    if (copy != null) {
                        callback.setDone(copy);
                        return;
                    }
                    callback.setRejected(new FileNotFoundException("Failed to find APK file in the project"));
                }
                catch (Throwable error) {
                    callback.setRejected(error);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/apk/ApkProjectImporter$1", "run"));
            }
        };
        task.queue();
        AsyncResult<VirtualFile> asyncResult = callback;
        if (asyncResult == null) {
            ApkProjectImporter.$$$reportNull$$$0(16);
        }
        return asyncResult;
    }

    @Nullable
    private VirtualFile setUpApkFile(@NotNull VirtualFile apkFile, @NotNull VirtualFile projectRootFolder, @Nullable ProgressIndicator indicator) throws IOException, ExecutionException, InterruptedException {
        if (apkFile == null) {
            ApkProjectImporter.$$$reportNull$$$0(17);
        }
        if (projectRootFolder == null) {
            ApkProjectImporter.$$$reportNull$$$0(18);
        }
        Path apkFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)apkFile).toPath();
        Path destination = VfsUtilCore.virtualToIoFile((VirtualFile)projectRootFolder).toPath();
        Path copyPath = this.myApkFileSetup.setUpApk(apkFilePath, destination, indicator);
        return VfsUtil.findFileByIoFile((File)copyPath.toFile(), (boolean)true);
    }

    private void createAndSetupMainModule(@NotNull Project project, @NotNull VirtualFile apkFile) {
        if (project == null) {
            ApkProjectImporter.$$$reportNull$$$0(19);
        }
        if (apkFile == null) {
            ApkProjectImporter.$$$reportNull$$$0(20);
        }
        this.myProjectSdkSetup.setUpProject(project);
        try {
            ApkSetupContext context = this.myApkModuleFactory.createApkModule(project, apkFile);
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            if (!unitTestMode) {
                project.save();
            }
            GradleProjects.open((Project)project);
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                if (project == null) {
                    ApkProjectImporter.$$$reportNull$$$0(25);
                }
                try {
                    this.myApkModuleSetup.setUpApkModule(project, context);
                    this.myFileOpener.openFile(context.getApkFile(), project);
                    ApkFacet facet = context.getApkFacet();
                    assert (facet != null);
                    ApkDebuggingUsageTracker.logEvent(facet, AndroidStudioEvent.EventKind.APK_DEBUG_IMPORT);
                    SetupIssueReporter.getInstance(project).reportSetupIssues(facet);
                    if (this.myStartDebugSession) {
                        this.myDebuggerFactory.createNew(project).startDebugSession();
                    }
                }
                catch (Throwable e) {
                    ApkProjectImporter.showAndLogError(e);
                }
                if (!unitTestMode) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (project == null) {
                            ApkProjectImporter.$$$reportNull$$$0(26);
                        }
                        ToolWindows.activateProjectView((Project)project);
                    });
                }
            });
        }
        catch (Throwable e) {
            ApkProjectImporter.showAndLogError(e);
        }
    }

    private static void showAndLogError(@NotNull Throwable e) {
        if (e == null) {
            ApkProjectImporter.$$$reportNull$$$0(21);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
            return;
        }
        Messages.showErrorDialog((String)e.getMessage(), (String)"APK Import");
        ApkProjectImporter.getLog().error(e);
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(ApkProjectImporter.class);
        if (logger == null) {
            ApkProjectImporter.$$$reportNull$$$0(22);
        }
        return logger;
    }

    @VisibleForTesting
    public void setUpApkProjectSynchronous(@NotNull Project project, @NotNull VirtualFile apkFile) throws InterruptedException, ExecutionException, IOException {
        if (project == null) {
            ApkProjectImporter.$$$reportNull$$$0(23);
        }
        if (apkFile == null) {
            ApkProjectImporter.$$$reportNull$$$0(24);
        }
        VirtualFile projectApkFile = this.setUpApkFile(apkFile, project.getBaseDir(), null);
        assert (projectApkFile != null);
        this.createAndSetupMainModule(project, projectApkFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFolderFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProjectSetup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFileSetup";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkModuleFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkModuleSetup";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerFactory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSdkSetup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOpener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFile";
                break;
            }
            case 11: 
            case 13: 
            case 19: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootFolder";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/ApkProjectImporter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/ApkProjectImporter";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setUpApkFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canImport";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "importFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setUpApkProjectAsynchronous";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setUpApkFile";
                break;
            }
            case 16: 
            case 22: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createAndSetupMainModule";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showAndLogError";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setUpApkProjectSynchronous";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createAndSetupMainModule$3";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setUpApkProjectAsynchronous$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

