/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.debugging.DebuggableSharedObjectFile;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.AbiAndSharedObjectFile;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.JTableHeader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DebugSymbolTableView
extends TableView<AbiAndSharedObjectFile> {
    @NotNull
    private final NativeLibrary myLibrary;

    DebugSymbolTableView(@NotNull NativeLibrary library) {
        if (library == null) {
            DebugSymbolTableView.$$$reportNull$$$0(0);
        }
        super(new ListTableModel(new ColumnInfo[]{new AbiColumnInfo(), new SharedObjectFileColumnInfo()}));
        this.myLibrary = library;
        this.updateContents();
        this.setRowHeight(new TextFieldWithBrowseButton().getButton().getPreferredSize().height);
        JTableHeader tableHeader = this.getTableHeader();
        tableHeader.setReorderingAllowed(false);
    }

    void updateContents() {
        this.getListTableModel().setItems(this.extractAbiAndSharedObjectFiles());
    }

    @NotNull
    private List<AbiAndSharedObjectFile> extractAbiAndSharedObjectFiles() {
        ArrayList<AbiAndSharedObjectFile> abiAndFiles = new ArrayList<AbiAndSharedObjectFile>();
        for (Abi abi : this.myLibrary.abis) {
            DebuggableSharedObjectFile file = (DebuggableSharedObjectFile)this.myLibrary.debuggableSharedObjectFilesByAbi.get(abi);
            abiAndFiles.add(new AbiAndSharedObjectFile(abi, file));
        }
        ArrayList<AbiAndSharedObjectFile> arrayList = abiAndFiles;
        if (arrayList == null) {
            DebugSymbolTableView.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/editor/DebugSymbolTableView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/editor/DebugSymbolTableView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractAbiAndSharedObjectFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SharedObjectFileColumnInfo
    extends ColumnInfo<AbiAndSharedObjectFile, String> {
        SharedObjectFileColumnInfo() {
            super("Debuggable Library");
        }

        @Nullable
        public String valueOf(@NotNull AbiAndSharedObjectFile item) {
            DebuggableSharedObjectFile file;
            if (item == null) {
                SharedObjectFileColumnInfo.$$$reportNull$$$0(0);
            }
            return (file = item.getSharedObjectFile()) != null ? file.path : "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/apk/editor/DebugSymbolTableView$SharedObjectFileColumnInfo", "valueOf"));
        }
    }

    private static class AbiColumnInfo
    extends ColumnInfo<AbiAndSharedObjectFile, String> {
        AbiColumnInfo() {
            super("ABI");
        }

        @Nullable
        public String valueOf(@NotNull AbiAndSharedObjectFile item) {
            if (item == null) {
                AbiColumnInfo.$$$reportNull$$$0(0);
            }
            return item.getAbi().toString();
        }

        @NotNull
        public String getMaxStringValue() {
            if ("armeabi-v7a" == null) {
                AbiColumnInfo.$$$reportNull$$$0(1);
            }
            return "armeabi-v7a";
        }

        public int getAdditionalWidth() {
            return 10;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/apk/editor/DebugSymbolTableView$AbiColumnInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/apk/editor/DebugSymbolTableView$AbiColumnInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMaxStringValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "valueOf";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

