/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.ApkDebuggingUsageTracker;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.AsyncResult;
import com.android.tools.idea.apk.LibraryUpdates;
import com.android.tools.idea.apk.debugging.DebuggableSharedObjectFile;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.DebugSymbolTableView;
import com.android.tools.idea.apk.editor.DebugSymbolsEditorForm;
import com.android.tools.idea.apk.editor.PathMappingEditorForm;
import com.android.tools.idea.apk.editor.PathMappingTreeTableView;
import com.android.tools.idea.apk.editor.SharedObjectFileChooserDescriptor;
import com.android.tools.idea.apk.symbols.DebugSymbolNotifications;
import com.android.tools.idea.apk.symbols.DebugSymbolsUpdater;
import com.android.tools.idea.apk.symbols.SharedObjectFile;
import com.android.tools.idea.apk.symbols.SharedObjectFileFinder;
import com.android.tools.idea.apk.symbols.SourceFoldersUpdater;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.util.FileOrFolderChooser;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LibraryEditorForm {
    private static final String NOTIFICATION_TITLE = "APK Debugging";
    @NotNull
    private final ApkFacet myApkFacet;
    @NotNull
    private final Project myProject;
    @NotNull
    private final NativeLibrary myLibrary;
    @NotNull
    private final IdeSdks myIdeSdks;
    @NotNull
    private final SharedObjectFileFinder mySharedObjectFileFinder;
    @NotNull
    private final DebugSymbolsUpdater myDebugSymbolsUpdater;
    @NotNull
    private final SourceFoldersUpdater mySourceFoldersUpdater;
    @NotNull
    private final DebugSymbolNotifications myDebugSymbolNotifications;
    @NotNull
    private final FolderOrSharedObjectFileChooserFactory myFolderOrSharedObjectFileChooserFactory;
    private final PathMappingTreeTableView myPathMappingTableView;
    private final DebugSymbolTableView myDebugSymbolTableView;
    private boolean myContentsUpdated;
    private boolean myPathMappingsCleared;
    private final Splitter mySplitter;
    private final DebugSymbolsEditorForm myDebugSymbolsEditorForm;
    private final PathMappingEditorForm myPathMappingEditorForm;

    LibraryEditorForm(@NotNull ApkFacet apkFacet, @NotNull NativeLibrary library, @Nullable Disposable parent) {
        if (apkFacet == null) {
            LibraryEditorForm.$$$reportNull$$$0(0);
        }
        if (library == null) {
            LibraryEditorForm.$$$reportNull$$$0(1);
        }
        this(apkFacet, library, IdeSdks.getInstance(), new SharedObjectFileFinder(), new DebugSymbolsUpdater(), new SourceFoldersUpdater(), DebugSymbolNotifications.getInstance(), new FolderOrSharedObjectFileChooserFactory(), parent);
    }

    @VisibleForTesting
    LibraryEditorForm(@NotNull ApkFacet apkFacet, @NotNull NativeLibrary library, @NotNull IdeSdks ideSdks, @NotNull SharedObjectFileFinder sharedObjectFileFinder, @NotNull DebugSymbolsUpdater debugSymbolsUpdater, @NotNull SourceFoldersUpdater sourceFoldersUpdater, @NotNull DebugSymbolNotifications debugSymbolNotifications, @NotNull FolderOrSharedObjectFileChooserFactory folderOrSharedObjectFileChooserFactory, @Nullable Disposable parent) {
        if (apkFacet == null) {
            LibraryEditorForm.$$$reportNull$$$0(2);
        }
        if (library == null) {
            LibraryEditorForm.$$$reportNull$$$0(3);
        }
        if (ideSdks == null) {
            LibraryEditorForm.$$$reportNull$$$0(4);
        }
        if (sharedObjectFileFinder == null) {
            LibraryEditorForm.$$$reportNull$$$0(5);
        }
        if (debugSymbolsUpdater == null) {
            LibraryEditorForm.$$$reportNull$$$0(6);
        }
        if (sourceFoldersUpdater == null) {
            LibraryEditorForm.$$$reportNull$$$0(7);
        }
        if (debugSymbolNotifications == null) {
            LibraryEditorForm.$$$reportNull$$$0(8);
        }
        if (folderOrSharedObjectFileChooserFactory == null) {
            LibraryEditorForm.$$$reportNull$$$0(9);
        }
        this.myApkFacet = apkFacet;
        this.myLibrary = library;
        this.myIdeSdks = ideSdks;
        this.mySharedObjectFileFinder = sharedObjectFileFinder;
        this.myDebugSymbolsUpdater = debugSymbolsUpdater;
        this.mySourceFoldersUpdater = sourceFoldersUpdater;
        this.myDebugSymbolNotifications = debugSymbolNotifications;
        this.myFolderOrSharedObjectFileChooserFactory = folderOrSharedObjectFileChooserFactory;
        this.myProject = apkFacet.getModule().getProject();
        this.mySplitter = new OnePixelSplitter(true, "apk.debugging.library.editor.splitter.proportion", 0.5f);
        this.mySplitter.setName("libraryEditorForm");
        this.myDebugSymbolsEditorForm = new DebugSymbolsEditorForm();
        this.mySplitter.setFirstComponent((JComponent)this.myDebugSymbolsEditorForm.mainPanel);
        this.myPathMappingEditorForm = new PathMappingEditorForm();
        this.mySplitter.setSecondComponent((JComponent)this.myPathMappingEditorForm.mainPanel);
        if (parent != null) {
            LibraryUpdates.subscribe(this.myProject, libraries -> {
                if (library == null) {
                    LibraryEditorForm.$$$reportNull$$$0(30);
                }
                if (libraries.contains(library)) {
                    this.updateContents();
                }
            }, parent);
        }
        this.setFormBackground();
        this.myPathMappingEditorForm.notificationLabel.setBorder(JBUI.Borders.empty((int)2));
        this.myPathMappingEditorForm.notificationLabel.setName("pathMappingsLabel");
        this.myDebugSymbolTableView = new DebugSymbolTableView(this.myLibrary);
        this.myDebugSymbolsEditorForm.viewPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myDebugSymbolTableView)), "Center");
        this.myDebugSymbolsEditorForm.addButton.addActionListener(e -> this.findAndAttachDebuggableSharedObjectFiles());
        this.myDebugSymbolsEditorForm.clearButton.addActionListener(e -> this.clearDebugSymbolsFilePaths());
        this.myPathMappingTableView = PathMappingTreeTableView.create(this.myLibrary, this.myProject);
        this.myPathMappingTableView.addPropertyChangeListener("pathMappings", evt -> {
            Map mappings = (Map)evt.getNewValue();
            if (mappings.equals(this.myLibrary.pathMappings)) {
                return;
            }
            this.myLibrary.replacePathMappingsWith(mappings);
            this.myPathMappingEditorForm.applyChangesLabel.setVisible(true);
        });
        this.myPathMappingTableView.setName("pathMappingTable");
        this.myPathMappingEditorForm.viewPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myPathMappingTableView)), "Center");
        this.updateContents();
        this.myPathMappingEditorForm.clearButton.addActionListener(e -> this.clearPathMappings());
        this.myPathMappingEditorForm.applyChangesLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                LibraryEditorForm.this.applyPathMappings();
            }
        });
    }

    private void findAndAttachDebuggableSharedObjectFiles() {
        Project project;
        FileOrFolderChooser fileOrFolderChooser = this.myFolderOrSharedObjectFileChooserFactory.create(this.myApkFacet);
        VirtualFile[] chosen = fileOrFolderChooser.choose(project = this.myProject);
        if (chosen.length > 0) {
            AsyncResult<List<SharedObjectFile>> callback = this.mySharedObjectFileFinder.findSharedObjectFiles(chosen, this.myLibrary, project);
            callback.doWhenDone(() -> {
                List result = (List)callback.getResult();
                assert (result != null);
                this.attachDebuggableSharedObjectFiles(result, chosen);
            });
            this.logAndNotifyIfRejected(callback);
        }
    }

    private void attachDebuggableSharedObjectFiles(@NotNull List<SharedObjectFile> files, @NotNull VirtualFile[] userSelection) {
        int fileCount;
        if (files == null) {
            LibraryEditorForm.$$$reportNull$$$0(10);
        }
        if (userSelection == null) {
            LibraryEditorForm.$$$reportNull$$$0(11);
        }
        if ((fileCount = files.size()) == 0) {
            this.notifyDebuggableSharedObjectFilesNotFound(userSelection);
            return;
        }
        ArrayList<SharedObjectFile> filesWithoutAbi = new ArrayList<SharedObjectFile>();
        ArrayList<SharedObjectFile> filesWithoutDebugSymbols = new ArrayList<SharedObjectFile>();
        ArrayList<SharedObjectFile> debuggableFiles = new ArrayList<SharedObjectFile>();
        for (SharedObjectFile file : files) {
            Abi abi = file.getAbi();
            if (abi == null) {
                filesWithoutAbi.add(file);
                continue;
            }
            if (file.getDebugSymbolPaths().isEmpty()) {
                filesWithoutDebugSymbols.add(file);
                continue;
            }
            debuggableFiles.add(file);
        }
        if (!filesWithoutAbi.isEmpty() || !filesWithoutDebugSymbols.isEmpty()) {
            this.notifyUserAboutIgnoredFiles(filesWithoutAbi, filesWithoutDebugSymbols);
            return;
        }
        this.attach(debuggableFiles);
    }

    private void notifyDebuggableSharedObjectFilesNotFound(@NotNull VirtualFile[] userSelection) {
        if (userSelection == null) {
            LibraryEditorForm.$$$reportNull$$$0(12);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("Unable to find any debuggable shared object files from the selection:");
        for (VirtualFile file : userSelection) {
            buffer.append("<br/> - ").append(FileUtil.toSystemDependentName((String)file.getPath()));
        }
        String message = buffer.toString();
        LibraryEditorForm.getLog().warn(message);
        this.notifyUser(message, NotificationType.ERROR);
    }

    private void notifyUserAboutIgnoredFiles(@NotNull List<SharedObjectFile> filesWithoutAbi, @NotNull List<SharedObjectFile> filesWithoutDebugSymbols) {
        boolean missingAbis;
        if (filesWithoutAbi == null) {
            LibraryEditorForm.$$$reportNull$$$0(13);
        }
        if (filesWithoutDebugSymbols == null) {
            LibraryEditorForm.$$$reportNull$$$0(14);
        }
        StringBuilder buffer = new StringBuilder();
        boolean bl = missingAbis = !filesWithoutAbi.isEmpty();
        if (missingAbis) {
            buffer.append("Unable to detect the ABI for file(s):");
            for (SharedObjectFile file : filesWithoutAbi) {
                buffer.append("<br/> - ").append(file.getPath().getPath());
            }
        }
        if (!filesWithoutDebugSymbols.isEmpty()) {
            if (missingAbis) {
                buffer.append("<br/>");
            }
            buffer.append("Unable to find debug symbols in file(s):");
            for (SharedObjectFile file : filesWithoutDebugSymbols) {
                buffer.append("<br/> - ").append(file.getPath().getPath());
            }
        }
        String message = buffer.toString();
        LibraryEditorForm.getLog().warn(message);
        this.notifyUser(message, NotificationType.WARNING);
    }

    private void attach(@NotNull List<SharedObjectFile> debuggableFiles) {
        if (debuggableFiles == null) {
            LibraryEditorForm.$$$reportNull$$$0(15);
        }
        AsyncResult<List<DebuggableSharedObjectFile>> callback = this.myDebugSymbolsUpdater.updateDebugSymbolsInLibrary(debuggableFiles, this.myLibrary, this.myApkFacet);
        callback.doWhenDone(() -> {
            List addedFiles = (List)callback.getResult();
            assert (addedFiles != null);
            if (!addedFiles.isEmpty()) {
                this.myPathMappingsCleared = true;
                this.updateContents();
                this.updateSourceFolders();
            }
        });
        this.logAndNotifyIfRejected(callback);
    }

    private void logAndNotifyIfRejected(@NotNull AsyncResult<?> callback) {
        if (callback == null) {
            LibraryEditorForm.$$$reportNull$$$0(16);
        }
        callback.doWhenRejected(() -> {
            Throwable error;
            if (callback == null) {
                LibraryEditorForm.$$$reportNull$$$0(29);
            }
            if ((error = callback.getUnexpectedError()) != null) {
                this.logAndNotify(error);
            }
        });
    }

    private void logAndNotify(@NotNull Throwable error) {
        if (error == null) {
            LibraryEditorForm.$$$reportNull$$$0(17);
        }
        String message = "Unexpected error: " + error.getMessage();
        LibraryEditorForm.getLog().warn(message, error);
        this.notifyUser(message, NotificationType.ERROR);
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(LibraryEditorForm.class);
        if (logger == null) {
            LibraryEditorForm.$$$reportNull$$$0(18);
        }
        return logger;
    }

    private void notifyUser(@NotNull String text, @NotNull NotificationType notificationType) {
        if (text == null) {
            LibraryEditorForm.$$$reportNull$$$0(19);
        }
        if (notificationType == null) {
            LibraryEditorForm.$$$reportNull$$$0(20);
        }
        AndroidNotification.getInstance((Project)this.myProject).showBalloon(NOTIFICATION_TITLE, text, notificationType);
    }

    private void setFormBackground() {
        Color background = UIUtil.getTableBackground();
        this.myDebugSymbolsEditorForm.mainPanel.setBackground(background);
        this.myDebugSymbolsEditorForm.viewPanel.setBackground(background);
        this.myDebugSymbolsEditorForm.actionsPanel.setBackground(background);
        this.myDebugSymbolsEditorForm.addButton.setBackground(background);
        this.myDebugSymbolsEditorForm.clearButton.setBackground(background);
        this.myPathMappingEditorForm.mainPanel.setBackground(background);
        this.myPathMappingEditorForm.viewPanel.setBackground(background);
        this.myPathMappingEditorForm.actionsPanel.setBackground(background);
        this.myPathMappingEditorForm.clearButton.setBackground(background);
    }

    @VisibleForTesting
    void clearDebugSymbolsFilePaths() {
        String text = "This action will remove all the source folders containing native code. You will not be able to debug native code until you manually add debug symbols again.\nAre you sure you want to continue?";
        int clear = Messages.showYesNoDialog((Project)this.myProject, (String)text, (String)"Library Setup", (Icon)Messages.getQuestionIcon());
        if (clear == 0) {
            List sourceFolders = this.myLibrary.getSourceFolderPaths();
            AsyncResult<Void> callback = this.mySourceFoldersUpdater.removeSourceFolders(sourceFolders, this.myApkFacet.getModule());
            callback.doWhenDone(() -> {
                this.myLibrary.clearDebugSymbols();
                this.updateContents();
                this.myDebugSymbolNotifications.notifyLibraryUpdated(this.myApkFacet, this.myLibrary);
            });
            this.logAndNotifyIfRejected(callback);
        }
    }

    @VisibleForTesting
    void clearPathMappings() {
        boolean hasNdkPaths = false;
        Map pathMappings = this.myLibrary.pathMappings;
        for (Map.Entry entry : pathMappings.entrySet()) {
            entry.setValue("");
            if (hasNdkPaths || !this.myDebugSymbolsUpdater.isNdkPath((String)entry.getKey())) continue;
            hasNdkPaths = true;
        }
        if (hasNdkPaths) {
            String string;
            int mapNdkPaths;
            File ndkPath = null;
            if (this.myIdeSdks.getAndroidNdkPath() != null && (mapNdkPaths = Messages.showYesNoDialog((Project)this.myProject, (String)(string = "Do you want to have NDK paths automatically mapped?"), (String)"Path Mapping", (Icon)Messages.getQuestionIcon())) == 0) {
                ndkPath = this.myIdeSdks.getAndroidNdkPath();
            }
            this.myDebugSymbolsUpdater.updatePathMappingValues(this.myLibrary, pathMappings.keySet(), ndkPath);
        }
        this.myPathMappingsCleared = true;
        this.updateContents();
    }

    @VisibleForTesting
    void applyPathMappings() {
        Map<String, String> pathMappings = this.myPathMappingTableView.getEnteredPathMappings();
        if (!pathMappings.isEmpty()) {
            this.myLibrary.replacePathMappingsWith(pathMappings);
            this.updateSourceFolders();
            ApkDebuggingUsageTracker.logEvent(this.myApkFacet, AndroidStudioEvent.EventKind.APK_DEBUG_SELECT_PATH_MAPPINGS);
        }
        this.myPathMappingEditorForm.applyChangesLabel.setVisible(false);
    }

    private void updateSourceFolders() {
        AsyncResult<Void> callback = this.mySourceFoldersUpdater.updateSourceFolders(this.myApkFacet);
        callback.doWhenDone(() -> {
            this.updateContents();
            this.myDebugSymbolNotifications.notifyLibraryUpdated(this.myApkFacet, this.myLibrary);
        });
        this.logAndNotifyIfRejected(callback);
    }

    @VisibleForTesting
    void updateContents() {
        Runnable task = () -> {
            this.updateDebugSymbolStatus();
            this.updatePathMappingsStatus();
            this.myDebugSymbolsEditorForm.clearButton.setEnabled(!this.myLibrary.debuggableSharedObjectFilesByAbi.isEmpty());
            this.myDebugSymbolTableView.updateContents();
            this.myPathMappingTableView.updateContents();
            boolean clearActionEnabled = this.myLibrary.needsPathMappings() && !this.myLibrary.getUserSelectedPathsInMappings().isEmpty();
            this.myPathMappingEditorForm.clearButton.setEnabled(clearActionEnabled);
            this.myPathMappingEditorForm.applyChangesLabel.setVisible(this.myPathMappingsCleared && this.myLibrary.needsPathMappings());
            this.myContentsUpdated = true;
            this.myPathMappingsCleared = false;
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            task.run();
        } else {
            application.invokeLater(task);
        }
    }

    boolean isContentsUpdated() {
        return this.myContentsUpdated;
    }

    private void updateDebugSymbolStatus() {
        String text;
        Icon icon;
        if (this.myLibrary.hasDebugSymbols) {
            icon = LibraryEditorForm.getGreenCheckIcon();
            text = "<html>The library already has debug symbols.</html>";
        } else {
            icon = LibraryEditorForm.getWarningIcon();
            text = "<html>The library is missing debug symbols. Please attach an external library file containing debug symbols.</html>";
        }
        this.myDebugSymbolsEditorForm.notificationLabel.setIcon(icon);
        this.myDebugSymbolsEditorForm.notificationLabel.setText(text);
    }

    @VisibleForTesting
    void updatePathMappingsStatus() {
        String text;
        Icon icon = LibraryEditorForm.getGreenCheckIcon();
        if (this.myLibrary.needsPathMappings()) {
            boolean missingPathMappings = this.myLibrary.isMissingPathMappings();
            if (missingPathMappings) {
                icon = LibraryEditorForm.getWarningIcon();
                text = "One or more debug symbols point to paths not found on this machine. Please map those paths to local ones.";
            } else {
                text = "All debug symbol paths are mapped to local paths.";
            }
        } else {
            text = "Path mappings are not needed.";
        }
        this.myPathMappingEditorForm.notificationLabel.setIcon(icon);
        this.myPathMappingEditorForm.notificationLabel.setText(text);
    }

    @VisibleForTesting
    @NotNull
    String getPathMappingsStatusText() {
        String string = this.myPathMappingEditorForm.notificationLabel.getText();
        if (string == null) {
            LibraryEditorForm.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static Icon getWarningIcon() {
        Icon icon = AllIcons.General.BalloonWarning;
        if (icon == null) {
            LibraryEditorForm.$$$reportNull$$$0(22);
        }
        return icon;
    }

    @NotNull
    private static Icon getGreenCheckIcon() {
        Icon icon = AllIcons.Debugger.ThreadStates.Idle;
        if (icon == null) {
            LibraryEditorForm.$$$reportNull$$$0(23);
        }
        return icon;
    }

    @NotNull
    JPanel getMainPanel() {
        Splitter splitter = this.mySplitter;
        if (splitter == null) {
            LibraryEditorForm.$$$reportNull$$$0(24);
        }
        return splitter;
    }

    @VisibleForTesting
    @NotNull
    NativeLibrary getLibrary() {
        NativeLibrary nativeLibrary = this.myLibrary;
        if (nativeLibrary == null) {
            LibraryEditorForm.$$$reportNull$$$0(25);
        }
        return nativeLibrary;
    }

    @NotNull
    Map<String, String> getDisplayedPathMappings() {
        Map<String, String> map = this.myPathMappingTableView.getEnteredPathMappings();
        if (map == null) {
            LibraryEditorForm.$$$reportNull$$$0(26);
        }
        return map;
    }

    void updatePathMapping(@NotNull String originalPath, @NotNull String selectedPath) {
        if (originalPath == null) {
            LibraryEditorForm.$$$reportNull$$$0(27);
        }
        if (selectedPath == null) {
            LibraryEditorForm.$$$reportNull$$$0(28);
        }
        this.myPathMappingTableView.updatePathMapping(originalPath, selectedPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFacet";
                break;
            }
            case 1: 
            case 3: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideSdks";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedObjectFileFinder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSymbolsUpdater";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFoldersUpdater";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSymbolNotifications";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderOrSharedObjectFileChooserFactory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userSelection";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesWithoutAbi";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesWithoutDebugSymbols";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggableFiles";
                break;
            }
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/editor/LibraryEditorForm";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/editor/LibraryEditorForm";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappingsStatusText";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningIcon";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getGreenCheckIcon";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrary";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedPathMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "attachDebuggableSharedObjectFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "notifyDebuggableSharedObjectFilesNotFound";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "notifyUserAboutIgnoredFiles";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "attach";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "logAndNotifyIfRejected";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "logAndNotify";
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "notifyUser";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updatePathMapping";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$logAndNotifyIfRejected$7";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class FolderOrSharedObjectFileChooserFactory {
        FolderOrSharedObjectFileChooserFactory() {
        }

        @NotNull
        FileOrFolderChooser create(@NotNull ApkFacet facet) {
            if (facet == null) {
                FolderOrSharedObjectFileChooserFactory.$$$reportNull$$$0(0);
            }
            FileOrFolderChooser fileOrFolderChooser = project -> {
                if (facet == null) {
                    FolderOrSharedObjectFileChooserFactory.$$$reportNull$$$0(2);
                }
                SharedObjectFileChooserDescriptor descriptor = new SharedObjectFileChooserDescriptor(facet);
                FileChooserDialogImpl chooser = new FileChooserDialogImpl((FileChooserDescriptor)descriptor, project);
                return chooser.choose(project, new VirtualFile[0]);
            };
            if (fileOrFolderChooser == null) {
                FolderOrSharedObjectFileChooserFactory.$$$reportNull$$$0(1);
            }
            return fileOrFolderChooser;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/apk/editor/LibraryEditorForm$FolderOrSharedObjectFileChooserFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/apk/editor/LibraryEditorForm$FolderOrSharedObjectFileChooserFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$create$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

