/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.LibraryFolder;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.LibraryEditor;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        AndroidProjectInfo projectInfo;
        if (project == null) {
            LibraryEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            LibraryEditorProvider.$$$reportNull$$$0(1);
        }
        if ((projectInfo = AndroidProjectInfo.getInstance((Project)project)).isApkProject() && "so".equals(file.getExtension())) {
            VirtualFile libFolder = LibraryEditorProvider.findParentWithName(file, LibraryFolder.getName());
            return libFolder != null && VfsUtilCore.isAncestor((VirtualFile)project.getBaseDir(), (VirtualFile)libFolder, (boolean)true);
        }
        return false;
    }

    @Nullable
    private static VirtualFile findParentWithName(@NotNull VirtualFile file, @NotNull String name) {
        if (file == null) {
            LibraryEditorProvider.$$$reportNull$$$0(2);
        }
        if (name == null) {
            LibraryEditorProvider.$$$reportNull$$$0(3);
        }
        for (VirtualFile current = file; current != null; current = current.getParent()) {
            if (!name.equals(current.getName())) continue;
            return current;
        }
        return null;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            LibraryEditorProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            LibraryEditorProvider.$$$reportNull$$$0(5);
        }
        Pair<ApkFacet, NativeLibrary> facetAndLibrary = LibraryEditorProvider.findFacetAndLibraryContainingFile(file, project);
        assert (facetAndLibrary != null);
        LibraryEditor libraryEditor = new LibraryEditor(file, (ApkFacet)facetAndLibrary.getFirst(), (NativeLibrary)facetAndLibrary.getSecond());
        if (libraryEditor == null) {
            LibraryEditorProvider.$$$reportNull$$$0(6);
        }
        return libraryEditor;
    }

    @Nullable
    private static Pair<ApkFacet, NativeLibrary> findFacetAndLibraryContainingFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            LibraryEditorProvider.$$$reportNull$$$0(7);
        }
        if (project == null) {
            LibraryEditorProvider.$$$reportNull$$$0(8);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ApkFacet facet = ApkFacet.getInstance((Module)module);
            if (facet == null) continue;
            for (NativeLibrary library : ((ApkFacetConfiguration)facet.getConfiguration()).NATIVE_LIBRARIES) {
                if (!library.sharedObjectFilesByAbi.containsValue(file)) continue;
                return Pair.create((Object)facet, (Object)library);
            }
        }
        return null;
    }

    @NotNull
    public String getEditorTypeId() {
        if ("apk-native-library" == null) {
            LibraryEditorProvider.$$$reportNull$$$0(9);
        }
        return "apk-native-library";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            LibraryEditorProvider.$$$reportNull$$$0(10);
        }
        return fileEditorPolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/editor/LibraryEditorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/editor/LibraryEditorProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTypeId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findParentWithName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFacetAndLibraryContainingFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

