/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.tools.idea.apk.symbols.ui.PathMapping;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

class PathMappingNode
extends DefaultMutableTreeNode {
    @NotNull
    private final PathMapping myPathMapping;
    @NotNull
    private final List<String> myRelativePathSegments;

    PathMappingNode(@NotNull String pathSegment, @NotNull PathMapping pathMapping) {
        if (pathSegment == null) {
            PathMappingNode.$$$reportNull$$$0(0);
        }
        if (pathMapping == null) {
            PathMappingNode.$$$reportNull$$$0(1);
        }
        this.myRelativePathSegments = new ArrayList<String>();
        this.myRelativePathSegments.add(pathSegment);
        this.myPathMapping = pathMapping;
    }

    @NotNull
    String getPathSegment() {
        String string = this.myRelativePathSegments.get(this.myRelativePathSegments.size() - 1);
        if (string == null) {
            PathMappingNode.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    List<String> getRelativePathSegments() {
        List<String> list = this.myRelativePathSegments;
        if (list == null) {
            PathMappingNode.$$$reportNull$$$0(3);
        }
        return list;
    }

    void update(@NotNull String pathSegment, @NotNull String filePath) {
        if (pathSegment == null) {
            PathMappingNode.$$$reportNull$$$0(4);
        }
        if (filePath == null) {
            PathMappingNode.$$$reportNull$$$0(5);
        }
        this.myRelativePathSegments.add(pathSegment);
        this.myPathMapping.setOriginalPath(filePath);
    }

    @NotNull
    String getFilePath() {
        String string = this.myPathMapping.getOriginalPath();
        if (string == null) {
            PathMappingNode.$$$reportNull$$$0(6);
        }
        return string;
    }

    void updateDisplayedText() {
        TreeNode parent = this.getParent();
        if (parent instanceof PathMappingNode) {
            String parentPath = ((PathMappingNode)parent).getFilePath();
            String filePath = this.getFilePath();
            if ((filePath = filePath.substring(parentPath.length())).length() > 1 && (filePath.startsWith("/") || filePath.startsWith("\\"))) {
                filePath = filePath.substring(1);
            }
            this.updateDisplayedText(filePath);
        } else {
            this.updateDisplayedText(this.getFilePath());
        }
    }

    private void updateDisplayedText(@NotNull String text) {
        if (text == null) {
            PathMappingNode.$$$reportNull$$$0(7);
        }
        this.setUserObject(text);
    }

    @NotNull
    PathMapping getPathMapping() {
        PathMapping pathMapping = this.myPathMapping;
        if (pathMapping == null) {
            PathMappingNode.$$$reportNull$$$0(8);
        }
        return pathMapping;
    }

    void deriveSelectedPathFromParent() {
        TreeNode parent;
        if (this.myPathMapping.getSelectedPath().isEmpty() && (parent = this.getParent()) instanceof PathMappingNode) {
            this.deriveSelectedPathFrom((PathMappingNode)parent);
        }
    }

    private void deriveSelectedPathFrom(@NotNull PathMappingNode parent) {
        String selectedPath;
        if (parent == null) {
            PathMappingNode.$$$reportNull$$$0(9);
        }
        if (!(selectedPath = parent.getPathMapping().getSelectedPath()).isEmpty()) {
            this.deriveSelectedPathFrom(new File(selectedPath));
        }
    }

    private void deriveSelectedPathFrom(@NotNull File path) {
        File myPotentialPath;
        if (path == null) {
            PathMappingNode.$$$reportNull$$$0(10);
        }
        if (path.isDirectory() && (myPotentialPath = new File(path, FileUtil.join((String[])ArrayUtil.toStringArray(this.myRelativePathSegments)))).isDirectory()) {
            this.myPathMapping.setSelectedPath(myPotentialPath.getPath());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathSegment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapping";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/editor/PathMappingNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/editor/PathMappingNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathSegment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePathSegments";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateDisplayedText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deriveSelectedPathFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

