/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.PathMappingNode;
import com.android.tools.idea.apk.paths.PathNode;
import com.android.tools.idea.apk.paths.PathNodeParent;
import com.android.tools.idea.apk.paths.PathTree;
import com.android.tools.idea.apk.symbols.ui.PathMapping;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteFile;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

class PathMappingRootNode
extends DefaultMutableTreeNode {
    @NotNull
    private final NativeLibrary myLibrary;

    PathMappingRootNode(@NotNull NativeLibrary library) {
        if (library == null) {
            PathMappingRootNode.$$$reportNull$$$0(0);
        }
        this.myLibrary = library;
    }

    void updateChildren() {
        this.removeAllChildren();
        Set entries = this.myLibrary.pathMappings.entrySet();
        if (!entries.isEmpty()) {
            ArrayList originalPaths = new ArrayList();
            for (Map.Entry entry : entries) {
                originalPaths.add(entry.getKey());
            }
            Collections.sort(originalPaths);
            PathTree tree = new PathTree();
            Iterator iterator = originalPaths.iterator();
            while (iterator.hasNext()) {
                String originalPath;
                boolean isWindows = RemoteFile.isWindowsPath((String)(originalPath = (String)iterator.next()));
                tree.addPath(originalPath, isWindows ? (char)'\\' : '/');
            }
            for (PathNode pathNode : tree.getChildren()) {
                this.addPathMapping(this, pathNode);
            }
            TreeUtil.traverse((TreeNode)this, node -> {
                if (node instanceof PathMappingNode) {
                    PathMappingNode pathMappingNode = (PathMappingNode)node;
                    pathMappingNode.updateDisplayedText();
                    PathMapping pathMapping = pathMappingNode.getPathMapping();
                    String mappedPath = (String)this.myLibrary.pathMappings.get(pathMapping.getOriginalPath());
                    if (!StringUtil.isEmpty((String)mappedPath)) {
                        pathMapping.setSelectedPath(mappedPath);
                    } else {
                        pathMappingNode.deriveSelectedPathFromParent();
                    }
                }
                return true;
            });
        }
    }

    private void addPathMapping(@NotNull DefaultMutableTreeNode treeNode, @NotNull PathNode pathNode) {
        if (treeNode == null) {
            PathMappingRootNode.$$$reportNull$$$0(1);
        }
        if (pathNode == null) {
            PathMappingRootNode.$$$reportNull$$$0(2);
        }
        DefaultMutableTreeNode parent = pathNode.getPathSegment().isEmpty() && pathNode.getPath().isEmpty() ? treeNode : this.getOrCreateParent(treeNode, pathNode);
        for (PathNode child : pathNode.getChildren()) {
            this.addPathMapping(parent, child);
        }
    }

    @NotNull
    private PathMappingNode getOrCreateParent(@NotNull DefaultMutableTreeNode treeNode, @NotNull PathNode pathNode) {
        if (treeNode == null) {
            PathMappingRootNode.$$$reportNull$$$0(3);
        }
        if (pathNode == null) {
            PathMappingRootNode.$$$reportNull$$$0(4);
        }
        if (PathMappingRootNode.shouldForceNodeCreation(pathNode)) {
            PathMappingNode pathMappingNode = this.createAndAddChild(treeNode, pathNode);
            if (pathMappingNode == null) {
                PathMappingRootNode.$$$reportNull$$$0(5);
            }
            return pathMappingNode;
        }
        if (treeNode instanceof PathMappingNode) {
            PathMappingNode node = (PathMappingNode)treeNode;
            node.update(pathNode.getPathSegment(), pathNode.getPath());
            PathMappingNode pathMappingNode = node;
            if (pathMappingNode == null) {
                PathMappingRootNode.$$$reportNull$$$0(6);
            }
            return pathMappingNode;
        }
        PathMappingNode pathMappingNode = this.createAndAddChild(treeNode, pathNode);
        if (pathMappingNode == null) {
            PathMappingRootNode.$$$reportNull$$$0(7);
        }
        return pathMappingNode;
    }

    @NotNull
    private PathMappingNode createAndAddChild(@NotNull DefaultMutableTreeNode treeNode, @NotNull PathNode pathNode) {
        if (treeNode == null) {
            PathMappingRootNode.$$$reportNull$$$0(8);
        }
        if (pathNode == null) {
            PathMappingRootNode.$$$reportNull$$$0(9);
        }
        String filePath = pathNode.getPath();
        String mappedPath = "";
        if (this.myLibrary.containsMappingForRemotePath(filePath)) {
            mappedPath = (String)this.myLibrary.pathMappings.get(filePath);
        }
        PathMapping pathMapping = new PathMapping(filePath, mappedPath);
        PathMappingNode child = new PathMappingNode(pathNode.getPathSegment(), pathMapping);
        treeNode.add(child);
        child.deriveSelectedPathFromParent();
        PathMappingNode pathMappingNode = child;
        if (pathMappingNode == null) {
            PathMappingRootNode.$$$reportNull$$$0(10);
        }
        return pathMappingNode;
    }

    private static boolean shouldForceNodeCreation(@NotNull PathNode pathNode) {
        PathNodeParent parent;
        if (pathNode == null) {
            PathMappingRootNode.$$$reportNull$$$0(11);
        }
        return (parent = pathNode.getParent()) != null && parent.getChildren().size() > 1;
    }

    @NotNull
    NativeLibrary getLibrary() {
        NativeLibrary nativeLibrary = this.myLibrary;
        if (nativeLibrary == null) {
            PathMappingRootNode.$$$reportNull$$$0(12);
        }
        return nativeLibrary;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeNode";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathNode";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/editor/PathMappingRootNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/editor/PathMappingRootNode";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateParent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAddChild";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addPathMapping";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateParent";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddChild";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldForceNodeCreation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

