/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.PathMappingNode;
import com.android.tools.idea.apk.editor.PathMappingRootNode;
import com.android.tools.idea.apk.editor.PathMappingTreeTableViewModel;
import com.android.tools.idea.apk.symbols.ui.FilePathTreeCellRenderer;
import com.android.tools.idea.apk.symbols.ui.PathMapping;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PathMappingTreeTableView
extends TreeTableView {
    static final String PATH_MAPPINGS_PROPERTY = "pathMappings";
    private final PathMappingRootNode myRootNode;

    @NotNull
    static PathMappingTreeTableView create(@NotNull NativeLibrary library, @NotNull Project project) {
        if (library == null) {
            PathMappingTreeTableView.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PathMappingTreeTableView.$$$reportNull$$$0(1);
        }
        PathMappingTreeTableView pathMappingTreeTableView = new PathMappingTreeTableView(new PathMappingTreeTableViewModel(library, project));
        if (pathMappingTreeTableView == null) {
            PathMappingTreeTableView.$$$reportNull$$$0(2);
        }
        return pathMappingTreeTableView;
    }

    @VisibleForTesting
    PathMappingTreeTableView(@NotNull PathMappingTreeTableViewModel model) {
        if (model == null) {
            PathMappingTreeTableView.$$$reportNull$$$0(3);
        }
        super((ListTreeTableModelOnColumns)model);
        this.myRootNode = model.getRoot();
        TreeTableTree tree = this.getTree();
        TreeUtil.installActions((JTree)tree);
        tree.setToggleClickCount(0);
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.setCellRenderer((TreeCellRenderer)((Object)new FilePathTreeCellRenderer((JTree)tree)));
        this.setRowHeight(new TextFieldWithBrowseButton().getButton().getPreferredSize().height);
        this.getTableHeader().setReorderingAllowed(false);
        this.updateContents();
        model.view = this;
        new TreeTableSpeedSearch((TreeTable)this, (Convertor)new PathToStringConvertor());
    }

    void tableChanged() {
        if (this.myRootNode != null) {
            NativeLibrary library = this.myRootNode.getLibrary();
            Map<String, String> mappings = this.getEnteredPathMappings();
            this.firePropertyChange(PATH_MAPPINGS_PROPERTY, library.pathMappings, mappings);
        }
    }

    @NotNull
    PathMappingRootNode getRootNode() {
        PathMappingRootNode pathMappingRootNode = this.myRootNode;
        if (pathMappingRootNode == null) {
            PathMappingTreeTableView.$$$reportNull$$$0(4);
        }
        return pathMappingRootNode;
    }

    @NotNull
    Map<String, String> getEnteredPathMappings() {
        LinkedHashMap<String, String> mappings = new LinkedHashMap<String, String>();
        TreeUtil.traverse((TreeNode)this.myRootNode, node -> {
            if (node instanceof PathMappingNode) {
                File path;
                PathMappingNode pathMappingNode = (PathMappingNode)node;
                PathMapping pathMapping = pathMappingNode.getPathMapping();
                String selectedPath = pathMapping.getSelectedPath();
                if (pathMappingNode.isLeaf()) {
                    mappings.put(pathMapping.getOriginalPath(), selectedPath);
                } else if (!selectedPath.isEmpty() && !PathMappingTreeTableView.isParentSelectedPathAncestor(pathMappingNode) && (path = new File(selectedPath)).isDirectory()) {
                    mappings.put(pathMapping.getOriginalPath(), selectedPath);
                }
            }
            return true;
        });
        LinkedHashMap<String, String> linkedHashMap = mappings;
        if (linkedHashMap == null) {
            PathMappingTreeTableView.$$$reportNull$$$0(5);
        }
        return linkedHashMap;
    }

    private static boolean isParentSelectedPathAncestor(@NotNull PathMappingNode pathMappingNode) {
        if (pathMappingNode == null) {
            PathMappingTreeTableView.$$$reportNull$$$0(6);
        }
        PathMapping pathMapping = pathMappingNode.getPathMapping();
        String selectedPath = pathMapping.getSelectedPath();
        String parentSelectedPath = PathMappingTreeTableView.getSelectedPathFromParent(pathMappingNode);
        return StringUtil.isNotEmpty((String)parentSelectedPath) && FileUtil.isAncestor((String)parentSelectedPath, (String)selectedPath, (boolean)true);
    }

    @Nullable
    private static String getSelectedPathFromParent(@NotNull PathMappingNode pathMappingNode) {
        TreeNode parent;
        if (pathMappingNode == null) {
            PathMappingTreeTableView.$$$reportNull$$$0(7);
        }
        if ((parent = pathMappingNode.getParent()) instanceof PathMappingNode) {
            return ((PathMappingNode)parent).getPathMapping().getSelectedPath();
        }
        return null;
    }

    void updateContents() {
        this.myRootNode.updateChildren();
        this.updateUI();
        TreeUtil.expandAll((JTree)this.getTree());
    }

    void updatePathMapping(@NotNull String originalPath, @NotNull String selectedPath) {
        if (originalPath == null) {
            PathMappingTreeTableView.$$$reportNull$$$0(8);
        }
        if (selectedPath == null) {
            PathMappingTreeTableView.$$$reportNull$$$0(9);
        }
        TreeUtil.traverse((TreeNode)this.myRootNode, node -> {
            PathMappingNode pathMappingNode;
            PathMapping pathMapping;
            if (originalPath == null) {
                PathMappingTreeTableView.$$$reportNull$$$0(14);
            }
            if (selectedPath == null) {
                PathMappingTreeTableView.$$$reportNull$$$0(15);
            }
            if (node instanceof PathMappingNode && (pathMapping = (pathMappingNode = (PathMappingNode)node).getPathMapping()).getOriginalPath().equals(originalPath)) {
                pathMapping.setSelectedPath(selectedPath);
            }
            return true;
        });
    }

    @NotNull
    List<PathMapping> getInternalPathMappings() {
        ArrayList<PathMapping> pathMappings = new ArrayList<PathMapping>();
        TreeUtil.traverse((TreeNode)this.myRootNode, node -> {
            if (node instanceof PathMappingNode) {
                pathMappings.add(((PathMappingNode)node).getPathMapping());
            }
            return true;
        });
        ArrayList<PathMapping> arrayList = pathMappings;
        if (arrayList == null) {
            PathMappingTreeTableView.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    PathMappingNode findNodeWithOriginalPath(@NotNull String originalPath) {
        if (originalPath == null) {
            PathMappingTreeTableView.$$$reportNull$$$0(11);
        }
        return PathMappingTreeTableView.findNodeWithOriginalPath(this.myRootNode, originalPath);
    }

    @Nullable
    private static PathMappingNode findNodeWithOriginalPath(@NotNull DefaultMutableTreeNode node, @NotNull String originalPath) {
        PathMappingNode pathMappingNode;
        if (node == null) {
            PathMappingTreeTableView.$$$reportNull$$$0(12);
        }
        if (originalPath == null) {
            PathMappingTreeTableView.$$$reportNull$$$0(13);
        }
        if (node instanceof PathMappingNode && originalPath.equals((pathMappingNode = (PathMappingNode)node).getPathMapping().getOriginalPath())) {
            return pathMappingNode;
        }
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            PathMappingNode mayBeFound = PathMappingTreeTableView.findNodeWithOriginalPath((DefaultMutableTreeNode)node.getChildAt(i), originalPath);
            if (mayBeFound == null) continue;
            return mayBeFound;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/editor/PathMappingTreeTableView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappingNode";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/editor/PathMappingTreeTableView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnteredPathMappings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalPathMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isParentSelectedPathAncestor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedPathFromParent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updatePathMapping";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findNodeWithOriginalPath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updatePathMapping$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class PathToStringConvertor
    implements Convertor<TreePath, String> {
        PathToStringConvertor() {
        }

        public String convert(TreePath treePath) {
            Object component = treePath.getLastPathComponent();
            if (component instanceof PathMappingNode) {
                return ((PathMappingNode)component).getFilePath();
            }
            return (String)TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING.convert((Object)treePath);
        }
    }
}

