/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.LocalPathColumnInfo;
import com.android.tools.idea.apk.editor.OriginalPathColumnInfo;
import com.android.tools.idea.apk.editor.PathMappingNode;
import com.android.tools.idea.apk.editor.PathMappingRootNode;
import com.android.tools.idea.apk.editor.PathMappingTreeTableView;
import com.android.tools.idea.apk.symbols.ui.PathMapping;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ColumnInfo;
import java.io.File;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

class PathMappingTreeTableViewModel
extends ListTreeTableModelOnColumns {
    PathMappingTreeTableView view;

    PathMappingTreeTableViewModel(@NotNull NativeLibrary library, @NotNull Project project) {
        if (library == null) {
            PathMappingTreeTableViewModel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PathMappingTreeTableViewModel.$$$reportNull$$$0(1);
        }
        super((TreeNode)new PathMappingRootNode(library), new ColumnInfo[]{new OriginalPathColumnInfo(), new LocalPathColumnInfo(project)});
    }

    public PathMappingRootNode getRoot() {
        return (PathMappingRootNode)super.getRoot();
    }

    public void setValueAt(Object aValue, Object node, int column) {
        super.setValueAt(aValue, node, column);
        if (this.view != null) {
            if (node instanceof PathMappingNode) {
                PathMappingTreeTableViewModel.updateMappedPathInChildren((PathMappingNode)node);
            }
            this.view.tableChanged();
        }
    }

    private static void updateMappedPathInChildren(@NotNull PathMappingNode parent) {
        if (parent == null) {
            PathMappingTreeTableViewModel.$$$reportNull$$$0(2);
        }
        if (parent.isLeaf()) {
            return;
        }
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            File potentialSelectedPath;
            PathMappingNode child = (PathMappingNode)parent.getChildAt(i);
            String parentSelectedPath = parent.getPathMapping().getSelectedPath();
            if (parentSelectedPath.isEmpty() || !(potentialSelectedPath = new File(parentSelectedPath, FileUtil.join((String[])ArrayUtil.toStringArray(child.getRelativePathSegments())))).isDirectory()) continue;
            PathMapping childPathMapping = child.getPathMapping();
            String newPathValue = potentialSelectedPath.getPath();
            if (!newPathValue.equals(childPathMapping.getSelectedPath())) {
                childPathMapping.setSelectedPath(potentialSelectedPath.getPath());
            }
            PathMappingTreeTableViewModel.updateMappedPathInChildren(child);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/apk/editor/PathMappingTreeTableViewModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateMappedPathInChildren";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

