/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor.notification;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.OpenLibraryInEditorAction;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.notification.DropDownAction;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingDebugSymbolsNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"apk.missing.debug.symbols");
    @NotNull
    private final Project myProject;

    public MissingDebugSymbolsNotificationProvider(@NotNull Project project) {
        if (project == null) {
            MissingDebugSymbolsNotificationProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            MissingDebugSymbolsNotificationProvider.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        ApkFacet facet;
        if (file == null) {
            MissingDebugSymbolsNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            MissingDebugSymbolsNotificationProvider.$$$reportNull$$$0(3);
        }
        if ("apk".equals(file.getExtension()) && (facet = this.findLibrariesWithoutSymbols()) != null) {
            MyEditorNotificationPanel panel = new MyEditorNotificationPanel();
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
            List libraries = ((ApkFacetConfiguration)facet.getConfiguration()).getLibrariesWithoutDebugSymbols();
            if (libraries.size() == 1) {
                NativeLibrary library = (NativeLibrary)libraries.get(0);
                panel.setText(library.name + " is missing debug symbols");
                OpenLibraryInEditorAction action = new OpenLibraryInEditorAction(library, fileEditorManager);
                panel.addToLinksPanel((Component)((Object)new OpenLibraryInEditorHyperlinkLabel(action, panel.getBackground())));
            } else {
                panel.setText("Libraries (*.so) in the APK are missing debug symbols");
                DropDownAction dropDown = new DropDownAction("Select library to add debug symbols ");
                for (NativeLibrary library : libraries) {
                    dropDown.addAction(new OpenLibraryInEditorAction(library.name, library, fileEditorManager));
                }
                panel.addToLinksPanel((Component)((Object)dropDown));
            }
            return panel;
        }
        return null;
    }

    @Nullable
    private ApkFacet findLibrariesWithoutSymbols() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ApkFacetConfiguration configuration;
            List libraries;
            ApkFacet facet = ApkFacet.getInstance((Module)module);
            if (facet == null || (libraries = (configuration = (ApkFacetConfiguration)facet.getConfiguration()).getLibrariesWithoutDebugSymbols()).isEmpty()) continue;
            return facet;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/editor/notification/MissingDebugSymbolsNotificationProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/editor/notification/MissingDebugSymbolsNotificationProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class OpenLibraryInEditorHyperlinkLabel
    extends HyperlinkLabel {
        @NotNull
        private final NativeLibrary myLibrary;

        OpenLibraryInEditorHyperlinkLabel(@NotNull OpenLibraryInEditorAction action, @NotNull Color background) {
            if (action == null) {
                OpenLibraryInEditorHyperlinkLabel.$$$reportNull$$$0(0);
            }
            if (background == null) {
                OpenLibraryInEditorHyperlinkLabel.$$$reportNull$$$0(1);
            }
            super("Add debug symbols", background);
            this.addHyperlinkListener(action);
            this.myLibrary = action.getLibrary();
        }

        @VisibleForTesting
        protected void fireHyperlinkEvent() {
            super.fireHyperlinkEvent();
        }

        @NotNull
        NativeLibrary getLibrary() {
            NativeLibrary nativeLibrary = this.myLibrary;
            if (nativeLibrary == null) {
                OpenLibraryInEditorHyperlinkLabel.$$$reportNull$$$0(2);
            }
            return nativeLibrary;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "background";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/apk/editor/notification/MissingDebugSymbolsNotificationProvider$OpenLibraryInEditorHyperlinkLabel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/apk/editor/notification/MissingDebugSymbolsNotificationProvider$OpenLibraryInEditorHyperlinkLabel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @VisibleForTesting
    static class MyEditorNotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final List<Component> myLinkComponents = new ArrayList<Component>();

        MyEditorNotificationPanel() {
        }

        void addToLinksPanel(@NotNull Component component) {
            if (component == null) {
                MyEditorNotificationPanel.$$$reportNull$$$0(0);
            }
            this.myLinksPanel.add(component);
            this.myLinkComponents.add(component);
        }

        @VisibleForTesting
        @NotNull
        List<Component> getLinkComponents() {
            List<Component> list = this.myLinkComponents;
            if (list == null) {
                MyEditorNotificationPanel.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/apk/editor/notification/MissingDebugSymbolsNotificationProvider$MyEditorNotificationPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/apk/editor/notification/MissingDebugSymbolsNotificationProvider$MyEditorNotificationPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLinkComponents";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addToLinksPanel";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

