/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.issues;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.ApkSyncMessages;
import com.android.tools.idea.apk.OpenLibraryInEditorAction;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.debugging.SetupIssue;
import com.android.tools.idea.apk.issues.IssueCategory;
import com.android.tools.idea.apk.issues.SetupIssueReportStrategy;
import com.android.tools.idea.project.messages.MessageType;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DebugSymbolsMissingReporter
extends SetupIssueReportStrategy {
    DebugSymbolsMissingReporter(@NotNull ApkSyncMessages syncMessages) {
        if (syncMessages == null) {
            DebugSymbolsMissingReporter.$$$reportNull$$$0(0);
        }
        super(syncMessages);
    }

    @Override
    @NotNull
    IssueCategory getSupportedCategory() {
        IssueCategory issueCategory = IssueCategory.DEBUG_SYMBOLS_MISSING;
        if (issueCategory == null) {
            DebugSymbolsMissingReporter.$$$reportNull$$$0(1);
        }
        return issueCategory;
    }

    @Override
    void report(@NotNull SetupIssue issue, @NotNull ApkFacet facet) {
        if (issue == null) {
            DebugSymbolsMissingReporter.$$$reportNull$$$0(2);
        }
        if (facet == null) {
            DebugSymbolsMissingReporter.$$$reportNull$$$0(3);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("To debug the APK, native libraries (*.so files) must have debug symbols.<br/>");
        List libraries = ((ApkFacetConfiguration)facet.getConfiguration()).getLibrariesWithoutDebugSymbols();
        int libraryCount = libraries.size();
        NotificationCategory category = MessageType.valueOf((String)issue.severity).convertToCategory();
        if (libraryCount == 1) {
            NativeLibrary library = (NativeLibrary)libraries.get(0);
            buffer.append("<a href='").append(library.name).append("'>Add debug symbols to ").append(library.name).append("</a>");
        } else {
            buffer.append("The following libraries are missing debug symbols (click link to add debug symbols):<br/>");
            for (int i = 0; i < libraryCount; ++i) {
                NativeLibrary library = (NativeLibrary)libraries.get(i);
                buffer.append("&nbsp;*&nbsp;<a href='").append(library.name).append("'>").append(library.name).append("</a>");
                if (i >= libraryCount - 1) continue;
                buffer.append("<br/>");
            }
        }
        ApkSyncMessages syncMessages = this.getSyncMessages();
        NotificationData notification = syncMessages.createNotification("APK Import", buffer.toString(), category, null);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)facet.getModule().getProject());
        for (NativeLibrary library : libraries) {
            notification.setListener(library.name, (NotificationListener)new OpenLibraryInEditorAction(library, fileEditorManager));
        }
        syncMessages.report(notification);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/issues/DebugSymbolsMissingReporter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/issues/DebugSymbolsMissingReporter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedCategory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

