/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.issues;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkSyncMessages;
import com.android.tools.idea.apk.debugging.SetupIssue;
import com.android.tools.idea.apk.issues.IssueCategory;
import com.android.tools.idea.apk.issues.SetupIssueReportStrategy;
import com.android.tools.idea.apk.sdk.AndroidSdkSetup;
import com.android.tools.idea.apk.sdk.InstallPlatformQuickFix;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.tools.idea.sdk.IdeSdks;
import java.io.File;
import org.jetbrains.annotations.NotNull;

class SdkNotFoundReporter
extends SetupIssueReportStrategy {
    @NotNull
    private final IdeSdks myIdeSdks;

    SdkNotFoundReporter(@NotNull ApkSyncMessages syncMessages, @NotNull IdeSdks ideSdks) {
        if (syncMessages == null) {
            SdkNotFoundReporter.$$$reportNull$$$0(0);
        }
        if (ideSdks == null) {
            SdkNotFoundReporter.$$$reportNull$$$0(1);
        }
        super(syncMessages);
        this.myIdeSdks = ideSdks;
    }

    @Override
    @NotNull
    IssueCategory getSupportedCategory() {
        IssueCategory issueCategory = IssueCategory.SDK_NOT_FOUND;
        if (issueCategory == null) {
            SdkNotFoundReporter.$$$reportNull$$$0(2);
        }
        return issueCategory;
    }

    @Override
    void report(@NotNull SetupIssue issue, @NotNull ApkFacet facet) {
        if (issue == null) {
            SdkNotFoundReporter.$$$reportNull$$$0(3);
        }
        if (facet == null) {
            SdkNotFoundReporter.$$$reportNull$$$0(4);
        }
        String sdkVersion = issue.extraInfo;
        String text = "Failed to find Android target '" + sdkVersion + "'";
        SyncMessage message = new SyncMessage("APK Import", MessageType.valueOf((String)issue.severity), new String[]{text});
        message.add((NotificationHyperlink)new InstallPlatformQuickFix(new AndroidSdkSetup(), facet, this.getSdkPath(), sdkVersion));
        this.getSyncMessages().report(message);
    }

    @NotNull
    private File getSdkPath() {
        File sdkPath = this.myIdeSdks.getAndroidSdkPath();
        assert (sdkPath != null);
        File file = sdkPath;
        if (file == null) {
            SdkNotFoundReporter.$$$reportNull$$$0(5);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideSdks";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/issues/SdkNotFoundReporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/issues/SdkNotFoundReporter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedCategory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

