/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.issues;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.ApkSyncMessages;
import com.android.tools.idea.apk.debugging.ApkDebugging;
import com.android.tools.idea.apk.debugging.SetupIssue;
import com.android.tools.idea.apk.issues.DebugSymbolsMissingReporter;
import com.android.tools.idea.apk.issues.IssueCategory;
import com.android.tools.idea.apk.issues.SdkNotFoundReporter;
import com.android.tools.idea.apk.issues.SetupIssueReportStrategy;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SetupIssueReporter {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ApkSyncMessages mySyncMessages;
    @NotNull
    private final Map<IssueCategory, SetupIssueReportStrategy> myIssueReportStrategiesByCategory;

    @NotNull
    public static SetupIssueReporter getInstance(@NotNull Project project) {
        if (project == null) {
            SetupIssueReporter.$$$reportNull$$$0(0);
        }
        SetupIssueReporter setupIssueReporter = (SetupIssueReporter)ServiceManager.getService((Project)project, SetupIssueReporter.class);
        if (setupIssueReporter == null) {
            SetupIssueReporter.$$$reportNull$$$0(1);
        }
        return setupIssueReporter;
    }

    public SetupIssueReporter(@NotNull Project project, @NotNull ApkSyncMessages syncMessages, @NotNull IdeSdks ideSdks) {
        if (project == null) {
            SetupIssueReporter.$$$reportNull$$$0(2);
        }
        if (syncMessages == null) {
            SetupIssueReporter.$$$reportNull$$$0(3);
        }
        if (ideSdks == null) {
            SetupIssueReporter.$$$reportNull$$$0(4);
        }
        this(project, syncMessages, new SdkNotFoundReporter(syncMessages, ideSdks), new DebugSymbolsMissingReporter(syncMessages));
    }

    @VisibleForTesting
    SetupIssueReporter(@NotNull Project project, @NotNull ApkSyncMessages syncMessages, SetupIssueReportStrategy ... strategies) {
        if (project == null) {
            SetupIssueReporter.$$$reportNull$$$0(5);
        }
        if (syncMessages == null) {
            SetupIssueReporter.$$$reportNull$$$0(6);
        }
        if (strategies == null) {
            SetupIssueReporter.$$$reportNull$$$0(7);
        }
        this.myProject = project;
        this.mySyncMessages = syncMessages;
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (SetupIssueReportStrategy strategy : strategies) {
            mapBuilder.put((Object)strategy.getSupportedCategory(), (Object)strategy);
        }
        this.myIssueReportStrategiesByCategory = mapBuilder.build();
    }

    public void reportSetupIssues(@NotNull ApkFacet facet) {
        if (facet == null) {
            SetupIssueReporter.$$$reportNull$$$0(8);
        }
        Runnable task = () -> {
            if (facet == null) {
                SetupIssueReporter.$$$reportNull$$$0(12);
            }
            this.mySyncMessages.removeMessages(new String[]{"APK Import"});
            ExternalSystemUtil.ensureToolWindowContentInitialized((Project)this.myProject, (ProjectSystemId)ApkDebugging.SYSTEM_ID);
            for (SetupIssue issue : ((ApkFacetConfiguration)facet.getConfiguration()).SETUP_ISSUES) {
                this.report(issue, facet);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            task.run();
        } else {
            application.invokeLater(task);
        }
    }

    private void report(@NotNull SetupIssue issue, @NotNull ApkFacet facet) {
        if (issue == null) {
            SetupIssueReporter.$$$reportNull$$$0(9);
        }
        if (facet == null) {
            SetupIssueReporter.$$$reportNull$$$0(10);
        }
        IssueCategory category = IssueCategory.valueOf(issue.category);
        SetupIssueReportStrategy reportStrategy = this.myIssueReportStrategiesByCategory.get((Object)category);
        assert (reportStrategy != null);
        reportStrategy.report(issue, facet);
    }

    @VisibleForTesting
    @NotNull
    Map<IssueCategory, SetupIssueReportStrategy> getIssueReportStrategiesByCategory() {
        Map<IssueCategory, SetupIssueReportStrategy> map = this.myIssueReportStrategiesByCategory;
        if (map == null) {
            SetupIssueReporter.$$$reportNull$$$0(11);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/issues/SetupIssueReporter";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideSdks";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategies";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/issues/SetupIssueReporter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssueReportStrategiesByCategory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 11: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reportSetupIssues";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$reportSetupIssues$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

