/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.sdk;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.SetupIssue;
import com.android.tools.idea.apk.issues.IssueCategory;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.io.File;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkSetup {
    @NotNull
    private final AndroidSdks myAndroidSdks;

    public AndroidSdkSetup() {
        this(AndroidSdks.getInstance());
    }

    @VisibleForTesting
    AndroidSdkSetup(AndroidSdks androidSdks) {
        this.myAndroidSdks = androidSdks;
    }

    @Nullable
    public Sdk setUpSdk(@NotNull String sdkVersion, @NotNull File sdkPath, @NotNull ApkFacet facet, @NotNull ModifiableRootModel rootModel) {
        IAndroidTarget target;
        if (sdkVersion == null) {
            AndroidSdkSetup.$$$reportNull$$$0(0);
        }
        if (sdkPath == null) {
            AndroidSdkSetup.$$$reportNull$$$0(1);
        }
        if (facet == null) {
            AndroidSdkSetup.$$$reportNull$$$0(2);
        }
        if (rootModel == null) {
            AndroidSdkSetup.$$$reportNull$$$0(3);
        }
        if ((target = AndroidSdkSetup.findTarget(sdkVersion, sdkPath)) != null) {
            Sdk sdk = this.myAndroidSdks.findSuitableAndroidSdk(target.hashString());
            if (sdk != null) {
                rootModel.setSdk(sdk);
                return sdk;
            }
        } else {
            SetupIssue setupIssue = new SetupIssue();
            setupIssue.severity = MessageType.ERROR.name();
            setupIssue.category = IssueCategory.SDK_NOT_FOUND.name();
            setupIssue.extraInfo = String.valueOf(sdkVersion);
            ((ApkFacetConfiguration)facet.getConfiguration()).SETUP_ISSUES.add(setupIssue);
        }
        return null;
    }

    @Nullable
    private static IAndroidTarget findTarget(@NotNull String sdkVersion, @NotNull File sdkPath) {
        AndroidSdkData sdkData;
        if (sdkVersion == null) {
            AndroidSdkSetup.$$$reportNull$$$0(4);
        }
        if (sdkPath == null) {
            AndroidSdkSetup.$$$reportNull$$$0(5);
        }
        return (sdkData = AndroidSdkData.getSdkData((File)sdkPath)) != null ? sdkData.findTargetByApiLevel(sdkVersion) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkVersion";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/apk/sdk/AndroidSdkSetup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpSdk";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

