/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.sdk;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.issues.IssueCategory;
import com.android.tools.idea.apk.issues.SetupIssueReporter;
import com.android.tools.idea.apk.sdk.AndroidSdkSetup;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallPlatformQuickFix
extends NotificationHyperlink {
    @NotNull
    private final AndroidSdkSetup mySdkSetup;
    @NotNull
    private final ApkFacet myFacet;
    @NotNull
    private final File mySdkPath;
    @NotNull
    private final String mySdkVersion;
    @NotNull
    private final SdkManagerQuickFix myQuickFix;

    public InstallPlatformQuickFix(@NotNull AndroidSdkSetup sdkSetup, @NotNull ApkFacet facet, @NotNull File sdkPath, @NotNull String sdkVersion) {
        if (sdkSetup == null) {
            InstallPlatformQuickFix.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            InstallPlatformQuickFix.$$$reportNull$$$0(1);
        }
        if (sdkPath == null) {
            InstallPlatformQuickFix.$$$reportNull$$$0(2);
        }
        if (sdkVersion == null) {
            InstallPlatformQuickFix.$$$reportNull$$$0(3);
        }
        this(sdkSetup, facet, sdkPath, sdkVersion, SdkQuickfixUtils::createDialogForPaths);
    }

    @VisibleForTesting
    InstallPlatformQuickFix(@NotNull AndroidSdkSetup sdkSetup, @NotNull ApkFacet facet, @NotNull File sdkPath, @NotNull String sdkVersion, @NotNull SdkManagerQuickFix quickFix) {
        if (sdkSetup == null) {
            InstallPlatformQuickFix.$$$reportNull$$$0(4);
        }
        if (facet == null) {
            InstallPlatformQuickFix.$$$reportNull$$$0(5);
        }
        if (sdkPath == null) {
            InstallPlatformQuickFix.$$$reportNull$$$0(6);
        }
        if (sdkVersion == null) {
            InstallPlatformQuickFix.$$$reportNull$$$0(7);
        }
        if (quickFix == null) {
            InstallPlatformQuickFix.$$$reportNull$$$0(8);
        }
        super("install.android.platform", "Install missing platform and fix project");
        this.mySdkSetup = sdkSetup;
        this.myFacet = facet;
        this.mySdkPath = sdkPath;
        this.mySdkVersion = sdkVersion;
        this.myQuickFix = quickFix;
    }

    protected void execute(@NotNull Project project) {
        AndroidVersion version;
        List<String> requested;
        ModelWizardDialog dialog;
        if (project == null) {
            InstallPlatformQuickFix.$$$reportNull$$$0(9);
        }
        if ((dialog = this.myQuickFix.createSdkDialog(project, requested = Collections.singletonList(DetailsTypes.getPlatformPath((AndroidVersion)(version = new AndroidVersion(Integer.parseInt(this.mySdkVersion), null)))))) == null || dialog.showAndGet()) {
            ModifiableRootModel moduleModel = ModuleRootManager.getInstance((Module)this.myFacet.getModule()).getModifiableModel();
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    InstallPlatformQuickFix.$$$reportNull$$$0(12);
                }
                IdeSdks.getInstance().updateFromAndroidSdkPath(project);
            });
            Sdk sdk = this.mySdkSetup.setUpSdk(this.mySdkVersion, this.mySdkPath, this.myFacet, moduleModel);
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    InstallPlatformQuickFix.$$$reportNull$$$0(11);
                }
                if (sdk != null) {
                    moduleModel.commit();
                    ((ApkFacetConfiguration)this.myFacet.getConfiguration()).removeIssues(IssueCategory.SDK_NOT_FOUND.name());
                    SetupIssueReporter.getInstance(project).reportSetupIssues(this.myFacet);
                } else {
                    moduleModel.dispose();
                }
            });
        }
    }

    @VisibleForTesting
    @NotNull
    public File getSdkPath() {
        File file = this.mySdkPath;
        if (file == null) {
            InstallPlatformQuickFix.$$$reportNull$$$0(10);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkSetup";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkVersion";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFix";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/sdk/InstallPlatformQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/sdk/InstallPlatformQuickFix";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$1";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static interface SdkManagerQuickFix {
        @Nullable
        public ModelWizardDialog createSdkDialog(@Nullable Project var1, @NotNull Collection<String> var2);
    }
}

