/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.setup;

import com.android.tools.idea.apk.debugging.LibraryFolder;
import com.android.tools.idea.apk.dex.DexFileDisassembler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectApkFileSetup {
    @NotNull
    private final DexFileDisassembler myDexFileDisassembler;

    public ProjectApkFileSetup() {
        this(new DexFileDisassembler());
    }

    @VisibleForTesting
    ProjectApkFileSetup(@NotNull DexFileDisassembler dexFileDisassembler) {
        if (dexFileDisassembler == null) {
            ProjectApkFileSetup.$$$reportNull$$$0(0);
        }
        this.myDexFileDisassembler = dexFileDisassembler;
    }

    @NotNull
    public Path setUpApk(@NotNull Path apkFilePath, @NotNull Path destination, @Nullable ProgressIndicator progressIndicator) throws IOException, ExecutionException, InterruptedException {
        if (apkFilePath == null) {
            ProjectApkFileSetup.$$$reportNull$$$0(1);
        }
        if (destination == null) {
            ProjectApkFileSetup.$$$reportNull$$$0(2);
        }
        Path newApkFile = Files.copy(apkFilePath, destination.resolve(apkFilePath.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        Path smaliRootFolderPath = Files.createDirectory(destination.resolve("smali"), new FileAttribute[0]);
        if (progressIndicator != null) {
            progressIndicator.setText("Extracting contents");
        }
        try (ZipFile zipFile = new ZipFile(newApkFile.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            Splitter pathSplitter = Splitter.on((char)'/');
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                List segments = pathSplitter.omitEmptyStrings().splitToList((CharSequence)name);
                int segmentCount = segments.size();
                if (segmentCount == 0) {
                    this.getLog().warn("Found an entry with empty name in file '" + apkFilePath + "'");
                    continue;
                }
                String first = (String)segments.get(0);
                if (segmentCount > 1 && LibraryFolder.getName().equals(first) && name.endsWith(".so")) {
                    ProjectApkFileSetup.extract(entry, destination, zipFile);
                    continue;
                }
                if (segmentCount != 1 || !"classes.dex".equals(first)) continue;
                ProjectApkFileSetup.extract(entry, smaliRootFolderPath, zipFile);
            }
        }
        Path dexFilePath = smaliRootFolderPath.resolve("classes.dex");
        File expectedDexFilePath = dexFilePath.toFile();
        if (!expectedDexFilePath.isFile()) {
            throw new FileNotFoundException("Unable to find file '" + expectedDexFilePath.getPath() + "'");
        }
        Path outputFolderPath = Files.createDirectory(smaliRootFolderPath.resolve("out"), new FileAttribute[0]);
        if (progressIndicator != null) {
            progressIndicator.setText("Disassembling classes.dex");
        }
        this.myDexFileDisassembler.disassemble(expectedDexFilePath, outputFolderPath.toFile());
        Path path = newApkFile;
        if (path == null) {
            ProjectApkFileSetup.$$$reportNull$$$0(3);
        }
        return path;
    }

    @NotNull
    private Logger getLog() {
        Logger logger = Logger.getInstance(this.getClass());
        if (logger == null) {
            ProjectApkFileSetup.$$$reportNull$$$0(4);
        }
        return logger;
    }

    private static void extract(@NotNull ZipEntry entry, @NotNull Path destination, @NotNull ZipFile zipFile) throws IOException {
        if (entry == null) {
            ProjectApkFileSetup.$$$reportNull$$$0(5);
        }
        if (destination == null) {
            ProjectApkFileSetup.$$$reportNull$$$0(6);
        }
        if (zipFile == null) {
            ProjectApkFileSetup.$$$reportNull$$$0(7);
        }
        ZipUtil.extractEntry((ZipEntry)entry, (InputStream)zipFile.getInputStream(entry), (File)destination.toFile(), (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFileDisassembler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFilePath";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/setup/ProjectApkFileSetup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/setup/ProjectApkFileSetup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setUpApk";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setUpApk";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

