/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.setup.module;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.setup.module.ApkModuleSetupStep;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.annotations.NotNull;

public class AndroidManifestSetupStep
extends ApkModuleSetupStep {
    @Override
    public void setUpModule(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ApkSetupContext context) throws Exception {
        VirtualFile apkRoot;
        if (modelsProvider == null) {
            AndroidManifestSetupStep.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AndroidManifestSetupStep.$$$reportNull$$$0(1);
        }
        if ((apkRoot = ApkFileSystem.getInstance().getRootByLocal(context.getApkFile())) == null) {
            throw new IOException(String.format("Failed to read APK file '%1$s'", AndroidManifestSetupStep.getApkFilePath(context)));
        }
        VirtualFile manifestFile = apkRoot.findChild("AndroidManifest.xml");
        if (manifestFile == null) {
            throw new FileNotFoundException(String.format("Failed to find manifest from APK file '%1$s'", AndroidManifestSetupStep.getApkFilePath(context)));
        }
        File rootFolderPath = context.getProjectRootFolderPath();
        File manifestPath = new File(rootFolderPath, "AndroidManifest.xml");
        FileUtil.writeToFile((File)manifestPath, (byte[])manifestFile.contentsToByteArray());
        LocalFileSystem.getInstance().refreshIoFiles((Iterable)ImmutableList.of((Object)manifestPath));
        this.setApplicationPackage(context);
    }

    @VisibleForTesting
    void setApplicationPackage(@NotNull ApkSetupContext context) {
        if (context == null) {
            AndroidManifestSetupStep.$$$reportNull$$$0(2);
        }
        ApkFacet apkFacet = context.getApkFacet();
        assert (apkFacet != null);
        Manifest manifest = this.getManifest(context);
        ((ApkFacetConfiguration)apkFacet.getConfiguration()).APP_PACKAGE = (String)manifest.getPackage().getValue();
    }

    @NotNull
    private static String getApkFilePath(@NotNull ApkSetupContext context) {
        if (context == null) {
            AndroidManifestSetupStep.$$$reportNull$$$0(3);
        }
        String string = VfsUtilCore.virtualToIoFile((VirtualFile)context.getApkFile()).getPath();
        if (string == null) {
            AndroidManifestSetupStep.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/setup/module/AndroidManifestSetupStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/setup/module/AndroidManifestSetupStep";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getApkFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setUpModule";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setApplicationPackage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getApkFilePath";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

