/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.setup.module;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.sdk.AndroidSdkSetup;
import com.android.tools.idea.apk.setup.module.ApkModuleSetupStep;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkSetupStep
extends ApkModuleSetupStep {
    @NotNull
    private final IdeSdks myIdeSdks;
    @NotNull
    private final AndroidSdkSetup mySdkSetup;

    public AndroidSdkSetupStep() {
        this(IdeSdks.getInstance(), new AndroidSdkSetup());
    }

    @VisibleForTesting
    AndroidSdkSetupStep(@NotNull IdeSdks ideSdks, @NotNull AndroidSdkSetup sdkSetup) {
        if (ideSdks == null) {
            AndroidSdkSetupStep.$$$reportNull$$$0(0);
        }
        if (sdkSetup == null) {
            AndroidSdkSetupStep.$$$reportNull$$$0(1);
        }
        this.myIdeSdks = ideSdks;
        this.mySdkSetup = sdkSetup;
    }

    @Override
    public void setUpModule(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ApkSetupContext context) {
        File sdkPath;
        if (modelsProvider == null) {
            AndroidSdkSetupStep.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AndroidSdkSetupStep.$$$reportNull$$$0(3);
        }
        if ((sdkPath = this.myIdeSdks.getAndroidSdkPath()) != null) {
            Manifest manifest = this.getManifest(context);
            this.setModuleSdk(context, modelsProvider, sdkPath, manifest);
        }
    }

    @VisibleForTesting
    void setModuleSdk(@NotNull ApkSetupContext context, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull File sdkPath, @NotNull Manifest manifest) {
        UsesSdk usesSdk;
        String sdkVersion;
        if (context == null) {
            AndroidSdkSetupStep.$$$reportNull$$$0(4);
        }
        if (modelsProvider == null) {
            AndroidSdkSetupStep.$$$reportNull$$$0(5);
        }
        if (sdkPath == null) {
            AndroidSdkSetupStep.$$$reportNull$$$0(6);
        }
        if (manifest == null) {
            AndroidSdkSetupStep.$$$reportNull$$$0(7);
        }
        ModifiableRootModel rootModel = modelsProvider.getModifiableRootModel(context.getModule());
        List usesSdks = manifest.getUsesSdks();
        if (!usesSdks.isEmpty() && StringUtil.isNotEmpty((String)(sdkVersion = AndroidSdkSetupStep.getSdkVersion(usesSdk = (UsesSdk)usesSdks.get(0))))) {
            ApkFacet facet = context.getApkFacet();
            assert (facet != null);
            Sdk sdk = this.mySdkSetup.setUpSdk(sdkVersion, sdkPath, facet, rootModel);
            context.setAndroidSdk(sdk);
        }
    }

    @Nullable
    private static String getSdkVersion(@NotNull UsesSdk usesSdk) {
        String sdkVersion;
        if (usesSdk == null) {
            AndroidSdkSetupStep.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmpty((String)(sdkVersion = AndroidSdkSetupStep.getTargetSdkVersion(usesSdk)))) {
            sdkVersion = AndroidSdkSetupStep.getMinSdkVersion(usesSdk);
        }
        return sdkVersion;
    }

    @Nullable
    private static String getTargetSdkVersion(@NotNull UsesSdk usesSdk) {
        AndroidAttributeValue targetSdkVersion;
        if (usesSdk == null) {
            AndroidSdkSetupStep.$$$reportNull$$$0(9);
        }
        return (targetSdkVersion = usesSdk.getTargetSdkVersion()).exists() ? (String)targetSdkVersion.getValue() : null;
    }

    @Nullable
    private static String getMinSdkVersion(@NotNull UsesSdk usesSdk) {
        AndroidAttributeValue minSdkVersion;
        if (usesSdk == null) {
            AndroidSdkSetupStep.$$$reportNull$$$0(10);
        }
        return (minSdkVersion = usesSdk.getMinSdkVersion()).exists() ? (String)minSdkVersion.getValue() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkSetup";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usesSdk";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/apk/setup/module/AndroidSdkSetupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpModule";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setModuleSdk";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getSdkVersion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetSdkVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getMinSdkVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

