/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.setup.module;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.debugging.LibraryFolder;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.setup.module.ApkModuleSetupStep;
import com.android.tools.idea.apk.setup.module.NativeLibraryCollector;
import com.android.tools.idea.apk.symbols.DebugSymbolNotifications;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NativeCodeSetupStep
extends ApkModuleSetupStep {
    @NotNull
    private final DebugSymbolNotifications myDebugSymbolNotifications;
    @NotNull
    private final NativeLibraryCollector myNativeLibraryCollector;

    public NativeCodeSetupStep() {
        this(DebugSymbolNotifications.getInstance(), new NativeLibraryCollector());
    }

    @VisibleForTesting
    NativeCodeSetupStep(@NotNull DebugSymbolNotifications debugSymbolNotifications, @NotNull NativeLibraryCollector nativeLibraryCollector) {
        if (debugSymbolNotifications == null) {
            NativeCodeSetupStep.$$$reportNull$$$0(0);
        }
        if (nativeLibraryCollector == null) {
            NativeCodeSetupStep.$$$reportNull$$$0(1);
        }
        this.myDebugSymbolNotifications = debugSymbolNotifications;
        this.myNativeLibraryCollector = nativeLibraryCollector;
    }

    @Override
    public void setUpModule(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ApkSetupContext context) throws Throwable {
        File libFolderPath;
        if (modelsProvider == null) {
            NativeCodeSetupStep.$$$reportNull$$$0(2);
        }
        if (context == null) {
            NativeCodeSetupStep.$$$reportNull$$$0(3);
        }
        if ((libFolderPath = new File(context.getProjectRootFolderPath(), LibraryFolder.getName())).isDirectory()) {
            VirtualFile libFolder = VfsUtil.findFileByIoFile((File)libFolderPath, (boolean)true);
            assert (libFolder != null);
            ContentEntry contentEntry = context.getContentEntry();
            assert (contentEntry != null);
            contentEntry.addExcludeFolder(libFolder);
            ApkFacet facet = context.getApkFacet();
            assert (facet != null);
            ApkFacetConfiguration configuration = (ApkFacetConfiguration)facet.getConfiguration();
            configuration.NATIVE_LIBRARIES.clear();
            List<NativeLibrary> libraries = this.myNativeLibraryCollector.collectNativeLibraries(libFolder);
            configuration.NATIVE_LIBRARIES.addAll(libraries);
            this.myDebugSymbolNotifications.notifyIfDebugSymbolsAreMissing(facet, libraries);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSymbolNotifications";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeLibraryCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/apk/setup/module/NativeCodeSetupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

