/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.setup.project;

import com.android.tools.idea.apk.debugging.ApkDebugging;
import com.android.tools.idea.sdk.Jdks;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSdkSetup {
    private final Disposable myParentDisposable;

    public ProjectSdkSetup() {
        this.myParentDisposable = null;
    }

    public ProjectSdkSetup(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ProjectSdkSetup.$$$reportNull$$$0(0);
        }
        this.myParentDisposable = parentDisposable;
    }

    public void setUpProject(@NotNull Project project) {
        if (project == null) {
            ProjectSdkSetup.$$$reportNull$$$0(1);
        }
        ApkDebugging.markAsApkDebuggingProject((Project)project);
        this.tryToSetProjectJdk(project, LanguageLevel.JDK_1_8, LanguageLevel.JDK_1_7, LanguageLevel.JDK_1_6);
    }

    private void tryToSetProjectJdk(@NotNull Project project, LanguageLevel ... languageLevels) {
        if (project == null) {
            ProjectSdkSetup.$$$reportNull$$$0(2);
        }
        if (languageLevels == null) {
            ProjectSdkSetup.$$$reportNull$$$0(3);
        }
        for (LanguageLevel languageLevel : languageLevels) {
            Sdk jdk = ProjectSdkSetup.tryToSetProjectJdk(project, languageLevel);
            if (jdk == null) continue;
            this.registerJdkForDisposalIfNeeded(jdk);
            return;
        }
    }

    @Nullable
    private static Sdk tryToSetProjectJdk(@NotNull Project project, @NotNull LanguageLevel languageLevel) {
        Sdk jdk;
        if (project == null) {
            ProjectSdkSetup.$$$reportNull$$$0(4);
        }
        if (languageLevel == null) {
            ProjectSdkSetup.$$$reportNull$$$0(5);
        }
        if ((jdk = Jdks.getInstance().chooseOrCreateJavaSdk(languageLevel)) != null) {
            return (Sdk)ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    ProjectSdkSetup.$$$reportNull$$$0(8);
                }
                if (languageLevel == null) {
                    ProjectSdkSetup.$$$reportNull$$$0(9);
                }
                ProjectRootManager.getInstance((Project)project).setProjectSdk(jdk);
                LanguageLevelProjectExtension.getInstance((Project)project).setLanguageLevel(languageLevel);
                return jdk;
            });
        }
        return null;
    }

    private void registerJdkForDisposalIfNeeded(final @NotNull Sdk jdk) {
        if (jdk == null) {
            ProjectSdkSetup.$$$reportNull$$$0(6);
        }
        if (this.myParentDisposable != null) {
            Disposer.register((Disposable)this.myParentDisposable, () -> {
                if (jdk == null) {
                    ProjectSdkSetup.$$$reportNull$$$0(7);
                }
                new WriteAction(){

                    protected void run(@NotNull Result result) {
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ProjectJdkTable.getInstance().removeJdk(jdk);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/apk/setup/project/ProjectSdkSetup$1", "run"));
                    }
                }.execute();
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevels";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/apk/setup/project/ProjectSdkSetup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpProject";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "tryToSetProjectJdk";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "registerJdkForDisposalIfNeeded";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$registerJdkForDisposalIfNeeded$1";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$tryToSetProjectJdk$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

