/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.debugging.SetupIssue;
import com.android.tools.idea.apk.issues.IssueCategory;
import com.android.tools.idea.apk.issues.SetupIssueReporter;
import com.android.tools.idea.navigator.AndroidViewNodes;
import com.android.tools.idea.navigator.nodes.apk.ndk.LibFolderNode;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DebugSymbolNotifications {
    @NotNull
    private final AndroidViewNodes myAndroidViewNodes;

    @NotNull
    public static DebugSymbolNotifications getInstance() {
        DebugSymbolNotifications debugSymbolNotifications = (DebugSymbolNotifications)ServiceManager.getService(DebugSymbolNotifications.class);
        if (debugSymbolNotifications == null) {
            DebugSymbolNotifications.$$$reportNull$$$0(0);
        }
        return debugSymbolNotifications;
    }

    public DebugSymbolNotifications(@NotNull IdeSdks ideSdks) {
        if (ideSdks == null) {
            DebugSymbolNotifications.$$$reportNull$$$0(1);
        }
        this(new AndroidViewNodes());
    }

    DebugSymbolNotifications(@NotNull AndroidViewNodes androidViewNodes) {
        if (androidViewNodes == null) {
            DebugSymbolNotifications.$$$reportNull$$$0(2);
        }
        this.myAndroidViewNodes = androidViewNodes;
    }

    public void notifyLibraryUpdated(@NotNull ApkFacet facet, @NotNull NativeLibrary library) {
        if (facet == null) {
            DebugSymbolNotifications.$$$reportNull$$$0(3);
        }
        if (library == null) {
            DebugSymbolNotifications.$$$reportNull$$$0(4);
        }
        this.notifyLibrariesUpdated(facet, Collections.singletonList(library));
    }

    public void notifyLibrariesUpdated(@NotNull ApkFacet facet, @NotNull List<NativeLibrary> libraries) {
        if (facet == null) {
            DebugSymbolNotifications.$$$reportNull$$$0(5);
        }
        if (libraries == null) {
            DebugSymbolNotifications.$$$reportNull$$$0(6);
        }
        Project project = facet.getModule().getProject();
        ((ApkFacetConfiguration)facet.getConfiguration()).removeIssues(IssueCategory.DEBUG_SYMBOLS_MISSING.name());
        this.notifyIfDebugSymbolsAreMissing(facet, libraries);
        SetupIssueReporter.getInstance(project).reportSetupIssues(facet);
        this.myAndroidViewNodes.findAndRefreshNodeOfType(LibFolderNode.class, facet.getModule().getProject());
    }

    public void notifyIfDebugSymbolsAreMissing(@NotNull ApkFacet facet, @NotNull List<NativeLibrary> libraries) {
        if (facet == null) {
            DebugSymbolNotifications.$$$reportNull$$$0(7);
        }
        if (libraries == null) {
            DebugSymbolNotifications.$$$reportNull$$$0(8);
        }
        ArrayList<NativeLibrary> toReport = new ArrayList<NativeLibrary>();
        for (NativeLibrary library : libraries) {
            if (library.hasDebugSymbols) continue;
            toReport.add(library);
        }
        if (!toReport.isEmpty()) {
            SetupIssue setupIssue = new SetupIssue();
            setupIssue.severity = MessageType.WARNING.name();
            setupIssue.category = IssueCategory.DEBUG_SYMBOLS_MISSING.name();
            ((ApkFacetConfiguration)facet.getConfiguration()).SETUP_ISSUES.add(setupIssue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/symbols/DebugSymbolNotifications";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideSdks";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidViewNodes";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/symbols/DebugSymbolNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notifyLibraryUpdated";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyLibrariesUpdated";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "notifyIfDebugSymbolsAreMissing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

