/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.ApkDebuggingUsageTracker;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.AsyncResult;
import com.android.tools.idea.apk.debugging.DebuggableSharedObjectFile;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.symbols.NdkPathMatcher;
import com.android.tools.idea.apk.symbols.SharedObjectFile;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugSymbolsUpdater {
    @NotNull
    private final LocalPathLocator myLocalPathLocator;
    @NotNull
    private final IdeSdks myIdeSdks;
    @NotNull
    private final NdkPathMatcher myNdkPathMatcher;

    public DebugSymbolsUpdater() {
        this(new LocalPathLocator(), IdeSdks.getInstance(), new NdkPathMatcher());
    }

    @VisibleForTesting
    DebugSymbolsUpdater(@NotNull LocalPathLocator localPathLocator, @NotNull IdeSdks ideSdks, @NotNull NdkPathMatcher ndkPathMatcher) {
        if (localPathLocator == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(0);
        }
        if (ideSdks == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(1);
        }
        if (ndkPathMatcher == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(2);
        }
        this.myLocalPathLocator = localPathLocator;
        this.myIdeSdks = ideSdks;
        this.myNdkPathMatcher = ndkPathMatcher;
    }

    @NotNull
    public AsyncResult<List<DebuggableSharedObjectFile>> updateDebugSymbolsInLibrary(final @NotNull List<SharedObjectFile> sharedObjectFiles, final @NotNull NativeLibrary library, final @NotNull ApkFacet facet) {
        if (sharedObjectFiles == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(3);
        }
        if (library == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(4);
        }
        if (facet == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(5);
        }
        final AsyncResult<List<DebuggableSharedObjectFile>> callback = new AsyncResult<List<DebuggableSharedObjectFile>>();
        new Task.Backgroundable(facet.getModule().getProject(), "Updating Library", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(false);
                try {
                    List<DebuggableSharedObjectFile> addedFiles = DebugSymbolsUpdater.this.updateDebugSymbolsInLibrary(sharedObjectFiles, library, facet, indicator);
                    callback.setDone(addedFiles);
                }
                catch (RuntimeException error) {
                    callback.setRejected(error);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/apk/symbols/DebugSymbolsUpdater$1", "run"));
            }
        }.queue();
        AsyncResult<List<DebuggableSharedObjectFile>> asyncResult = callback;
        if (asyncResult == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(6);
        }
        return asyncResult;
    }

    @VisibleForTesting
    @NotNull
    List<DebuggableSharedObjectFile> updateDebugSymbolsInLibrary(@NotNull List<SharedObjectFile> sharedObjectFiles, @NotNull NativeLibrary library, @NotNull ApkFacet facet, @NotNull ProgressIndicator indicator) {
        if (sharedObjectFiles == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(7);
        }
        if (library == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(8);
        }
        if (facet == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(10);
        }
        HashSet obsoleteDebugSymbolPaths = new HashSet();
        HashSet<String> newRemoteSourceFolderPaths = new HashSet<String>();
        ArrayList<DebuggableSharedObjectFile> addedFiles = new ArrayList<DebuggableSharedObjectFile>();
        indicator.setText("Updating debug symbols");
        int fileCount = sharedObjectFiles.size();
        for (int i = 0; i < fileCount; ++i) {
            indicator.setFraction((double)i / (double)fileCount);
            SharedObjectFile file = sharedObjectFiles.get(i);
            Abi abi = file.getAbi();
            assert (abi != null);
            DebuggableSharedObjectFile existingSharedObjectFile = (DebuggableSharedObjectFile)library.debuggableSharedObjectFilesByAbi.get(abi);
            if (existingSharedObjectFile != null) {
                obsoleteDebugSymbolPaths.addAll(existingSharedObjectFile.debugSymbolPaths);
            }
            List<String> debugSymbolPaths = file.getDebugSymbolPaths();
            obsoleteDebugSymbolPaths.removeAll(debugSymbolPaths);
            DebuggableSharedObjectFile debuggableFile = library.addDebuggableSharedObjectFile(abi, file.getActualFile());
            debuggableFile.debugSymbolPaths.addAll(file.getDebugSymbolPaths());
            addedFiles.add(debuggableFile);
            for (String debugSymbolPath : debuggableFile.debugSymbolPaths) {
                if (this.myLocalPathLocator.isLocal(debugSymbolPath)) continue;
                newRemoteSourceFolderPaths.add(debugSymbolPath);
            }
            ApkDebuggingUsageTracker.logEvent(facet, AndroidStudioEvent.EventKind.APK_DEBUG_ADD_SYMBOLS);
        }
        if (!obsoleteDebugSymbolPaths.isEmpty()) {
            for (String obsoletePath : obsoleteDebugSymbolPaths) {
                library.removePathMapping(obsoletePath);
            }
        }
        if (!newRemoteSourceFolderPaths.isEmpty()) {
            this.updatePathMappingValues(library, newRemoteSourceFolderPaths, this.myIdeSdks.getAndroidNdkPath());
        }
        library.recalculateSourceFolderPaths();
        ArrayList<DebuggableSharedObjectFile> arrayList = addedFiles;
        if (arrayList == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public void updatePathMappingValues(@NotNull NativeLibrary library, @NotNull Collection<String> newRemoteSourceFolderPaths, @Nullable File ndkPath) {
        if (library == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(12);
        }
        if (newRemoteSourceFolderPaths == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(13);
        }
        for (String debugSymbolPath : newRemoteSourceFolderPaths) {
            File match;
            String mappedPath = "";
            if (ndkPath != null && (match = this.myNdkPathMatcher.findMatchingPathInNdk(debugSymbolPath, ndkPath)) != null) {
                mappedPath = match.getPath();
            }
            library.addPathMapping(debugSymbolPath, mappedPath);
        }
    }

    public boolean isNdkPath(@NotNull String path) {
        if (path == null) {
            DebugSymbolsUpdater.$$$reportNull$$$0(14);
        }
        return this.myNdkPathMatcher.isNdkPath(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPathLocator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideSdks";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkPathMatcher";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedObjectFiles";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/symbols/DebugSymbolsUpdater";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRemoteSourceFolderPaths";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/symbols/DebugSymbolsUpdater";
                break;
            }
            case 6: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDebugSymbolsInLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateDebugSymbolsInLibrary";
                break;
            }
            case 6: 
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updatePathMappingValues";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isNdkPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class LocalPathLocator {
        LocalPathLocator() {
        }

        boolean isLocal(@NotNull String path) {
            if (path == null) {
                LocalPathLocator.$$$reportNull$$$0(0);
            }
            return new File(path).exists();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/apk/symbols/DebugSymbolsUpdater$LocalPathLocator", "isLocal"));
        }
    }
}

