/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkPathMatcher {
    private static final String NDK_FOLDER_NAME = "ndk-bundle";

    @Nullable
    public File findMatchingPathInNdk(@NotNull String remotePath, @NotNull File localNdkPath) {
        List<String> segments;
        if (remotePath == null) {
            NdkPathMatcher.$$$reportNull$$$0(0);
        }
        if (localNdkPath == null) {
            NdkPathMatcher.$$$reportNull$$$0(1);
        }
        if ((segments = NdkPathMatcher.extractPathSegmentsInNdk(remotePath)) != null) {
            String next = segments.get(0);
            int segmentCount = segments.size();
            if ("toolchains".equals(next) && segmentCount >= 5) {
                File child;
                File[] children;
                File matchingPath;
                next = segments.get(2);
                if ("prebuilt".equals(next) && (matchingPath = new File(localNdkPath, FileUtil.join((String[])new String[]{segments.get(0), segments.get(1), segments.get(2)}))).exists() && matchingPath.isDirectory() && (children = matchingPath.listFiles()) != null && children.length == 1 && (matchingPath = new File(child = children[0], FileUtil.join((String[])ArrayUtil.toStringArray(segments = segments.subList(4, segmentCount))))).isDirectory()) {
                    return matchingPath;
                }
            } else {
                File matchingPath = new File(localNdkPath, FileUtil.join((String[])ArrayUtil.toStringArray(segments)));
                if (matchingPath.isDirectory()) {
                    return matchingPath;
                }
            }
        }
        return null;
    }

    @Nullable
    private static List<String> extractPathSegmentsInNdk(@NotNull String remotePath) {
        int index;
        List segments;
        int segmentCount;
        if (remotePath == null) {
            NdkPathMatcher.$$$reportNull$$$0(2);
        }
        if ((segmentCount = (segments = FileUtil.splitPath((String)remotePath)).size()) > 1 && (index = segments.indexOf(NDK_FOLDER_NAME)) != -1 && index < segmentCount - 1) {
            return segments.subList(index + 1, segmentCount);
        }
        return null;
    }

    boolean isNdkPath(@NotNull String path) {
        List segments;
        int segmentCount;
        if (path == null) {
            NdkPathMatcher.$$$reportNull$$$0(3);
        }
        if ((segmentCount = (segments = FileUtil.splitPath((String)path)).size()) > 1) {
            int index = segments.indexOf(NDK_FOLDER_NAME);
            return index != -1 && index < segmentCount - 1;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localNdkPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/apk/symbols/NdkPathMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findMatchingPathInNdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "extractPathSegmentsInNdk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isNdkPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

