/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.AsyncResult;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.symbols.SharedObjectFile;
import com.android.tools.ndk.AbiFinder;
import com.android.tools.ndk.SourceRootsExtractor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SharedObjectFileFinder {
    @NotNull
    private final AbiFinder myAbiFinder;
    @NotNull
    private final SourceRootsExtractor mySourceRootsExtractor;

    public SharedObjectFileFinder() {
        this(new AbiFinder(), new SourceRootsExtractor());
    }

    @VisibleForTesting
    SharedObjectFileFinder(@NotNull AbiFinder abiFinder, @NotNull SourceRootsExtractor sourceRootsExtractor) {
        if (abiFinder == null) {
            SharedObjectFileFinder.$$$reportNull$$$0(0);
        }
        if (sourceRootsExtractor == null) {
            SharedObjectFileFinder.$$$reportNull$$$0(1);
        }
        this.myAbiFinder = abiFinder;
        this.mySourceRootsExtractor = sourceRootsExtractor;
    }

    @NotNull
    public AsyncResult<List<SharedObjectFile>> findSharedObjectFiles(final @NotNull VirtualFile[] files, final @NotNull NativeLibrary library, @NotNull Project project) {
        if (files == null) {
            SharedObjectFileFinder.$$$reportNull$$$0(2);
        }
        if (library == null) {
            SharedObjectFileFinder.$$$reportNull$$$0(3);
        }
        if (project == null) {
            SharedObjectFileFinder.$$$reportNull$$$0(4);
        }
        final AsyncResult<List<SharedObjectFile>> callback = new AsyncResult<List<SharedObjectFile>>();
        new Task.Modal(project, "Attach Debug Symbols", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText("Searching for debuggable shared object files");
                indicator.setIndeterminate(false);
                try {
                    List<SharedObjectFile> sharedObjectFiles = SharedObjectFileFinder.this.findSharedObjectFilesIn(files, library, indicator);
                    callback.setDone(sharedObjectFiles);
                }
                catch (Throwable error) {
                    callback.setRejected(error);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/apk/symbols/SharedObjectFileFinder$1", "run"));
            }
        }.queue();
        AsyncResult<List<SharedObjectFile>> asyncResult = callback;
        if (asyncResult == null) {
            SharedObjectFileFinder.$$$reportNull$$$0(5);
        }
        return asyncResult;
    }

    @VisibleForTesting
    @NotNull
    List<SharedObjectFile> findSharedObjectFilesIn(@NotNull VirtualFile[] files, @NotNull NativeLibrary library, @NotNull ProgressIndicator indicator) throws IOException {
        if (files == null) {
            SharedObjectFileFinder.$$$reportNull$$$0(6);
        }
        if (library == null) {
            SharedObjectFileFinder.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            SharedObjectFileFinder.$$$reportNull$$$0(8);
        }
        ArrayList<SharedObjectFile> sharedObjectFiles = new ArrayList<SharedObjectFile>();
        int fileCount = files.length;
        for (int i = 0; i < fileCount; ++i) {
            indicator.setFraction((double)i / (double)fileCount);
            VirtualFile file = files[i];
            List<VirtualFile> filesToExamine = SharedObjectFileFinder.findSharedObjectFiles(file, library.name);
            for (VirtualFile fileToExamine : filesToExamine) {
                File pathToExamine = VfsUtilCore.virtualToIoFile((VirtualFile)fileToExamine);
                Abi abi = this.myAbiFinder.findAbi(pathToExamine);
                if (abi == null) {
                    sharedObjectFiles.add(new SharedObjectFile(fileToExamine, pathToExamine));
                    continue;
                }
                List debugSymbolPaths = this.mySourceRootsExtractor.extractSourceRoots(pathToExamine);
                sharedObjectFiles.add(new SharedObjectFile(fileToExamine, pathToExamine, abi, debugSymbolPaths));
            }
        }
        ArrayList<SharedObjectFile> arrayList = sharedObjectFiles;
        if (arrayList == null) {
            SharedObjectFileFinder.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private static List<VirtualFile> findSharedObjectFiles(@NotNull VirtualFile fileOrFolder, final @NotNull String libraryName) {
        if (fileOrFolder == null) {
            SharedObjectFileFinder.$$$reportNull$$$0(10);
        }
        if (libraryName == null) {
            SharedObjectFileFinder.$$$reportNull$$$0(11);
        }
        final ArrayList<VirtualFile> filesToExamine = new ArrayList<VirtualFile>();
        if (fileOrFolder.isDirectory()) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)fileOrFolder, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!file.isDirectory() && libraryName.equals(file.getName())) {
                        filesToExamine.add(file);
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/apk/symbols/SharedObjectFileFinder$2", "visitFile"));
                }
            });
        } else {
            filesToExamine.add(fileOrFolder);
        }
        ArrayList<VirtualFile> arrayList = filesToExamine;
        if (arrayList == null) {
            SharedObjectFileFinder.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abiFinder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRootsExtractor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/symbols/SharedObjectFileFinder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrFolder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/symbols/SharedObjectFileFinder";
                break;
            }
            case 5: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findSharedObjectFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findSharedObjectFilesIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findSharedObjectFiles";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSharedObjectFilesIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

