/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.AsyncResult;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.gradle.util.ContentEntries;
import com.android.tools.idea.io.FilePaths;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SourceFoldersUpdater {
    @NotNull
    public AsyncResult<Void> updateSourceFolders(final @NotNull ApkFacet facet) {
        if (facet == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(0);
        }
        final AsyncResult<Void> callback = new AsyncResult<Void>();
        new Task.Modal(facet.getModule().getProject(), "Updating Source Folders", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                SourceFoldersToUpdate sourceFoldersToUpdate = SourceFoldersUpdater.this.findSourceFoldersToUpdate(facet);
                Module module = facet.getModule();
                ModifiableRootModel moduleModel = SourceFoldersUpdater.getModifiableModuleModel(module);
                try {
                    SourceFoldersUpdater.this.updateSourceFolders(sourceFoldersToUpdate, moduleModel);
                    SourceFoldersUpdater.commit(moduleModel);
                    callback.setDone();
                }
                catch (Throwable error) {
                    SourceFoldersUpdater.dispose(moduleModel);
                    callback.setRejected(error);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/apk/symbols/SourceFoldersUpdater$1", "run"));
            }
        }.queue();
        AsyncResult<Void> asyncResult = callback;
        if (asyncResult == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(1);
        }
        return asyncResult;
    }

    @VisibleForTesting
    void updateSourceFolders(@NotNull SourceFoldersToUpdate sourceFoldersToUpdate, @NotNull ModifiableRootModel moduleModel) {
        if (sourceFoldersToUpdate == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(2);
        }
        if (moduleModel == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(3);
        }
        ContentEntry[] contentEntries = moduleModel.getContentEntries();
        Set<String> sourceFolderPathsToAdd = sourceFoldersToUpdate.getSourceFolderPathsToAdd();
        if (!sourceFolderPathsToAdd.isEmpty()) {
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (String path : sourceFolderPathsToAdd) {
                VirtualFile folder = fileSystem.findFileByPath(path);
                if (folder == null) continue;
                ContentEntry contentEntry = ContentEntries.findParentContentEntry((File)new File(path), Arrays.stream(contentEntries));
                if (contentEntry == null) {
                    contentEntry = moduleModel.addContentEntry(folder);
                }
                contentEntry.addSourceFolder(folder, false);
            }
        }
        SourceFoldersUpdater.removeSourceFolders(sourceFoldersToUpdate.getSourceFolderPathsToRemove(), moduleModel);
    }

    @NotNull
    public AsyncResult<Void> removeSourceFolders(final @NotNull Collection<String> sourceFolderPaths, final @NotNull Module module) {
        if (sourceFolderPaths == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(4);
        }
        if (module == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(5);
        }
        final AsyncResult<Void> callback = new AsyncResult<Void>();
        new Task.Backgroundable(module.getProject(), "Removing Source Folders", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                Set existingSourceFolderPaths = SourceFoldersUpdater.getExistingSourceFolderPaths(module);
                HashSet<String> sourceFolderPathsToRemove = new HashSet<String>();
                for (String path : existingSourceFolderPaths) {
                    if (sourceFolderPaths.contains(path)) continue;
                    sourceFolderPathsToRemove.add(path);
                }
                if (sourceFolderPathsToRemove.isEmpty()) {
                    callback.setDone();
                    return;
                }
                ModifiableRootModel moduleModel = SourceFoldersUpdater.getModifiableModuleModel(module);
                try {
                    SourceFoldersUpdater.removeSourceFolders(sourceFolderPathsToRemove, moduleModel);
                    SourceFoldersUpdater.commit(moduleModel);
                    callback.setDone();
                }
                catch (RuntimeException error) {
                    SourceFoldersUpdater.dispose(moduleModel);
                    callback.setRejected(error);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/apk/symbols/SourceFoldersUpdater$2", "run"));
            }
        }.queue();
        AsyncResult<Void> asyncResult = callback;
        if (asyncResult == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(6);
        }
        return asyncResult;
    }

    private static void removeSourceFolders(@NotNull Collection<String> sourceFolderPaths, @NotNull ModifiableRootModel moduleModel) {
        if (sourceFolderPaths == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(7);
        }
        if (moduleModel == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(8);
        }
        ContentEntry[] contentEntries = moduleModel.getContentEntries();
        HashSet<ContentEntry> contentEntriesToRemove = new HashSet<ContentEntry>();
        for (String sourceFolderPath : sourceFolderPaths) {
            File path = FilePaths.toSystemDependentPath((String)sourceFolderPath);
            ContentEntry parent = ContentEntries.findParentContentEntry((File)path, Arrays.stream(contentEntries));
            if (parent == null) continue;
            SourceFolder[] sourceFolders = parent.getSourceFolders();
            if (sourceFolders.length > 1) {
                for (SourceFolder sourceFolder : sourceFolders) {
                    VirtualFile file = sourceFolder.getFile();
                    if (file == null || !FileUtil.filesEqual((File)path, (File)VfsUtilCore.virtualToIoFile((VirtualFile)file))) continue;
                    parent.removeSourceFolder(sourceFolder);
                }
            } else {
                parent.clearSourceFolders();
            }
            if (parent.getSourceFolders().length != 0) continue;
            contentEntriesToRemove.add(parent);
        }
        for (ContentEntry contentEntry : contentEntriesToRemove) {
            moduleModel.removeContentEntry(contentEntry);
        }
    }

    @VisibleForTesting
    @NotNull
    SourceFoldersToUpdate findSourceFoldersToUpdate(@NotNull ApkFacet facet) {
        if (facet == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(9);
        }
        ApkFacetConfiguration configuration = (ApkFacetConfiguration)facet.getConfiguration();
        Set javaSourceFolderPaths = configuration.JAVA_SOURCE_FOLDER_PATHS;
        Set<String> sourceFolderPathsInLibraries = SourceFoldersUpdater.getSourceFolderPaths(configuration.NATIVE_LIBRARIES);
        Set<String> sourceFolderPathsInModule = SourceFoldersUpdater.getExistingSourceFolderPaths(facet.getModule());
        HashSet<String> sourceFolderPathsToAdd = new HashSet<String>();
        for (String path : sourceFolderPathsInLibraries) {
            if (sourceFolderPathsInModule.contains(path)) continue;
            sourceFolderPathsToAdd.add(path);
        }
        HashSet<String> sourceFolderPathsToRemove = new HashSet<String>();
        for (String path : sourceFolderPathsInModule) {
            if (sourceFolderPathsInLibraries.contains(path) || javaSourceFolderPaths.contains(path)) continue;
            sourceFolderPathsToRemove.add(path);
        }
        SourceFoldersToUpdate sourceFoldersToUpdate = new SourceFoldersToUpdate(sourceFolderPathsToAdd, sourceFolderPathsToRemove);
        if (sourceFoldersToUpdate == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(10);
        }
        return sourceFoldersToUpdate;
    }

    @NotNull
    private static Set<String> getSourceFolderPaths(@NotNull List<NativeLibrary> libraries) {
        if (libraries == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(11);
        }
        HashSet<String> sourceFolderPaths = new HashSet<String>();
        for (NativeLibrary library : libraries) {
            sourceFolderPaths.addAll(library.getSourceFolderPaths());
        }
        HashSet<String> hashSet = sourceFolderPaths;
        if (hashSet == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @NotNull
    private static Set<String> getExistingSourceFolderPaths(@NotNull Module module) {
        if (module == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(13);
        }
        HashSet<String> sourceFolderPaths = new HashSet<String>();
        for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            for (VirtualFile file : contentEntry.getSourceFolderFiles()) {
                File path = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                sourceFolderPaths.add(path.getPath());
            }
        }
        HashSet<String> hashSet = sourceFolderPaths;
        if (hashSet == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    @NotNull
    private static ModifiableRootModel getModifiableModuleModel(@NotNull Module module) {
        if (module == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(15);
        }
        ModifiableRootModel modifiableRootModel = (ModifiableRootModel)ApplicationManager.getApplication().runReadAction(() -> {
            if (module == null) {
                SourceFoldersUpdater.$$$reportNull$$$0(21);
            }
            return ModuleRootManager.getInstance((Module)module).getModifiableModel();
        });
        if (modifiableRootModel == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(16);
        }
        return modifiableRootModel;
    }

    private static void commit(@NotNull ModifiableRootModel moduleModel) {
        if (moduleModel == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(17);
        }
        SourceFoldersUpdater.runWriteAction(() -> ((ModifiableRootModel)moduleModel).commit());
    }

    private static void dispose(@NotNull ModifiableRootModel moduleModel) {
        if (moduleModel == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(18);
        }
        SourceFoldersUpdater.runWriteAction(() -> ((ModifiableRootModel)moduleModel).dispose());
    }

    private static void runWriteAction(@NotNull Runnable action) {
        if (action == null) {
            SourceFoldersUpdater.$$$reportNull$$$0(19);
        }
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            if (action == null) {
                SourceFoldersUpdater.$$$reportNull$$$0(20);
            }
            application.runWriteAction(action);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/symbols/SourceFoldersUpdater";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFoldersToUpdate";
                break;
            }
            case 3: 
            case 8: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolderPaths";
                break;
            }
            case 5: 
            case 13: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/symbols/SourceFoldersUpdater";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "updateSourceFolders";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "removeSourceFolders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourceFoldersToUpdate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolderPaths";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingSourceFolderPaths";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModuleModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateSourceFolders";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceFolders";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSourceFoldersToUpdate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolderPaths";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExistingSourceFolderPaths";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableModuleModel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runWriteAction";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runWriteAction$1";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getModifiableModuleModel$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class SourceFoldersToUpdate {
        @NotNull
        private final Set<String> mySourceFolderPathsToAdd;
        @NotNull
        private final Set<String> mySourceFolderPathsToRemove;

        SourceFoldersToUpdate(@NotNull Set<String> sourceFolderPathsToAdd, @NotNull Set<String> sourceFolderPathsToRemove) {
            if (sourceFolderPathsToAdd == null) {
                SourceFoldersToUpdate.$$$reportNull$$$0(0);
            }
            if (sourceFolderPathsToRemove == null) {
                SourceFoldersToUpdate.$$$reportNull$$$0(1);
            }
            this.mySourceFolderPathsToAdd = sourceFolderPathsToAdd;
            this.mySourceFolderPathsToRemove = sourceFolderPathsToRemove;
        }

        @NotNull
        Set<String> getSourceFolderPathsToAdd() {
            Set<String> set = this.mySourceFolderPathsToAdd;
            if (set == null) {
                SourceFoldersToUpdate.$$$reportNull$$$0(2);
            }
            return set;
        }

        @NotNull
        Set<String> getSourceFolderPathsToRemove() {
            Set<String> set = this.mySourceFolderPathsToRemove;
            if (set == null) {
                SourceFoldersToUpdate.$$$reportNull$$$0(3);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFolderPathsToAdd";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFolderPathsToRemove";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/apk/symbols/SourceFoldersUpdater$SourceFoldersToUpdate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/apk/symbols/SourceFoldersUpdater$SourceFoldersToUpdate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceFolderPathsToAdd";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceFolderPathsToRemove";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

