/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class FolderPathCellEditor
extends LocalPathCellEditor {
    @NotNull
    private final Project myProject;

    public FolderPathCellEditor(@NotNull Project project, @NotNull String originalPath) {
        if (project == null) {
            FolderPathCellEditor.$$$reportNull$$$0(0);
        }
        if (originalPath == null) {
            FolderPathCellEditor.$$$reportNull$$$0(1);
        }
        super(project);
        this.myProject = project;
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        descriptor.setTitle("Debug Symbols");
        descriptor.setDescription("<html>The path:<br/>&nbsp;&nbsp;" + originalPath + "<br/>was not found on this computer.<br/><br/>Please choose a local folder to map this path to.</html>");
        this.fileChooserDescriptor(descriptor);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        super.getTableCellEditorComponent(table, value, isSelected, row, column);
        Color editorBackground = UIUtil.getTableBackground();
        ComponentWithBrowseButton componentWithButton = this.myComponent.getComponentWithButton();
        componentWithButton.setBackground(editorBackground);
        componentWithButton.getButton().setBackground(editorBackground);
        ((JTextField)componentWithButton.getChildComponent()).setName("folderPathCellEditorTextField");
        return this.myComponent;
    }

    @NotNull
    protected ActionListener createActionListener(JTable table) {
        ActionListener actionListener = e -> {
            String initial = (String)this.getCellEditorValue();
            VirtualFile initialFile = StringUtil.isNotEmpty((String)initial) ? LocalFileSystem.getInstance().findFileByPath(initial) : null;
            FileChooserDialogImpl chooser = new FileChooserDialogImpl(this.getFileChooserDescriptor(), this.myProject);
            chooser.choose(initialFile, files -> {
                VirtualFile file = (VirtualFile)files.get(0);
                String path = file.getPresentableUrl();
                if (SystemInfo.isWindows && path.length() == 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
                    path = path + "\\";
                }
                ((JTextField)this.myComponent.getChildComponent()).setText(path);
            });
        };
        if (actionListener == null) {
            FolderPathCellEditor.$$$reportNull$$$0(2);
        }
        return actionListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/symbols/ui/FolderPathCellEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/symbols/ui/FolderPathCellEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

