/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols.ui;

import com.google.common.collect.Lists;
import com.intellij.util.ui.FilePathSplittingPolicy;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class TrimLeftFilePathSplittingPolicy
extends FilePathSplittingPolicy {
    TrimLeftFilePathSplittingPolicy() {
    }

    public String getPresentableName(@NotNull File filePath, int length) {
        String current;
        String path;
        if (filePath == null) {
            TrimLeftFilePathSplittingPolicy.$$$reportNull$$$0(0);
        }
        if ((path = filePath.getPath()).length() <= length) {
            return path;
        }
        String name = filePath.getName();
        int nameLength = name.length();
        String ellipsis = "...";
        if (length < nameLength) {
            return ellipsis;
        }
        if (length == nameLength) {
            return name;
        }
        List<String> partsInReverse = TrimLeftFilePathSplittingPolicy.getPartsInReverse(filePath);
        int partsCount = partsInReverse.size();
        String last = partsInReverse.get(partsCount - 1);
        List<String> parts = new ArrayList(partsCount);
        int currentLength = last.length() + ellipsis.length();
        if (currentLength + nameLength > length) {
            return name;
        }
        for (int i = 0; i < partsCount - 1 && (currentLength += (current = partsInReverse.get(i)).length()) < length; ++i) {
            parts.add(current);
        }
        if (parts.size() > 1) {
            parts = Lists.reverse(parts);
        }
        StringBuilder buffer = new StringBuilder(length);
        buffer.append(last);
        buffer.append(ellipsis);
        for (String part : parts) {
            buffer.append(part);
        }
        return buffer.toString();
    }

    @NotNull
    private static List<String> getPartsInReverse(@NotNull File filePath) {
        if (filePath == null) {
            TrimLeftFilePathSplittingPolicy.$$$reportNull$$$0(1);
        }
        ArrayList<String> result = new ArrayList<String>();
        File current = filePath;
        while (current != null) {
            String fileName = TrimLeftFilePathSplittingPolicy.getFileName(current);
            if (!fileName.isEmpty()) {
                result.add(fileName);
            }
            if ((current = current.getParentFile()) == null) continue;
            result.add(File.separator);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            TrimLeftFilePathSplittingPolicy.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static String getFileName(@NotNull File filePath) {
        String result;
        if (filePath == null) {
            TrimLeftFilePathSplittingPolicy.$$$reportNull$$$0(3);
        }
        if (!(result = filePath.getName()).isEmpty()) {
            String string = result;
            if (string == null) {
                TrimLeftFilePathSplittingPolicy.$$$reportNull$$$0(4);
            }
            return string;
        }
        String path = filePath.getPath();
        String string = path.substring(0, path.length() - 1);
        if (string == null) {
            TrimLeftFilePathSplittingPolicy.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/symbols/ui/TrimLeftFilePathSplittingPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/symbols/ui/TrimLeftFilePathSplittingPolicy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartsInReverse";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPartsInReverse";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

