/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.DataClassMethodGenerator;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH$J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\u001e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\fH$J\u0016\u0010\u001f\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\fH\u0002J\u0016\u0010 \u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0016\u0010\"\u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0016\u0010#\u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010$\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\fH$J\u001e\u0010%\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\fH$J\u001e\u0010&\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\fH$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/common/DataClassMethodGenerator;", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "dataProperties", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getDataProperties", "()Ljava/util/List;", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "primaryConstructorParameters", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getPrimaryConstructorParameters", "generate", "", "generateComponentFunction", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "generateComponentFunctionsForDataClasses", "generateCopyFunction", "constructorParameters", "generateCopyFunctionForDataClasses", "generateDataClassEqualsIfNeeded", "properties", "generateDataClassHashCodeIfNeeded", "generateDataClassToStringIfNeeded", "generateEqualsMethod", "generateHashCodeMethod", "generateToStringMethod", "backend-common"})
public abstract class DataClassMethodGenerator {
    @NotNull
    private final ClassDescriptor classDescriptor;
    @NotNull
    private final KtClassOrObject declaration;
    private final BindingContext bindingContext;

    @NotNull
    protected final ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public final void generate() {
        this.generateComponentFunctionsForDataClasses();
        this.generateCopyFunctionForDataClasses(this.getPrimaryConstructorParameters());
        List<PropertyDescriptor> properties2 = this.getDataProperties();
        Collection collection = properties2;
        if (!collection.isEmpty()) {
            this.generateDataClassToStringIfNeeded(properties2);
            this.generateDataClassHashCodeIfNeeded(properties2);
            this.generateDataClassEqualsIfNeeded(properties2);
        }
    }

    protected abstract void generateComponentFunction(@NotNull FunctionDescriptor var1, @NotNull ValueParameterDescriptor var2);

    protected abstract void generateCopyFunction(@NotNull FunctionDescriptor var1, @NotNull List<? extends KtParameter> var2);

    protected abstract void generateToStringMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    protected abstract void generateHashCodeMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    protected abstract void generateEqualsMethod(@NotNull FunctionDescriptor var1, @NotNull List<? extends PropertyDescriptor> var2);

    private final void generateComponentFunctionsForDataClasses() {
        ClassConstructorDescriptor constructor2;
        ClassConstructorDescriptor classConstructorDescriptor = this.classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor classConstructorDescriptor2 = constructor2 = classConstructorDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptor2, (String)"constructor");
        for (ValueParameterDescriptor parameter : classConstructorDescriptor2.getValueParameters()) {
            FunctionDescriptor function2 = (FunctionDescriptor)this.bindingContext.get(BindingContext.DATA_CLASS_COMPONENT_FUNCTION, parameter);
            if (function2 == null) continue;
            ValueParameterDescriptor valueParameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameter");
            this.generateComponentFunction(function2, valueParameterDescriptor);
        }
    }

    private final void generateCopyFunctionForDataClasses(List<? extends KtParameter> constructorParameters) {
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)this.bindingContext.get(BindingContext.DATA_CLASS_COPY_FUNCTION, this.classDescriptor);
        if (functionDescriptor2 == null) {
            return;
        }
        FunctionDescriptor copyFunction = functionDescriptor2;
        this.generateCopyFunction(copyFunction, constructorParameters);
    }

    private final void generateDataClassToStringIfNeeded(List<? extends PropertyDescriptor> properties2) {
        FunctionDescriptor functionDescriptor2 = CodegenUtil.INSTANCE.getMemberToGenerate(this.classDescriptor, "toString", (Function1<? super KotlinType, Boolean>)((Function1)generateDataClassToStringIfNeeded.function.1.INSTANCE), (Function1<? super List<? extends ValueParameterDescriptor>, Boolean>)((Function1)generateDataClassToStringIfNeeded.function.2.INSTANCE));
        if (functionDescriptor2 == null) {
            return;
        }
        FunctionDescriptor function2 = functionDescriptor2;
        this.generateToStringMethod(function2, properties2);
    }

    private final void generateDataClassHashCodeIfNeeded(List<? extends PropertyDescriptor> properties2) {
        FunctionDescriptor functionDescriptor2 = CodegenUtil.INSTANCE.getMemberToGenerate(this.classDescriptor, "hashCode", (Function1<? super KotlinType, Boolean>)((Function1)generateDataClassHashCodeIfNeeded.function.1.INSTANCE), (Function1<? super List<? extends ValueParameterDescriptor>, Boolean>)((Function1)generateDataClassHashCodeIfNeeded.function.2.INSTANCE));
        if (functionDescriptor2 == null) {
            return;
        }
        FunctionDescriptor function2 = functionDescriptor2;
        this.generateHashCodeMethod(function2, properties2);
    }

    private final void generateDataClassEqualsIfNeeded(List<? extends PropertyDescriptor> properties2) {
        FunctionDescriptor functionDescriptor2 = CodegenUtil.INSTANCE.getMemberToGenerate(this.classDescriptor, "equals", (Function1<? super KotlinType, Boolean>)((Function1)generateDataClassEqualsIfNeeded.function.1.INSTANCE), (Function1<? super List<? extends ValueParameterDescriptor>, Boolean>)((Function1)generateDataClassEqualsIfNeeded.function.2.INSTANCE));
        if (functionDescriptor2 == null) {
            return;
        }
        FunctionDescriptor function2 = functionDescriptor2;
        this.generateEqualsMethod(function2, properties2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PropertyDescriptor> getDataProperties() {
        void var3_3;
        KtParameter it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = this.getPrimaryConstructorParameters();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (KtParameter)element$iv$iv;
            if (!it.hasValOrVar()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (KtParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            Object v = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, it);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)v;
            collection.add(propertyDescriptor);
        }
        return (List)var3_3;
    }

    private final List<KtParameter> getPrimaryConstructorParameters() {
        KtClassOrObject ktClassOrObject = this.declaration;
        if (!(ktClassOrObject instanceof KtClass)) {
            ktClassOrObject = null;
        }
        KtClass ktClass2 = (KtClass)ktClassOrObject;
        List list2 = ktClass2 != null ? ktClass2.getPrimaryConstructorParameters() : null;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @NotNull
    protected final KtClassOrObject getDeclaration() {
        return this.declaration;
    }

    public DataClassMethodGenerator(@NotNull KtClassOrObject declaration2, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        this.declaration = declaration2;
        this.bindingContext = bindingContext2;
        this.classDescriptor = (ClassDescriptor)BindingContextUtils.getNotNull(this.bindingContext, BindingContext.CLASS, this.declaration);
    }
}

