/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.caches.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ResolverForModuleFactory;
import org.jetbrains.kotlin.analyzer.common.CommonAnalyzerFacade;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.caches.resolve.IdePlatformSupport;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.context.GlobalContextImpl;
import org.jetbrains.kotlin.idea.caches.resolve.PlatformAnalysisSettings;
import org.jetbrains.kotlin.idea.framework.CommonLibraryKind;
import org.jetbrains.kotlin.resolve.TargetPlatform;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/caches/resolve/CommonPlatformSupport;", "Lorg/jetbrains/kotlin/caches/resolve/IdePlatformSupport;", "()V", "libraryKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getLibraryKind", "()Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "platform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "resolverForModuleFactory", "Lorg/jetbrains/kotlin/analyzer/ResolverForModuleFactory;", "getResolverForModuleFactory", "()Lorg/jetbrains/kotlin/analyzer/ResolverForModuleFactory;", "createBuiltIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "settings", "Lorg/jetbrains/kotlin/idea/caches/resolve/PlatformAnalysisSettings;", "sdkContext", "Lorg/jetbrains/kotlin/context/GlobalContextImpl;", "isModuleForPlatform", "", "module", "Lcom/intellij/openapi/module/Module;", "idea-core"})
public final class CommonPlatformSupport
extends IdePlatformSupport {
    @Override
    @NotNull
    public TargetPlatform getPlatform() {
        return TargetPlatform.Common.INSTANCE;
    }

    @Override
    @NotNull
    public ResolverForModuleFactory getResolverForModuleFactory() {
        return CommonAnalyzerFacade.INSTANCE;
    }

    @Override
    @Nullable
    public PersistentLibraryKind<?> getLibraryKind() {
        return CommonLibraryKind.INSTANCE;
    }

    @Override
    public boolean isModuleForPlatform(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        KotlinFacetSettings settings2 = KotlinFacetSettingsProvider.Companion.getInstance(project).getInitializedSettings(module);
        return settings2.getTargetPlatformKind() instanceof TargetPlatformKind.Common;
    }

    @Override
    @NotNull
    public KotlinBuiltIns createBuiltIns(@NotNull PlatformAnalysisSettings settings2, @NotNull GlobalContextImpl sdkContext) {
        Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)sdkContext, (String)"sdkContext");
        return DefaultBuiltIns.Companion.getInstance();
    }
}

