/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AccessorForCompanionObjectInstanceFieldDescriptor;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.CallableReferenceUtilKt;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.intrinsics.HashCode;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class AsmUtil {
    private static final Set<Type> STRING_BUILDER_OBJECT_APPEND_ARG_TYPES = Sets.newHashSet((Object[])new Type[]{AsmTypes.getType(String.class), AsmTypes.getType(StringBuffer.class), AsmTypes.getType(CharSequence.class)});
    private static final int NO_FLAG_LOCAL = 0;
    public static final int NO_FLAG_PACKAGE_PRIVATE = 0;
    @NotNull
    private static final Map<Visibility, Integer> visibilityToAccessFlag = ImmutableMap.builder().put((Object)Visibilities.PRIVATE, (Object)2).put((Object)Visibilities.PRIVATE_TO_THIS, (Object)2).put((Object)Visibilities.PROTECTED, (Object)4).put((Object)JavaVisibilities.PROTECTED_STATIC_VISIBILITY, (Object)4).put((Object)JavaVisibilities.PROTECTED_AND_PACKAGE, (Object)4).put((Object)Visibilities.PUBLIC, (Object)1).put((Object)Visibilities.INTERNAL, (Object)1).put((Object)Visibilities.LOCAL, (Object)0).put((Object)JavaVisibilities.PACKAGE_VISIBILITY, (Object)0).build();
    public static final String BOUND_REFERENCE_RECEIVER = "receiver";
    public static final String RECEIVER_NAME = "$receiver";
    public static final String CAPTURED_RECEIVER_FIELD = "receiver$0";
    public static final String CAPTURED_THIS_FIELD = "this$0";
    private static final ImmutableMap<Integer, JvmPrimitiveType> primitiveTypeByAsmSort;
    private static final ImmutableMap<Type, Type> primitiveTypeByBoxedType;

    private AsmUtil() {
    }

    @NotNull
    public static Type boxType(@NotNull Type type2) {
        JvmPrimitiveType jvmPrimitiveType = (JvmPrimitiveType)((Object)primitiveTypeByAsmSort.get((Object)type2.getSort()));
        return jvmPrimitiveType != null ? AsmUtil.asmTypeByFqNameWithoutInnerClasses(jvmPrimitiveType.getWrapperFqName()) : type2;
    }

    @NotNull
    public static Type unboxType(@NotNull Type boxedType) {
        Type primitiveType = AsmUtil.unboxPrimitiveTypeOrNull(boxedType);
        if (primitiveType == null) {
            throw new UnsupportedOperationException("Unboxing: " + boxedType);
        }
        return primitiveType;
    }

    @Nullable
    public static Type unboxPrimitiveTypeOrNull(@NotNull Type boxedType) {
        return (Type)primitiveTypeByBoxedType.get((Object)boxedType);
    }

    @NotNull
    public static Type unboxUnlessPrimitive(@NotNull Type boxedOrPrimitiveType) {
        if (AsmUtil.isPrimitive(boxedOrPrimitiveType)) {
            return boxedOrPrimitiveType;
        }
        return AsmUtil.unboxType(boxedOrPrimitiveType);
    }

    public static boolean isBoxedTypeOf(@NotNull Type boxedType, @NotNull Type unboxedType) {
        return AsmUtil.unboxPrimitiveTypeOrNull(boxedType) == unboxedType;
    }

    public static boolean isIntPrimitive(Type type2) {
        return type2 == Type.INT_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.CHAR_TYPE;
    }

    public static boolean isIntOrLongPrimitive(Type type2) {
        return AsmUtil.isIntPrimitive(type2) || type2 == Type.LONG_TYPE;
    }

    public static boolean isPrimitive(Type type2) {
        return type2.getSort() != 10 && type2.getSort() != 9;
    }

    public static boolean isPrimitiveNumberClassDescriptor(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return false;
        }
        return KotlinBuiltIns.isPrimitiveClass((ClassDescriptor)descriptor2) && !KotlinBuiltIns.isBoolean((ClassDescriptor)descriptor2);
    }

    @NotNull
    public static Type correctElementType(@NotNull Type type2) {
        String internalName = type2.getInternalName();
        assert (internalName.charAt(0) == '[');
        return Type.getType((String)internalName.substring(1));
    }

    @NotNull
    public static Type getArrayType(@NotNull Type componentType) {
        return Type.getType((String)("[" + componentType.getDescriptor()));
    }

    @Nullable
    public static PrimitiveType asmPrimitiveTypeToLangPrimitiveType(Type type2) {
        JvmPrimitiveType jvmPrimitiveType = (JvmPrimitiveType)((Object)primitiveTypeByAsmSort.get((Object)type2.getSort()));
        return jvmPrimitiveType != null ? jvmPrimitiveType.getPrimitiveType() : null;
    }

    @NotNull
    public static Method method(@NotNull String name2, @NotNull Type returnType2, Type ... parameterTypes2) {
        return new Method(name2, Type.getMethodDescriptor((Type)returnType2, (Type[])parameterTypes2));
    }

    public static boolean isAbstractMethod(FunctionDescriptor functionDescriptor2, OwnerKind kind) {
        return (functionDescriptor2.getModality() == Modality.ABSTRACT || JvmCodegenUtil.isJvmInterface(functionDescriptor2.getContainingDeclaration()) && !AnnotationUtilKt.hasJvmDefaultAnnotation(functionDescriptor2)) && !AsmUtil.isStaticMethod(kind, functionDescriptor2);
    }

    public static boolean isStaticMethod(OwnerKind kind, CallableMemberDescriptor functionDescriptor2) {
        return AsmUtil.isStaticKind(kind) || KotlinTypeMapper.isStaticAccessor(functionDescriptor2) || CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(functionDescriptor2);
    }

    public static boolean isStaticKind(OwnerKind kind) {
        return kind == OwnerKind.PACKAGE || kind == OwnerKind.DEFAULT_IMPLS || kind == OwnerKind.ERASED_INLINE_CLASS;
    }

    public static int getMethodAsmFlags(FunctionDescriptor functionDescriptor2, OwnerKind kind, GenerationState state) {
        DeclarationDescriptor containingDeclaration2;
        int flags = AsmUtil.getCommonCallableFlags(functionDescriptor2, state);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.METHOD_FLAGS) {
            if (!flagAnnotation.hasAnnotation(functionDescriptor2.getOriginal())) continue;
            flags |= flagAnnotation.getJvmFlag();
        }
        if (functionDescriptor2.getOriginal().isExternal()) {
            flags |= 0x100;
        }
        if (CodegenUtilKt.isJvmStaticInCompanionObject(functionDescriptor2)) {
            flags &= 0xFFFFFEFF;
        }
        if (!(functionDescriptor2.getModality() != Modality.FINAL || functionDescriptor2 instanceof ConstructorDescriptor || (containingDeclaration2 = functionDescriptor2.getContainingDeclaration()) instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration2).getKind() == ClassKind.INTERFACE)) {
            flags |= 0x10;
        }
        if (AsmUtil.isStaticMethod(kind, functionDescriptor2)) {
            flags |= 8;
        }
        if (AsmUtil.isAbstractMethod(functionDescriptor2, kind)) {
            flags |= 0x400;
        }
        if (KotlinTypeMapper.isAccessor(functionDescriptor2) || AnnotationUtilKt.hasJvmSyntheticAnnotation(functionDescriptor2)) {
            flags |= 0x1000;
        }
        return flags;
    }

    public static int getCommonCallableFlags(FunctionDescriptor functionDescriptor2, @NotNull GenerationState state) {
        int flags = AsmUtil.getVisibilityAccessFlag(functionDescriptor2);
        flags |= AsmUtil.getVarargsFlag(functionDescriptor2);
        flags |= AsmUtil.getDeprecatedAccessFlag(functionDescriptor2);
        if (state.getDeprecationProvider().isDeprecatedHidden(functionDescriptor2) || functionDescriptor2.isSuspend() && functionDescriptor2.getVisibility().equals(Visibilities.PRIVATE)) {
            flags |= 0x1000;
        }
        return flags;
    }

    public static int getVisibilityAccessFlag(@NotNull MemberDescriptor descriptor2) {
        Integer specialCase = AsmUtil.specialCaseVisibility(descriptor2);
        if (specialCase != null) {
            return specialCase;
        }
        Visibility visibility = descriptor2.getVisibility();
        Integer defaultMapping = AsmUtil.getVisibilityAccessFlag(visibility);
        if (defaultMapping == null) {
            throw new IllegalStateException(visibility + " is not a valid visibility in backend for " + DescriptorRenderer.DEBUG_TEXT.render(descriptor2));
        }
        return defaultMapping;
    }

    @Nullable
    public static Integer getVisibilityAccessFlag(Visibility visibility) {
        return visibilityToAccessFlag.get(visibility);
    }

    public static int getVisibilityAccessFlagForClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 instanceof SyntheticClassDescriptorForLambda) {
            return AsmUtil.getVisibilityAccessFlagForAnonymous(descriptor2);
        }
        if (ExpectedActualDeclarationChecker.isOptionalAnnotationClass(descriptor2)) {
            return 0;
        }
        if (descriptor2.getVisibility() == Visibilities.PUBLIC || descriptor2.getVisibility() == Visibilities.PROTECTED || descriptor2.getVisibility() == Visibilities.LOCAL || descriptor2.getVisibility() == Visibilities.INTERNAL) {
            return 1;
        }
        return 0;
    }

    private static int getVisibilityAccessFlagForAnonymous(@NotNull ClassDescriptor descriptor2) {
        return InlineUtil.isInlineOrContainingInline(descriptor2.getContainingDeclaration()) ? 1 : 0;
    }

    public static int calculateInnerClassAccessFlags(@NotNull ClassDescriptor innerClass) {
        int visibility = innerClass instanceof SyntheticClassDescriptorForLambda ? AsmUtil.getVisibilityAccessFlagForAnonymous(innerClass) : (innerClass.getVisibility() == Visibilities.LOCAL ? 1 : AsmUtil.getVisibilityAccessFlag(innerClass));
        return visibility | AsmUtil.innerAccessFlagsForModalityAndKind(innerClass) | (innerClass.isInner() ? 0 : 8);
    }

    private static int innerAccessFlagsForModalityAndKind(@NotNull ClassDescriptor innerClass) {
        switch (innerClass.getKind()) {
            case INTERFACE: {
                return 1536;
            }
            case ENUM_CLASS: {
                return 16400;
            }
            case ANNOTATION_CLASS: {
                return 9728;
            }
        }
        Modality modality = innerClass.getModality();
        if (modality == Modality.FINAL) {
            return 16;
        }
        if (modality == Modality.ABSTRACT || modality == Modality.SEALED) {
            return 1024;
        }
        return 0;
    }

    public static int getDeprecatedAccessFlag(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return KotlinBuiltIns.isDeprecated(descriptor2) ? 131072 : AsmUtil.getDeprecatedAccessFlag(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty());
        }
        if (KotlinBuiltIns.isDeprecated(descriptor2)) {
            return 131072;
        }
        return 0;
    }

    private static int getVarargsFlag(FunctionDescriptor functionDescriptor2) {
        if (!functionDescriptor2.getValueParameters().isEmpty() && functionDescriptor2.getValueParameters().get(functionDescriptor2.getValueParameters().size() - 1).getVarargElementType() != null) {
            return 128;
        }
        return 0;
    }

    @Nullable
    private static Integer specialCaseVisibility(@NotNull MemberDescriptor memberDescriptor) {
        PropertyDescriptor property;
        DeclarationDescriptor containingDeclaration2 = memberDescriptor.getContainingDeclaration();
        Visibility memberVisibility = memberDescriptor.getVisibility();
        if (org.jetbrains.kotlin.descriptors.annotations.AnnotationUtilKt.isEffectivelyInlineOnly(memberDescriptor)) {
            return 2;
        }
        if (memberVisibility == Visibilities.LOCAL && memberDescriptor instanceof CallableMemberDescriptor) {
            return 1;
        }
        if (DescriptorUtils.isEnumEntry(memberDescriptor)) {
            return 0;
        }
        if (CodegenUtilKt.isToArrayFromCollection(memberDescriptor)) {
            return 1;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(memberDescriptor.getContainingDeclaration())) {
            return AsmUtil.getVisibilityAccessFlagForAnonymous((ClassDescriptor)memberDescriptor.getContainingDeclaration());
        }
        if (memberDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return AsmUtil.getVisibilityAccessFlag(((SyntheticJavaPropertyDescriptor)memberDescriptor).getGetMethod());
        }
        if (memberDescriptor instanceof PropertyAccessorDescriptor && (property = ((PropertyAccessorDescriptor)memberDescriptor).getCorrespondingProperty()) instanceof SyntheticJavaPropertyDescriptor) {
            FunctionDescriptor method;
            FunctionDescriptor functionDescriptor2 = method = memberDescriptor == property.getGetter() ? ((SyntheticJavaPropertyDescriptor)property).getGetMethod() : ((SyntheticJavaPropertyDescriptor)property).getSetMethod();
            assert (method != null) : "No get/set method in SyntheticJavaPropertyDescriptor: " + property;
            return AsmUtil.getVisibilityAccessFlag(method);
        }
        if (memberDescriptor instanceof CallableDescriptor && memberVisibility == Visibilities.PROTECTED) {
            for (CallableDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)((Object)memberDescriptor))) {
                if (!JvmCodegenUtil.isJvmInterface(overridden.getContainingDeclaration())) continue;
                return 1;
            }
        }
        if (!Visibilities.isPrivate(memberVisibility)) {
            return null;
        }
        if (memberDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)memberDescriptor).isSuspend()) {
            return 0;
        }
        if (memberDescriptor instanceof AccessorForCompanionObjectInstanceFieldDescriptor) {
            return 0;
        }
        if (memberDescriptor instanceof ConstructorDescriptor) {
            if (DescriptorUtils.isEnumEntry(containingDeclaration2)) {
                return 0;
            }
            if (DescriptorUtils.isEnumClass(containingDeclaration2)) {
                return 4;
            }
        }
        return null;
    }

    public static Type stringValueOfType(Type type2) {
        int sort = type2.getSort();
        return sort == 10 || sort == 9 ? AsmTypes.OBJECT_TYPE : (sort == 3 || sort == 4 ? Type.INT_TYPE : type2);
    }

    private static Type stringBuilderAppendType(Type type2) {
        switch (type2.getSort()) {
            case 10: {
                return STRING_BUILDER_OBJECT_APPEND_ARG_TYPES.contains(type2) ? type2 : AsmTypes.OBJECT_TYPE;
            }
            case 9: {
                return AsmTypes.OBJECT_TYPE;
            }
            case 3: 
            case 4: {
                return Type.INT_TYPE;
            }
        }
        return type2;
    }

    public static void genThrow(@NotNull InstructionAdapter v, @NotNull String exception, @Nullable String message2) {
        v.anew(Type.getObjectType((String)exception));
        v.dup();
        if (message2 != null) {
            v.aconst((Object)message2);
            v.invokespecial(exception, "<init>", "(Ljava/lang/String;)V", false);
        } else {
            v.invokespecial(exception, "<init>", "()V", false);
        }
        v.athrow();
    }

    public static void genClosureFields(@NotNull CalculatedClosure closure, ClassBuilder v, KotlinTypeMapper typeMapper) {
        KotlinType captureReceiverType;
        ArrayList<Pair<String, Type>> allFields = new ArrayList<Pair<String, Type>>();
        ClassDescriptor captureThis = closure.getCaptureThis();
        if (captureThis != null) {
            allFields.add(Pair.create((Object)CAPTURED_THIS_FIELD, (Object)typeMapper.mapType(captureThis)));
        }
        if ((captureReceiverType = closure.getCaptureReceiverType()) != null && !CallableReferenceUtilKt.isForCallableReference(closure)) {
            allFields.add((Pair<String, Type>)Pair.create((Object)CAPTURED_RECEIVER_FIELD, (Object)typeMapper.mapType(captureReceiverType)));
        }
        allFields.addAll(closure.getRecordedFields());
        AsmUtil.genClosureFields(allFields, v);
    }

    public static void genClosureFields(List<Pair<String, Type>> allFields, ClassBuilder builder) {
        int access = 4112;
        for (Pair<String, Type> field2 : allFields) {
            builder.newField(JvmDeclarationOrigin.NO_ORIGIN, access, (String)field2.first, ((Type)field2.second).getDescriptor(), null, null);
        }
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info, int index2, InstructionAdapter iv) {
        return AsmUtil.genAssignInstanceFieldFromParam(info, index2, iv, 0);
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info, int index2, InstructionAdapter iv, int ownerIndex) {
        assert (!info.isStatic());
        Type fieldType = info.getFieldType();
        iv.load(ownerIndex, info.getOwnerType());
        iv.load(index2, fieldType);
        iv.visitFieldInsn(181, info.getOwnerInternalName(), info.getFieldName(), fieldType.getDescriptor());
        return index2 += fieldType.getSize();
    }

    public static void genStringBuilderConstructor(InstructionAdapter v) {
        v.visitTypeInsn(187, "java/lang/StringBuilder");
        v.dup();
        v.invokespecial("java/lang/StringBuilder", "<init>", "()V", false);
    }

    public static void genInvokeAppendMethod(InstructionAdapter v, Type type2) {
        type2 = AsmUtil.stringBuilderAppendType(type2);
        v.invokevirtual("java/lang/StringBuilder", "append", "(" + type2.getDescriptor() + ")Ljava/lang/StringBuilder;", false);
    }

    public static StackValue genToString(StackValue receiver, Type receiverType2) {
        return StackValue.operation(AsmTypes.JAVA_STRING_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            Type type2 = AsmUtil.stringValueOfType(receiverType2);
            receiver.put(type2, (InstructionAdapter)v);
            v.invokestatic("java/lang/String", "valueOf", "(" + type2.getDescriptor() + ")Ljava/lang/String;", false);
            return null;
        }));
    }

    static void genHashCode(MethodVisitor mv, InstructionAdapter iv, Type type2, JvmTarget jvmTarget) {
        if (type2.getSort() == 9) {
            Type elementType = AsmUtil.correctElementType(type2);
            if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                iv.invokestatic("java/util/Arrays", "hashCode", "([Ljava/lang/Object;)I", false);
            } else {
                iv.invokestatic("java/util/Arrays", "hashCode", "(" + type2.getDescriptor() + ")I", false);
            }
        } else if (type2.getSort() == 10) {
            iv.invokevirtual("java/lang/Object", "hashCode", "()I", false);
        } else if (type2.getSort() == 1) {
            Label end = new Label();
            iv.dup();
            iv.ifeq(end);
            iv.pop();
            iv.iconst(1);
            iv.mark(end);
        } else if (JvmTarget.JVM_1_6 == jvmTarget) {
            if (type2.getSort() == 7) {
                AsmUtil.genLongHashCode(mv, iv);
            } else if (type2.getSort() == 8) {
                iv.invokestatic("java/lang/Double", "doubleToLongBits", "(D)J", false);
                AsmUtil.genLongHashCode(mv, iv);
            } else if (type2.getSort() == 6) {
                iv.invokestatic("java/lang/Float", "floatToIntBits", "(F)I", false);
            }
        } else {
            HashCode.Companion.invokeHashCode(iv, type2);
        }
    }

    private static void genLongHashCode(MethodVisitor mv, InstructionAdapter iv) {
        iv.dup2();
        iv.iconst(32);
        iv.ushr(Type.LONG_TYPE);
        iv.xor(Type.LONG_TYPE);
        mv.visitInsn(136);
    }

    public static void genInvertBoolean(InstructionAdapter v) {
        v.iconst(1);
        v.xor(Type.INT_TYPE);
    }

    @NotNull
    public static StackValue genEqualsForExpressionsOnStack(@NotNull IElementType opToken, @NotNull StackValue left, @NotNull StackValue right) {
        Type leftType = left.type;
        Type rightType = right.type;
        if (AsmUtil.isPrimitive(leftType) && leftType == rightType) {
            return StackValue.cmp(opToken, leftType, left, right);
        }
        return StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            left.put(leftType, (InstructionAdapter)v);
            right.put(rightType, (InstructionAdapter)v);
            AsmUtil.genAreEqualCall(v);
            if (opToken == KtTokens.EXCLEQ || opToken == KtTokens.EXCLEQEQEQ) {
                AsmUtil.genInvertBoolean(v);
            }
            return Unit.INSTANCE;
        }));
    }

    public static void genAreEqualCall(InstructionAdapter v) {
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
    }

    public static void genIEEE754EqualForNullableTypesCall(InstructionAdapter v, Type left, Type right) {
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(" + left.getDescriptor() + right.getDescriptor() + ")Z", false);
    }

    public static void numConst(int value, Type type2, InstructionAdapter v) {
        if (type2 == Type.FLOAT_TYPE) {
            v.fconst((float)value);
        } else if (type2 == Type.DOUBLE_TYPE) {
            v.dconst((double)value);
        } else if (type2 == Type.LONG_TYPE) {
            v.lconst((long)value);
        } else if (type2 == Type.CHAR_TYPE || type2 == Type.BYTE_TYPE || type2 == Type.SHORT_TYPE || type2 == Type.INT_TYPE) {
            v.iconst(value);
        } else {
            throw new IllegalArgumentException("Primitive numeric type expected, got: " + type2);
        }
    }

    public static void genIncrement(Type baseType, int myDelta, InstructionAdapter v) {
        Type operationType = AsmUtil.numberFunctionOperandType(baseType);
        AsmUtil.numConst(myDelta, operationType, v);
        v.add(operationType);
        StackValue.coerce(operationType, baseType, v);
    }

    public static void swap(InstructionAdapter v, Type stackTop, Type afterTop) {
        if (stackTop.getSize() == 1) {
            if (afterTop.getSize() == 1) {
                v.swap();
            } else {
                v.dupX2();
                v.pop();
            }
        } else {
            if (afterTop.getSize() == 1) {
                v.dup2X1();
            } else {
                v.dup2X2();
            }
            v.pop2();
        }
    }

    public static void genNotNullAssertionsForParameters(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull FunctionDescriptor descriptor2, @NotNull FrameMap frameMap) {
        if (state.isParamAssertionsDisabled()) {
            return;
        }
        if (descriptor2.isSuspend()) {
            return;
        }
        if (AsmUtil.getVisibilityAccessFlag(descriptor2) == 2) {
            ReceiverParameterDescriptor receiverParameter;
            if (state.isReceiverAssertionsDisabled()) {
                return;
            }
            if (descriptor2.isOperator() && (receiverParameter = descriptor2.getExtensionReceiverParameter()) != null) {
                AsmUtil.genParamAssertion(v, state.getTypeMapper(), frameMap, receiverParameter, RECEIVER_NAME);
            }
            return;
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            AsmUtil.genParamAssertion(v, state.getTypeMapper(), frameMap, receiverParameter, RECEIVER_NAME);
        }
        for (ValueParameterDescriptor parameter : descriptor2.getValueParameters()) {
            AsmUtil.genParamAssertion(v, state.getTypeMapper(), frameMap, parameter, parameter.getName().asString());
        }
    }

    private static void genParamAssertion(@NotNull InstructionAdapter v, @NotNull KotlinTypeMapper typeMapper, @NotNull FrameMap frameMap, @NotNull ParameterDescriptor parameter, @NotNull String name2) {
        KotlinType type2 = parameter.getType();
        if (TypeUtils.isNullableType(type2) || InlineClassesUtilsKt.isNullableUnderlyingType(type2)) {
            return;
        }
        int index2 = frameMap.getIndex(parameter);
        Type asmType = typeMapper.mapType(type2);
        if (asmType.getSort() == 10 || asmType.getSort() == 9) {
            v.load(index2, asmType);
            v.visitLdcInsn((Object)name2);
            String checkMethod = "checkParameterIsNotNull";
            v.invokestatic("kotlin/jvm/internal/Intrinsics", checkMethod, "(Ljava/lang/Object;Ljava/lang/String;)V", false);
        }
    }

    @NotNull
    public static StackValue genNotNullAssertions(@NotNull GenerationState state, final @NotNull StackValue stackValue, final @Nullable RuntimeAssertionInfo runtimeAssertionInfo) {
        if (state.isCallAssertionsDisabled()) {
            return stackValue;
        }
        if (runtimeAssertionInfo == null || !runtimeAssertionInfo.getNeedNotNullAssertion()) {
            return stackValue;
        }
        return new StackValue(stackValue.type){

            @Override
            public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
                Type innerType = stackValue.type;
                stackValue.put(innerType, v);
                if (innerType.getSort() == 10 || innerType.getSort() == 9) {
                    v.dup();
                    v.visitLdcInsn((Object)runtimeAssertionInfo.getMessage());
                    v.invokestatic("kotlin/jvm/internal/Intrinsics", "checkExpressionValueIsNotNull", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
                }
                StackValue.coerce(innerType, type2, v);
            }
        };
    }

    public static void pushDefaultValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            v.aconst(null);
        } else {
            AsmUtil.pushDefaultPrimitiveValueOnStack(type2, v);
        }
    }

    public static void pushDefaultPrimitiveValueOnStack(@NotNull Type type2, @NotNull InstructionAdapter v) {
        if (type2.getSort() == 6) {
            v.fconst(0.0f);
        } else if (type2.getSort() == 8) {
            v.dconst(0.0);
        } else if (type2.getSort() == 7) {
            v.lconst(0L);
        } else {
            v.iconst(0);
        }
    }

    public static boolean isInstancePropertyWithStaticBackingField(@NotNull PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE && DescriptorUtils.isObject(propertyDescriptor.getContainingDeclaration());
    }

    public static int getVisibilityForBackingField(@NotNull PropertyDescriptor propertyDescriptor, boolean isDelegate) {
        boolean isExtensionProperty;
        boolean bl = isExtensionProperty = propertyDescriptor.getExtensionReceiverParameter() != null;
        if (isDelegate || isExtensionProperty) {
            return 2;
        }
        return propertyDescriptor.isLateInit() || JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor) ? AsmUtil.getVisibilityAccessFlag(AsmUtil.descriptorForVisibility(propertyDescriptor)) : 2;
    }

    private static MemberDescriptor descriptorForVisibility(@NotNull PropertyDescriptor propertyDescriptor) {
        if (!propertyDescriptor.isVar()) {
            return propertyDescriptor;
        }
        return propertyDescriptor.getSetter() != null ? propertyDescriptor.getSetter() : propertyDescriptor;
    }

    public static boolean isPropertyWithBackingFieldCopyInOuterClass(@NotNull PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor propertyContainer = propertyDescriptor.getContainingDeclaration();
        return propertyDescriptor.isConst() && DescriptorUtils.isCompanionObject(propertyContainer) && JvmCodegenUtil.isJvmInterface(propertyContainer.getContainingDeclaration()) && AsmUtil.getVisibilityForBackingField(propertyDescriptor, false) == 1;
    }

    public static Type comparisonOperandType(Type left, Type right) {
        if (left == Type.DOUBLE_TYPE || right == Type.DOUBLE_TYPE) {
            return Type.DOUBLE_TYPE;
        }
        if (left == Type.FLOAT_TYPE || right == Type.FLOAT_TYPE) {
            return Type.FLOAT_TYPE;
        }
        if (left == Type.LONG_TYPE || right == Type.LONG_TYPE) {
            return Type.LONG_TYPE;
        }
        if (left == Type.CHAR_TYPE || right == Type.CHAR_TYPE) {
            return Type.CHAR_TYPE;
        }
        return Type.INT_TYPE;
    }

    @NotNull
    public static Type numberFunctionOperandType(@NotNull Type expectedType) {
        if (expectedType == Type.SHORT_TYPE || expectedType == Type.BYTE_TYPE || expectedType == Type.CHAR_TYPE) {
            return Type.INT_TYPE;
        }
        return expectedType;
    }

    public static void pop(@NotNull MethodVisitor v, @NotNull Type type2) {
        if (type2.getSize() == 2) {
            v.visitInsn(88);
        } else {
            v.visitInsn(87);
        }
    }

    public static void pop2(@NotNull MethodVisitor v, @NotNull Type type2) {
        if (type2.getSize() == 2) {
            v.visitInsn(88);
            v.visitInsn(88);
        } else {
            v.visitInsn(88);
        }
    }

    public static void dup(@NotNull InstructionAdapter v, @NotNull Type type2) {
        AsmUtil.dup(v, type2.getSize());
    }

    private static void dup(@NotNull InstructionAdapter v, int size) {
        if (size == 2) {
            v.dup2();
        } else if (size == 1) {
            v.dup();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void dupx(@NotNull InstructionAdapter v, @NotNull Type type2) {
        AsmUtil.dupx(v, type2.getSize());
    }

    private static void dupx(@NotNull InstructionAdapter v, int size) {
        if (size == 2) {
            v.dup2X2();
        } else if (size == 1) {
            v.dupX1();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void dup(@NotNull InstructionAdapter v, @NotNull Type topOfStack, @NotNull Type afterTop) {
        if (topOfStack.getSize() == 0 && afterTop.getSize() == 0) {
            return;
        }
        if (topOfStack.getSize() == 0) {
            AsmUtil.dup(v, afterTop);
        } else if (afterTop.getSize() == 0) {
            AsmUtil.dup(v, topOfStack);
        } else if (afterTop.getSize() == 1) {
            if (topOfStack.getSize() == 1) {
                AsmUtil.dup(v, 2);
            } else {
                v.dup2X1();
                v.pop2();
                v.dupX2();
                v.dupX2();
                v.pop();
                v.dup2X1();
            }
        } else {
            throw new UnsupportedOperationException("Don't know how generate dup3/dup4 for: " + topOfStack + " and " + afterTop);
        }
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull DescriptorSerializer serializer, @NotNull MessageLite message2) {
        AsmUtil.writeAnnotationData(av, message2, (JvmStringTable)((Object)serializer.getStringTable()));
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull MessageLite message2, @NotNull JvmStringTable stringTable) {
        AsmUtil.writeAnnotationData(av, JvmProtoBufUtil.writeData(message2, stringTable), ArrayUtil.toStringArray(stringTable.getStrings()));
    }

    public static void writeAnnotationData(@NotNull AnnotationVisitor av, @NotNull String[] data, @NotNull String[] strings) {
        AnnotationVisitor dataVisitor = av.visitArray("d1");
        for (String string : data) {
            dataVisitor.visit(null, (Object)string);
        }
        dataVisitor.visitEnd();
        AnnotationVisitor stringsVisitor = av.visitArray("d2");
        for (String string : strings) {
            stringsVisitor.visit(null, (Object)string);
        }
        stringsVisitor.visitEnd();
    }

    @NotNull
    public static Type asmTypeByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        return Type.getObjectType((String)AsmUtil.internalNameByFqNameWithoutInnerClasses(fqName2));
    }

    @NotNull
    public static Type asmTypeByClassId(@NotNull ClassId classId) {
        return Type.getObjectType((String)classId.asString().replace('.', '$'));
    }

    @NotNull
    public static String internalNameByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        return JvmClassName.byFqNameWithoutInnerClasses(fqName2).getInternalName();
    }

    public static void putJavaLangClassInstance(@NotNull InstructionAdapter v, @NotNull Type type2) {
        if (AsmUtil.isPrimitive(type2)) {
            v.getstatic(AsmUtil.boxType(type2).getInternalName(), "TYPE", "Ljava/lang/Class;");
        } else {
            v.aconst((Object)type2);
        }
    }

    public static void wrapJavaClassIntoKClass(@NotNull InstructionAdapter v) {
        v.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClass", Type.getMethodDescriptor((Type)AsmTypes.K_CLASS_TYPE, (Type[])new Type[]{AsmTypes.getType(Class.class)}), false);
    }

    public static void wrapJavaClassesIntoKClasses(@NotNull InstructionAdapter v) {
        v.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinClasses", Type.getMethodDescriptor((Type)AsmTypes.K_CLASS_ARRAY_TYPE, (Type[])new Type[]{AsmTypes.getType(Class[].class)}), false);
    }

    public static int getReceiverIndex(@NotNull CodegenContext context2, @NotNull CallableMemberDescriptor descriptor2) {
        OwnerKind kind = context2.getContextKind();
        return kind != OwnerKind.DEFAULT_IMPLS && AsmUtil.isStaticMethod(kind, descriptor2) ? 0 : 1;
    }

    static {
        ImmutableMap.Builder typeBySortBuilder = ImmutableMap.builder();
        ImmutableMap.Builder typeByWrapperBuilder = ImmutableMap.builder();
        for (JvmPrimitiveType primitiveType : JvmPrimitiveType.values()) {
            Type asmType = Type.getType((String)primitiveType.getDesc());
            typeBySortBuilder.put((Object)asmType.getSort(), (Object)primitiveType);
            typeByWrapperBuilder.put((Object)AsmUtil.asmTypeByFqNameWithoutInnerClasses(primitiveType.getWrapperFqName()), (Object)asmType);
        }
        primitiveTypeByAsmSort = typeBySortBuilder.build();
        primitiveTypeByBoxedType = typeByWrapperBuilder.build();
    }
}

