/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ArgumentAndDeclIndex;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.StackValueKt;
import org.jetbrains.kotlin.codegen.ValueKind;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.org.objectweb.asm.Type;

public class CallBasedArgumentGenerator
extends ArgumentGenerator {
    private final ExpressionCodegen codegen;
    private final CallGenerator callGenerator;
    private final List<ValueParameterDescriptor> valueParameters;
    private final List<Type> valueParameterTypes;

    public CallBasedArgumentGenerator(@NotNull ExpressionCodegen codegen, @NotNull CallGenerator callGenerator, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<Type> valueParameterTypes) {
        this.codegen = codegen;
        this.callGenerator = callGenerator;
        this.valueParameters = valueParameters;
        this.valueParameterTypes = valueParameterTypes;
        assert (valueParameters.size() == valueParameterTypes.size()) : "Value parameters and their types mismatch in sizes: " + valueParameters.size() + " != " + valueParameterTypes.size();
    }

    @Override
    protected void generateExpression(int i, @NotNull ExpressionValueArgument argument2) {
        ValueParameterDescriptor parameter = this.valueParameters.get(i);
        Type type2 = this.valueParameterTypes.get(i);
        ValueArgument valueArgument = argument2.getValueArgument();
        assert (valueArgument != null);
        KtExpression argumentExpression2 = valueArgument.getArgumentExpression();
        assert (argumentExpression2 != null) : valueArgument.asElement().getText();
        this.callGenerator.genValueAndPut(parameter, argumentExpression2, type2, i);
    }

    @Override
    protected void generateDefault(int i, @NotNull DefaultValueArgument argument2) {
        this.callGenerator.putValueIfNeeded(CallBasedArgumentGenerator.getJvmKotlinType(this.valueParameterTypes, this.valueParameters, i), StackValue.createDefaultValue(this.valueParameterTypes.get(i)), ValueKind.DEFAULT_PARAMETER, i);
    }

    @Override
    protected void generateVararg(int i, @NotNull VarargValueArgument argument2) {
        ValueParameterDescriptor parameter = this.valueParameters.get(i);
        StackValue lazyVararg = this.codegen.genVarargs(argument2, FlexibleTypesKt.upperIfFlexible(parameter.getType()));
        this.callGenerator.putValueIfNeeded(CallBasedArgumentGenerator.getJvmKotlinType(this.valueParameterTypes, this.valueParameters, i), lazyVararg, ValueKind.GENERAL_VARARG, i);
    }

    @Override
    protected void generateDefaultJava(int i, @NotNull DefaultValueArgument argument2) {
        StackValue argumentValue = StackValueKt.findJavaDefaultArgumentValue(this.valueParameters.get(i), this.valueParameterTypes.get(i), this.codegen.typeMapper);
        this.callGenerator.putValueIfNeeded(CallBasedArgumentGenerator.getJvmKotlinType(this.valueParameterTypes, this.valueParameters, i), argumentValue);
    }

    @Override
    protected void reorderArgumentsIfNeeded(@NotNull List<ArgumentAndDeclIndex> actualArgsWithDeclIndex) {
        this.callGenerator.reorderArgumentsIfNeeded(actualArgsWithDeclIndex, this.valueParameterTypes);
    }

    @NotNull
    private static JvmKotlinType getJvmKotlinType(@NotNull List<Type> valueParameterTypes, @NotNull List<ValueParameterDescriptor> valueParameters, int i) {
        return new JvmKotlinType(valueParameterTypes.get(i), valueParameters.get(i).getOriginal().getType());
    }
}

