/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.annotation.AnnotatedSimple;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializerExtension;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationsImpl;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class PackagePartCodegen
extends MemberCodegen<KtFile> {
    private final Type packagePartType;

    public PackagePartCodegen(@NotNull ClassBuilder v, @NotNull KtFile file, @NotNull Type packagePartType, @NotNull FieldOwnerContext context2, @NotNull GenerationState state) {
        super(state, null, context2, file, v);
        this.packagePartType = packagePartType;
    }

    @Override
    protected void generateDeclaration() {
        this.v.defineClass((PsiElement)this.element, this.state.getClassFileVersion(), 49, this.packagePartType.getInternalName(), null, "java/lang/Object", ArrayUtil.EMPTY_STRING_ARRAY);
        this.v.visitSource(((KtFile)this.element).getName(), null);
        this.generatePropertyMetadataArrayFieldIfNeeded(this.packagePartType);
        this.generateAnnotationsForPartClass();
    }

    private void generateAnnotationsForPartClass() {
        ArrayList<AnnotationDescriptor> fileAnnotationDescriptors = new ArrayList<AnnotationDescriptor>();
        for (KtAnnotationEntry annotationEntry2 : ((KtFile)this.element).getAnnotationEntries()) {
            AnnotationDescriptor annotationDescriptor = this.state.getBindingContext().get(BindingContext.ANNOTATION, annotationEntry2);
            if (annotationDescriptor == null) continue;
            fileAnnotationDescriptors.add(annotationDescriptor);
        }
        AnnotatedSimple annotatedFile = new AnnotatedSimple(new AnnotationsImpl(fileAnnotationDescriptors));
        AnnotationCodegen.forClass(this.v.getVisitor(), this, this.state.getTypeMapper()).genAnnotations(annotatedFile, null);
    }

    @Override
    protected void generateBody() {
        for (KtDeclaration declaration2 : CodegenUtil.getDeclarationsToGenerate((KtFile)this.element, this.state.getBindingContext())) {
            if (!(declaration2 instanceof KtNamedFunction) && !(declaration2 instanceof KtProperty) && !(declaration2 instanceof KtTypeAlias)) continue;
            this.genSimpleMember(declaration2);
        }
        if (this.state.getClassBuilderMode().generateBodies) {
            this.generateInitializers((Function0<ExpressionCodegen>)((Function0)this::createOrGetClInitCodegen));
        }
    }

    @Override
    protected void generateKotlinMetadataAnnotation() {
        Pair<DescriptorSerializer, ProtoBuf.Package> serializedPart = PackagePartCodegen.serializePackagePartMembers(this, this.packagePartType);
        WriteAnnotationUtilKt.writeKotlinMetadata(this.v, this.state, KotlinClassHeader.Kind.FILE_FACADE, 0, (Function1<? super AnnotationVisitor, Unit>)((Function1)av -> {
            AsmUtil.writeAnnotationData(av, (DescriptorSerializer)serializedPart.getFirst(), (MessageLite)serializedPart.getSecond());
            FqName kotlinPackageFqName = ((KtFile)this.element).getPackageFqName();
            if (!kotlinPackageFqName.equals(JvmClassName.byInternalName(this.packagePartType.getInternalName()).getPackageFqName())) {
                av.visit("pn", (Object)kotlinPackageFqName.asString());
            }
            return Unit.INSTANCE;
        }));
    }

    @NotNull
    protected static Pair<DescriptorSerializer, ProtoBuf.Package> serializePackagePartMembers(@NotNull MemberCodegen<? extends KtFile> codegen, @NotNull Type packagePartType) {
        BindingContext bindingContext2 = codegen.bindingContext;
        List<KtDeclaration> allDeclarations = CodegenUtil.getDeclarationsToGenerate((KtFile)codegen.element, bindingContext2);
        List members = CollectionsKt.mapNotNull(allDeclarations, declaration2 -> {
            if (declaration2 instanceof KtNamedFunction) {
                return bindingContext2.get(BindingContext.FUNCTION, declaration2);
            }
            if (declaration2 instanceof KtProperty) {
                return bindingContext2.get(BindingContext.VARIABLE, declaration2);
            }
            if (declaration2 instanceof KtTypeAlias) {
                return bindingContext2.get(BindingContext.TYPE_ALIAS, declaration2);
            }
            return null;
        });
        JvmSerializerExtension extension = new JvmSerializerExtension(codegen.v.getSerializationBindings(), codegen.state);
        DescriptorSerializer serializer = DescriptorSerializer.createTopLevel(extension);
        ProtoBuf.Package.Builder builder = serializer.packagePartProto(((KtFile)codegen.element).getPackageFqName(), members);
        extension.serializeJvmPackage(builder, packagePartType);
        return new Pair((Object)serializer, (Object)builder.build());
    }

    @Override
    protected void generateSyntheticPartsAfterBody() {
        this.generateSyntheticAccessors();
    }
}

