/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.fixStack.AnalyzeTryCatchBlocksKt;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010)\u001a\u00020\fJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0014H\u0002J\u0006\u0010-\u001a\u00020\fJ\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0014H\u0002J\u0010\u00101\u001a\u00020/2\u0006\u00100\u001a\u00020\u0014H\u0002J\u0010\u00102\u001a\u00020/2\u0006\u00100\u001a\u00020\u0014H\u0002R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR-\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u001ej\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014`\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R9\u0010\"\u001a*\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140#0\u001ej\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140#`\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010!R\u001d\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "breakContinueGotoNodes", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "Lkotlin/collections/LinkedHashSet;", "getBreakContinueGotoNodes", "()Ljava/util/LinkedHashSet;", "<set-?>", "", "consistentInlineMarkers", "getConsistentInlineMarkers", "()Z", "setConsistentInlineMarkers", "(Z)V", "fakeAlwaysFalseIfeqMarkers", "Ljava/util/ArrayList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/ArrayList;", "getFakeAlwaysFalseIfeqMarkers", "()Ljava/util/ArrayList;", "fakeAlwaysTrueIfeqMarkers", "getFakeAlwaysTrueIfeqMarkers", "isThereAnyTryCatch", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "openingInlineMethodMarker", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getOpeningInlineMethodMarker", "()Ljava/util/HashMap;", "restoreStackMarkersForSaveMarker", "", "getRestoreStackMarkersForSaveMarker", "saveStackMarkerForRestoreMarker", "", "getSaveStackMarkerForRestoreMarker", "()Ljava/util/Map;", "hasAnyMarkers", "indexOf", "", "node", "isAnalysisRequired", "visitFakeAlwaysFalseIfeq", "", "insnNode", "visitFakeAlwaysTrueIfeq", "visitFixStackBeforeJump", "backend"})
public final class FixStackContext {
    @NotNull
    private final LinkedHashSet<JumpInsnNode> breakContinueGotoNodes;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysTrueIfeqMarkers;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysFalseIfeqMarkers;
    private final boolean isThereAnyTryCatch;
    @NotNull
    private final Map<AbstractInsnNode, AbstractInsnNode> saveStackMarkerForRestoreMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, List<AbstractInsnNode>> restoreStackMarkersForSaveMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, AbstractInsnNode> openingInlineMethodMarker;
    private boolean consistentInlineMarkers;
    @NotNull
    private final MethodNode methodNode;

    @NotNull
    public final LinkedHashSet<JumpInsnNode> getBreakContinueGotoNodes() {
        return this.breakContinueGotoNodes;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysTrueIfeqMarkers() {
        return this.fakeAlwaysTrueIfeqMarkers;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysFalseIfeqMarkers() {
        return this.fakeAlwaysFalseIfeqMarkers;
    }

    public final boolean isThereAnyTryCatch() {
        return this.isThereAnyTryCatch;
    }

    @NotNull
    public final Map<AbstractInsnNode, AbstractInsnNode> getSaveStackMarkerForRestoreMarker() {
        return this.saveStackMarkerForRestoreMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, List<AbstractInsnNode>> getRestoreStackMarkersForSaveMarker() {
        return this.restoreStackMarkersForSaveMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, AbstractInsnNode> getOpeningInlineMethodMarker() {
        return this.openingInlineMethodMarker;
    }

    public final boolean getConsistentInlineMarkers() {
        return this.consistentInlineMarkers;
    }

    private final void setConsistentInlineMarkers(boolean bl) {
        this.consistentInlineMarkers = bl;
    }

    private final void visitFixStackBeforeJump(AbstractInsnNode insnNode) {
        boolean bl;
        AbstractInsnNode next2;
        AbstractInsnNode abstractInsnNode = next2 = insnNode.getNext();
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"next");
        boolean bl2 = bl = abstractInsnNode.getOpcode() == 167;
        if (_Assertions.ENABLED && !bl) {
            String string = this.indexOf(insnNode) + ": should be followed by GOTO";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.breakContinueGotoNodes.add((JumpInsnNode)next2);
    }

    private final void visitFakeAlwaysTrueIfeq(AbstractInsnNode insnNode) {
        boolean bl;
        AbstractInsnNode abstractInsnNode = insnNode.getNext();
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"insnNode.next");
        boolean bl2 = bl = abstractInsnNode.getOpcode() == 153;
        if (_Assertions.ENABLED && !bl) {
            String string = this.indexOf(insnNode) + ": should be followed by IFEQ";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.fakeAlwaysTrueIfeqMarkers.add(insnNode);
    }

    private final void visitFakeAlwaysFalseIfeq(AbstractInsnNode insnNode) {
        boolean bl;
        AbstractInsnNode abstractInsnNode = insnNode.getNext();
        Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"insnNode.next");
        boolean bl2 = bl = abstractInsnNode.getOpcode() == 153;
        if (_Assertions.ENABLED && !bl) {
            String string = this.indexOf(insnNode) + ": should be followed by IFEQ";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.fakeAlwaysFalseIfeqMarkers.add(insnNode);
    }

    private final int indexOf(AbstractInsnNode node) {
        return this.methodNode.instructions.indexOf(node);
    }

    public final boolean hasAnyMarkers() {
        Object object = this.breakContinueGotoNodes;
        return !object.isEmpty() || !(object = (Collection)this.fakeAlwaysTrueIfeqMarkers).isEmpty() || !(object = (Collection)this.fakeAlwaysFalseIfeqMarkers).isEmpty() || this.isThereAnyTryCatch || !(object = (Map)this.openingInlineMethodMarker).isEmpty();
    }

    public final boolean isAnalysisRequired() {
        Object object = this.breakContinueGotoNodes;
        return !object.isEmpty() || this.isThereAnyTryCatch || !(object = (Map)this.openingInlineMethodMarker).isEmpty();
    }

    @NotNull
    public final MethodNode getMethodNode() {
        return this.methodNode;
    }

    public FixStackContext(@NotNull MethodNode methodNode) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        this.methodNode = methodNode;
        FixStackContext fixStackContext = this;
        Cloneable cloneable2 = new LinkedHashSet();
        fixStackContext.breakContinueGotoNodes = cloneable2;
        fixStackContext = this;
        cloneable2 = new ArrayList();
        fixStackContext.fakeAlwaysTrueIfeqMarkers = cloneable2;
        fixStackContext = this;
        cloneable2 = new ArrayList();
        fixStackContext.fakeAlwaysFalseIfeqMarkers = cloneable2;
        this.saveStackMarkerForRestoreMarker = AnalyzeTryCatchBlocksKt.insertTryCatchBlocksMarkers(this.methodNode);
        fixStackContext = this;
        cloneable2 = new HashMap();
        fixStackContext.restoreStackMarkersForSaveMarker = cloneable2;
        fixStackContext = this;
        cloneable2 = new HashMap();
        fixStackContext.openingInlineMethodMarker = cloneable2;
        this.consistentInlineMarkers = true;
        Object object = this.saveStackMarkerForRestoreMarker;
        fixStackContext = this;
        fixStackContext.isThereAnyTryCatch = bl = !object.isEmpty();
        Map<AbstractInsnNode, AbstractInsnNode> map2 = this.saveStackMarkerForRestoreMarker;
        Object object2 = map2.entrySet().iterator();
        while (object2.hasNext()) {
            Object object3;
            Object object4 = object = object2.next();
            AbstractInsnNode restore2 = (AbstractInsnNode)object4.getKey();
            Map $receiver$iv = this.restoreStackMarkersForSaveMarker;
            object4 = object;
            AbstractInsnNode save2 = (AbstractInsnNode)object4.getValue();
            Object value$iv = $receiver$iv.get(save2);
            if (value$iv == null) {
                List answer$iv = (List)new SmartList();
                $receiver$iv.put(save2, answer$iv);
                object3 = answer$iv;
            } else {
                object3 = value$iv;
            }
            ((List)object3).add(restore2);
        }
        Stack inlineMarkersStack = new Stack();
        InsnList insnList = this.methodNode.instructions;
        Intrinsics.checkExpressionValueIsNotNull((Object)insnList, (String)"methodNode.instructions");
        Sequence $receiver$iv = new InsnSequence(insnList);
        for (Object element$iv : $receiver$iv) {
            Object object5;
            boolean bl2;
            AbstractInsnNode insnNode = (AbstractInsnNode)element$iv;
            PseudoInsn pseudoInsn = PseudoInsnsKt.parsePseudoInsnOrNull(insnNode);
            if (pseudoInsn == PseudoInsn.FIX_STACK_BEFORE_JUMP) {
                this.visitFixStackBeforeJump(insnNode);
                continue;
            }
            if (pseudoInsn == PseudoInsn.FAKE_ALWAYS_TRUE_IFEQ) {
                this.visitFakeAlwaysTrueIfeq(insnNode);
                continue;
            }
            if (pseudoInsn == PseudoInsn.FAKE_ALWAYS_FALSE_IFEQ) {
                this.visitFakeAlwaysFalseIfeq(insnNode);
                continue;
            }
            if (InlineCodegenUtilsKt.isBeforeInlineMarker(insnNode)) {
                inlineMarkersStack.push((Object)insnNode);
                continue;
            }
            if (!InlineCodegenUtilsKt.isAfterInlineMarker(insnNode)) continue;
            Object object6 = (Collection)inlineMarkersStack;
            boolean bl3 = bl2 = !object6.isEmpty();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Mismatching after inline method marker at " + this.indexOf(insnNode);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            object6 = this.openingInlineMethodMarker;
            Intrinsics.checkExpressionValueIsNotNull((Object)inlineMarkersStack.pop(), (String)"inlineMarkersStack.pop()");
            object6.put(insnNode, object5);
        }
        object2 = (Collection)inlineMarkersStack;
        if (!object2.isEmpty()) {
            this.consistentInlineMarkers = false;
        }
    }
}

