/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.ContextInfoToDataFlowInfoKt;
import org.jetbrains.kotlin.contracts.ESLambda;
import org.jetbrains.kotlin.contracts.EffectsExtractingVisitor;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.MutableContextInfo;
import org.jetbrains.kotlin.contracts.model.functors.EqualsFunctor;
import org.jetbrains.kotlin.contracts.model.structure.ESCalls;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;
import org.jetbrains.kotlin.contracts.model.structure.UNKNOWN_COMPUTATION;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;
import org.jetbrains.kotlin.contracts.model.visitors.InfoCollector;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ConditionalDataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u001a\u001a\u00020\f2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\b\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010$\u001a\u00020%2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/contracts/EffectSystem;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "getDataFlowValueFactory", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "extractDataFlowInfoFromCondition", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "condition", "Lorg/jetbrains/kotlin/psi/KtExpression;", "value", "", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getContextInfoWhen", "Lorg/jetbrains/kotlin/contracts/model/MutableContextInfo;", "observedEffect", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "expression", "getDataFlowInfoForFinishedCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getDataFlowInfoWhenEquals", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/ConditionalDataFlowInfo;", "leftExpression", "rightExpression", "getNonTrivialComputation", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "trace", "recordDefiniteInvocations", "", "frontend"})
public final class EffectSystem {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;

    @NotNull
    public final DataFlowInfo getDataFlowInfoForFinishedCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BindingTrace bindingTrace, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.UseReturnsEffect)) {
            return DataFlowInfo.Companion.getEMPTY();
        }
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        KtElement ktElement = call2.getCallElement();
        if (!(ktElement instanceof KtCallExpression)) {
            ktElement = null;
        }
        KtCallExpression ktCallExpression = (KtCallExpression)ktElement;
        if (ktCallExpression == null) {
            return DataFlowInfo.Companion.getEMPTY();
        }
        KtCallExpression callExpression2 = ktCallExpression;
        if (callExpression2 instanceof KtDeclaration) {
            return DataFlowInfo.Companion.getEMPTY();
        }
        MutableContextInfo resultContextInfo = this.getContextInfoWhen(new ESReturns(ESConstant.Companion.getWILDCARD()), callExpression2, bindingTrace, moduleDescriptor);
        return ContextInfoToDataFlowInfoKt.toDataFlowInfo(resultContextInfo, this.languageVersionSettings);
    }

    @NotNull
    public final ConditionalDataFlowInfo getDataFlowInfoWhenEquals(@Nullable KtExpression leftExpression, @Nullable KtExpression rightExpression, @NotNull BindingTrace bindingTrace, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.UseReturnsEffect)) {
            return ConditionalDataFlowInfo.Companion.getEMPTY();
        }
        if (leftExpression == null || rightExpression == null) {
            return ConditionalDataFlowInfo.Companion.getEMPTY();
        }
        Computation computation = this.getNonTrivialComputation(leftExpression, bindingTrace, moduleDescriptor);
        if (computation == null) {
            return ConditionalDataFlowInfo.Companion.getEMPTY();
        }
        Computation leftComputation = computation;
        Computation computation2 = this.getNonTrivialComputation(rightExpression, bindingTrace, moduleDescriptor);
        if (computation2 == null) {
            return ConditionalDataFlowInfo.Companion.getEMPTY();
        }
        Computation rightComputation = computation2;
        List<ESEffect> effects = new EqualsFunctor(false).invokeWithArguments(leftComputation, rightComputation);
        MutableContextInfo equalsContextInfo = new InfoCollector(new ESReturns(ValuesKt.lift(true))).collectFromSchema(effects);
        MutableContextInfo notEqualsContextInfo = new InfoCollector(new ESReturns(ValuesKt.lift(false))).collectFromSchema(effects);
        return new ConditionalDataFlowInfo(ContextInfoToDataFlowInfoKt.toDataFlowInfo(equalsContextInfo, this.languageVersionSettings), ContextInfoToDataFlowInfoKt.toDataFlowInfo(notEqualsContextInfo, this.languageVersionSettings));
    }

    public final void recordDefiniteInvocations(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BindingTrace bindingTrace, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.UseCallsInPlaceEffect)) {
            return;
        }
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        KtElement ktElement = call2.getCallElement();
        if (!(ktElement instanceof KtCallExpression)) {
            ktElement = null;
        }
        KtCallExpression ktCallExpression = (KtCallExpression)ktElement;
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        if (callExpression2 instanceof KtDeclaration) {
            return;
        }
        MutableContextInfo resultingContextInfo = this.getContextInfoWhen(new ESReturns(ESConstant.Companion.getWILDCARD()), callExpression2, bindingTrace, moduleDescriptor);
        for (ESEffect effect : resultingContextInfo.getFiredEffects()) {
            Object object;
            ESCalls callsEffect;
            ESEffect eSEffect = effect;
            if (!(eSEffect instanceof ESCalls)) {
                eSEffect = null;
            }
            if ((ESCalls)eSEffect == null) {
                continue;
            }
            ESValue eSValue = callsEffect.getCallable();
            if (!(eSValue instanceof ESLambda)) {
                eSValue = null;
            }
            if ((object = (ESLambda)eSValue) == null || (object = ((ESLambda)object).getLambda()) == null) {
                continue;
            }
            Object lambdaExpression2 = object;
            bindingTrace.record(BindingContext.LAMBDA_INVOCATIONS, lambdaExpression2, callsEffect.getKind());
        }
    }

    @NotNull
    public final DataFlowInfo extractDataFlowInfoFromCondition(@Nullable KtExpression condition2, boolean value, @NotNull BindingTrace bindingTrace, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.UseReturnsEffect)) {
            return DataFlowInfo.Companion.getEMPTY();
        }
        if (condition2 == null) {
            return DataFlowInfo.Companion.getEMPTY();
        }
        return ContextInfoToDataFlowInfoKt.toDataFlowInfo(this.getContextInfoWhen(new ESReturns(ValuesKt.lift(value)), condition2, bindingTrace, moduleDescriptor), this.languageVersionSettings);
    }

    private final MutableContextInfo getContextInfoWhen(ESEffect observedEffect, KtExpression expression2, BindingTrace bindingTrace, ModuleDescriptor moduleDescriptor) {
        Computation computation = this.getNonTrivialComputation(expression2, bindingTrace, moduleDescriptor);
        if (computation == null) {
            return MutableContextInfo.Companion.getEMPTY();
        }
        Computation computation2 = computation;
        return new InfoCollector(observedEffect).collectFromSchema(computation2.getEffects());
    }

    private final Computation getNonTrivialComputation(KtExpression expression2, BindingTrace trace, ModuleDescriptor moduleDescriptor) {
        Computation computation = new EffectsExtractingVisitor(trace, moduleDescriptor, this.dataFlowValueFactory).extractOrGetCached(expression2);
        return Intrinsics.areEqual((Object)computation, (Object)UNKNOWN_COMPUTATION.INSTANCE) ? null : computation;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final DataFlowValueFactory getDataFlowValueFactory() {
        return this.dataFlowValueFactory;
    }

    public EffectSystem(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }
}

