/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationsKt;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.types.DescriptorSubstitutor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.SmartList;

public abstract class FunctionDescriptorImpl
extends DeclarationDescriptorNonRootImpl
implements FunctionDescriptor {
    private List<TypeParameterDescriptor> typeParameters;
    private List<ValueParameterDescriptor> unsubstitutedValueParameters;
    private KotlinType unsubstitutedReturnType;
    private ReceiverParameterDescriptor extensionReceiverParameter;
    private ReceiverParameterDescriptor dispatchReceiverParameter;
    private Modality modality;
    private Visibility visibility = Visibilities.UNKNOWN;
    private boolean isOperator = false;
    private boolean isInfix = false;
    private boolean isExternal = false;
    private boolean isInline = false;
    private boolean isTailrec = false;
    private boolean isExpect = false;
    private boolean isActual = false;
    private boolean isHiddenToOvercomeSignatureClash = false;
    private boolean isHiddenForResolutionEverywhereBesideSupercalls = false;
    private boolean isSuspend = false;
    private boolean hasStableParameterNames = true;
    private boolean hasSynthesizedParameterNames = false;
    private Collection<? extends FunctionDescriptor> overriddenFunctions = null;
    private volatile Function0<Collection<FunctionDescriptor>> lazyOverriddenFunctionsTask = null;
    private final FunctionDescriptor original;
    private final CallableMemberDescriptor.Kind kind;
    @Nullable
    private FunctionDescriptor initialSignatureDescriptor = null;
    protected Map<FunctionDescriptor.UserDataKey<?>, Object> userDataMap = null;

    protected FunctionDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration2, @Nullable FunctionDescriptor original, @NotNull Annotations annotations2, @NotNull Name name2, @NotNull CallableMemberDescriptor.Kind kind, @NotNull SourceElement source) {
        super(containingDeclaration2, annotations2, name2, source);
        this.original = original == null ? this : original;
        this.kind = kind;
    }

    @NotNull
    public FunctionDescriptorImpl initialize(@Nullable KotlinType receiverParameterType, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> unsubstitutedValueParameters, @Nullable KotlinType unsubstitutedReturnType, @Nullable Modality modality, @NotNull Visibility visibility) {
        int i;
        this.typeParameters = CollectionsKt.toList(typeParameters);
        this.unsubstitutedValueParameters = CollectionsKt.toList(unsubstitutedValueParameters);
        this.unsubstitutedReturnType = unsubstitutedReturnType;
        this.modality = modality;
        this.visibility = visibility;
        this.extensionReceiverParameter = DescriptorFactory.createExtensionReceiverParameterForCallable(this, receiverParameterType);
        this.dispatchReceiverParameter = dispatchReceiverParameter;
        for (i = 0; i < typeParameters.size(); ++i) {
            TypeParameterDescriptor typeParameterDescriptor = typeParameters.get(i);
            if (typeParameterDescriptor.getIndex() == i) continue;
            throw new IllegalStateException(typeParameterDescriptor + " index is " + typeParameterDescriptor.getIndex() + " but position is " + i);
        }
        for (i = 0; i < unsubstitutedValueParameters.size(); ++i) {
            int firstValueParameterOffset = 0;
            ValueParameterDescriptor valueParameterDescriptor = unsubstitutedValueParameters.get(i);
            if (valueParameterDescriptor.getIndex() == i + firstValueParameterOffset) continue;
            throw new IllegalStateException(valueParameterDescriptor + "index is " + valueParameterDescriptor.getIndex() + " but position is " + i);
        }
        return this;
    }

    public void setVisibility(@NotNull Visibility visibility) {
        this.visibility = visibility;
    }

    public void setOperator(boolean isOperator) {
        this.isOperator = isOperator;
    }

    public void setInfix(boolean isInfix) {
        this.isInfix = isInfix;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    public void setInline(boolean isInline) {
        this.isInline = isInline;
    }

    public void setTailrec(boolean isTailrec) {
        this.isTailrec = isTailrec;
    }

    public void setExpect(boolean isExpect) {
        this.isExpect = isExpect;
    }

    public void setActual(boolean isActual) {
        this.isActual = isActual;
    }

    private void setHiddenToOvercomeSignatureClash(boolean hiddenToOvercomeSignatureClash) {
        this.isHiddenToOvercomeSignatureClash = hiddenToOvercomeSignatureClash;
    }

    private void setHiddenForResolutionEverywhereBesideSupercalls(boolean hiddenForResolutionEverywhereBesideSupercalls) {
        this.isHiddenForResolutionEverywhereBesideSupercalls = hiddenForResolutionEverywhereBesideSupercalls;
    }

    public void setSuspend(boolean suspend) {
        this.isSuspend = suspend;
    }

    public void setReturnType(@NotNull KotlinType unsubstitutedReturnType) {
        if (this.unsubstitutedReturnType != null) {
            // empty if block
        }
        this.unsubstitutedReturnType = unsubstitutedReturnType;
    }

    public void setHasStableParameterNames(boolean hasStableParameterNames) {
        this.hasStableParameterNames = hasStableParameterNames;
    }

    public void setHasSynthesizedParameterNames(boolean hasSynthesizedParameterNames) {
        this.hasSynthesizedParameterNames = hasSynthesizedParameterNames;
    }

    public void setExtensionReceiverParameter(@NotNull ReceiverParameterDescriptor extensionReceiverParameter) {
        this.extensionReceiverParameter = extensionReceiverParameter;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getExtensionReceiverParameter() {
        return this.extensionReceiverParameter;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getDispatchReceiverParameter() {
        return this.dispatchReceiverParameter;
    }

    @Override
    @NotNull
    public Collection<? extends FunctionDescriptor> getOverriddenDescriptors() {
        this.performOverriddenLazyCalculationIfNeeded();
        return this.overriddenFunctions != null ? this.overriddenFunctions : Collections.emptyList();
    }

    private void performOverriddenLazyCalculationIfNeeded() {
        Function0<Collection<FunctionDescriptor>> overriddenTask = this.lazyOverriddenFunctionsTask;
        if (overriddenTask != null) {
            this.overriddenFunctions = (Collection)overriddenTask.invoke();
            this.lazyOverriddenFunctionsTask = null;
        }
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public boolean isOperator() {
        if (this.isOperator) {
            return true;
        }
        for (FunctionDescriptor functionDescriptor2 : this.getOriginal().getOverriddenDescriptors()) {
            if (!functionDescriptor2.isOperator()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInfix() {
        if (this.isInfix) {
            return true;
        }
        for (FunctionDescriptor functionDescriptor2 : this.getOriginal().getOverriddenDescriptors()) {
            if (!functionDescriptor2.isInfix()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    public boolean isInline() {
        return this.isInline;
    }

    @Override
    public boolean isTailrec() {
        return this.isTailrec;
    }

    @Override
    public boolean isSuspend() {
        return this.isSuspend;
    }

    @Override
    public boolean isExpect() {
        return this.isExpect;
    }

    @Override
    public boolean isActual() {
        return this.isActual;
    }

    @Override
    public <V> V getUserData(FunctionDescriptor.UserDataKey<V> key) {
        if (this.userDataMap == null) {
            return null;
        }
        return (V)this.userDataMap.get(key);
    }

    @Override
    public boolean isHiddenToOvercomeSignatureClash() {
        return this.isHiddenToOvercomeSignatureClash;
    }

    @Override
    public void setOverriddenDescriptors(@NotNull Collection<? extends CallableMemberDescriptor> overriddenDescriptors) {
        this.overriddenFunctions = overriddenDescriptors;
        for (FunctionDescriptor functionDescriptor2 : this.overriddenFunctions) {
            if (!functionDescriptor2.isHiddenForResolutionEverywhereBesideSupercalls()) continue;
            this.isHiddenForResolutionEverywhereBesideSupercalls = true;
            break;
        }
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    @NotNull
    public List<ValueParameterDescriptor> getValueParameters() {
        return this.unsubstitutedValueParameters;
    }

    @Override
    public boolean hasStableParameterNames() {
        return this.hasStableParameterNames;
    }

    @Override
    public boolean hasSynthesizedParameterNames() {
        return this.hasSynthesizedParameterNames;
    }

    @Override
    public KotlinType getReturnType() {
        return this.unsubstitutedReturnType;
    }

    @Override
    @NotNull
    public FunctionDescriptor getOriginal() {
        return this.original == this ? this : this.original.getOriginal();
    }

    @Override
    @NotNull
    public CallableMemberDescriptor.Kind getKind() {
        return this.kind;
    }

    @Override
    public FunctionDescriptor substitute(@NotNull TypeSubstitutor originalSubstitutor) {
        if (originalSubstitutor.isEmpty()) {
            return this;
        }
        return this.newCopyBuilder(originalSubstitutor).setOriginal(this.getOriginal()).setJustForTypeSubstitution(true).build();
    }

    @Nullable
    private KotlinType getExtensionReceiverParameterType() {
        if (this.extensionReceiverParameter == null) {
            return null;
        }
        return this.extensionReceiverParameter.getType();
    }

    @Override
    public boolean isHiddenForResolutionEverywhereBesideSupercalls() {
        return this.isHiddenForResolutionEverywhereBesideSupercalls;
    }

    @Override
    @NotNull
    public FunctionDescriptor.CopyBuilder<? extends FunctionDescriptor> newCopyBuilder() {
        return this.newCopyBuilder(TypeSubstitutor.EMPTY);
    }

    @NotNull
    protected CopyConfiguration newCopyBuilder(@NotNull TypeSubstitutor substitutor3) {
        return new CopyConfiguration(substitutor3.getSubstitution(), this.getContainingDeclaration(), this.getModality(), this.getVisibility(), this.getKind(), this.getValueParameters(), this.getExtensionReceiverParameterType(), this.getReturnType(), null, this.isSuspend);
    }

    @Nullable
    protected FunctionDescriptor doSubstitute(@NotNull CopyConfiguration configuration2) {
        List<ValueParameterDescriptor> substitutedValueParameters;
        boolean[] wereChanges = new boolean[1];
        Annotations resultAnnotations = configuration2.additionalAnnotations != null ? AnnotationsKt.composeAnnotations(this.getAnnotations(), configuration2.additionalAnnotations) : this.getAnnotations();
        FunctionDescriptorImpl substitutedDescriptor = this.createSubstitutedCopy(configuration2.newOwner, configuration2.original, configuration2.kind, configuration2.name, resultAnnotations, this.getSourceToUseForCopy(configuration2.preserveSourceElement, configuration2.original));
        List unsubstitutedTypeParameters = configuration2.newTypeParameters == null ? this.getTypeParameters() : configuration2.newTypeParameters;
        wereChanges[0] = wereChanges[0] | !unsubstitutedTypeParameters.isEmpty();
        ArrayList<TypeParameterDescriptor> substitutedTypeParameters = new ArrayList<TypeParameterDescriptor>(unsubstitutedTypeParameters.size());
        final TypeSubstitutor substitutor3 = DescriptorSubstitutor.substituteTypeParameters(unsubstitutedTypeParameters, configuration2.substitution, substitutedDescriptor, substitutedTypeParameters, wereChanges);
        if (substitutor3 == null) {
            return null;
        }
        KotlinType substitutedReceiverParameterType = null;
        if (configuration2.newExtensionReceiverParameterType != null) {
            substitutedReceiverParameterType = substitutor3.substitute(configuration2.newExtensionReceiverParameterType, Variance.IN_VARIANCE);
            if (substitutedReceiverParameterType == null) {
                return null;
            }
            wereChanges[0] = wereChanges[0] | substitutedReceiverParameterType != configuration2.newExtensionReceiverParameterType;
        }
        ReceiverParameterDescriptor substitutedExpectedThis = null;
        if (configuration2.dispatchReceiverParameter != null) {
            substitutedExpectedThis = configuration2.dispatchReceiverParameter.substitute(substitutor3);
            if (substitutedExpectedThis == null) {
                return null;
            }
            wereChanges[0] = wereChanges[0] | substitutedExpectedThis != configuration2.dispatchReceiverParameter;
        }
        if ((substitutedValueParameters = FunctionDescriptorImpl.getSubstitutedValueParameters(substitutedDescriptor, configuration2.newValueParameterDescriptors, substitutor3, configuration2.dropOriginalInContainingParts, configuration2.preserveSourceElement, wereChanges)) == null) {
            return null;
        }
        KotlinType substitutedReturnType = substitutor3.substitute(configuration2.newReturnType, Variance.OUT_VARIANCE);
        if (substitutedReturnType == null) {
            return null;
        }
        wereChanges[0] = wereChanges[0] | substitutedReturnType != configuration2.newReturnType;
        if (!wereChanges[0] && configuration2.justForTypeSubstitution) {
            return this;
        }
        substitutedDescriptor.initialize(substitutedReceiverParameterType, substitutedExpectedThis, substitutedTypeParameters, substitutedValueParameters, substitutedReturnType, configuration2.newModality, configuration2.newVisibility);
        substitutedDescriptor.setOperator(this.isOperator);
        substitutedDescriptor.setInfix(this.isInfix);
        substitutedDescriptor.setExternal(this.isExternal);
        substitutedDescriptor.setInline(this.isInline);
        substitutedDescriptor.setTailrec(this.isTailrec);
        substitutedDescriptor.setSuspend(configuration2.isSuspend);
        substitutedDescriptor.setExpect(this.isExpect);
        substitutedDescriptor.setActual(this.isActual);
        substitutedDescriptor.setHasStableParameterNames(this.hasStableParameterNames);
        substitutedDescriptor.setHiddenToOvercomeSignatureClash(configuration2.isHiddenToOvercomeSignatureClash);
        substitutedDescriptor.setHiddenForResolutionEverywhereBesideSupercalls(configuration2.isHiddenForResolutionEverywhereBesideSupercalls);
        substitutedDescriptor.setHasSynthesizedParameterNames(configuration2.newHasSynthesizedParameterNames != null ? configuration2.newHasSynthesizedParameterNames : this.hasSynthesizedParameterNames);
        if (!configuration2.userDataMap.isEmpty() || this.userDataMap != null) {
            Map newMap = configuration2.userDataMap;
            if (this.userDataMap != null) {
                for (Map.Entry<FunctionDescriptor.UserDataKey<?>, Object> entry : this.userDataMap.entrySet()) {
                    if (newMap.containsKey(entry.getKey())) continue;
                    newMap.put(entry.getKey(), entry.getValue());
                }
            }
            substitutedDescriptor.userDataMap = newMap.size() == 1 ? Collections.singletonMap(newMap.keySet().iterator().next(), newMap.values().iterator().next()) : newMap;
        }
        if (configuration2.signatureChange || this.getInitialSignatureDescriptor() != null) {
            FunctionDescriptor initialSignature = this.getInitialSignatureDescriptor() != null ? this.getInitialSignatureDescriptor() : this;
            FunctionDescriptor initialSignatureSubstituted = initialSignature.substitute(substitutor3);
            substitutedDescriptor.setInitialSignatureDescriptor(initialSignatureSubstituted);
        }
        if (configuration2.copyOverrides && !this.getOriginal().getOverriddenDescriptors().isEmpty()) {
            if (configuration2.substitution.isEmpty()) {
                Function0<Collection<FunctionDescriptor>> overriddenFunctionsTask = this.lazyOverriddenFunctionsTask;
                if (overriddenFunctionsTask != null) {
                    substitutedDescriptor.lazyOverriddenFunctionsTask = overriddenFunctionsTask;
                } else {
                    substitutedDescriptor.setOverriddenDescriptors(this.getOverriddenDescriptors());
                }
            } else {
                substitutedDescriptor.lazyOverriddenFunctionsTask = new Function0<Collection<FunctionDescriptor>>(){

                    public Collection<FunctionDescriptor> invoke() {
                        SmartList<FunctionDescriptor> result2 = new SmartList<FunctionDescriptor>();
                        for (FunctionDescriptor functionDescriptor2 : FunctionDescriptorImpl.this.getOverriddenDescriptors()) {
                            result2.add(functionDescriptor2.substitute(substitutor3));
                        }
                        return result2;
                    }
                };
            }
        }
        return substitutedDescriptor;
    }

    @Override
    @NotNull
    public FunctionDescriptor copy(DeclarationDescriptor newOwner, Modality modality, Visibility visibility, CallableMemberDescriptor.Kind kind, boolean copyOverrides) {
        return this.newCopyBuilder().setOwner(newOwner).setModality(modality).setVisibility(visibility).setKind(kind).setCopyOverrides(copyOverrides).build();
    }

    @NotNull
    protected abstract FunctionDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor var1, @Nullable FunctionDescriptor var2, @NotNull CallableMemberDescriptor.Kind var3, @Nullable Name var4, @NotNull Annotations var5, @NotNull SourceElement var6);

    @NotNull
    private SourceElement getSourceToUseForCopy(boolean preserveSource, @Nullable FunctionDescriptor original) {
        return preserveSource ? (original != null ? original : this.getOriginal()).getSource() : SourceElement.NO_SOURCE;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data) {
        return visitor2.visitFunctionDescriptor(this, data);
    }

    @Nullable
    public static List<ValueParameterDescriptor> getSubstitutedValueParameters(FunctionDescriptor substitutedDescriptor, @NotNull List<ValueParameterDescriptor> unsubstitutedValueParameters, @NotNull TypeSubstitutor substitutor3) {
        return FunctionDescriptorImpl.getSubstitutedValueParameters(substitutedDescriptor, unsubstitutedValueParameters, substitutor3, false, false, null);
    }

    @Nullable
    public static List<ValueParameterDescriptor> getSubstitutedValueParameters(FunctionDescriptor substitutedDescriptor, @NotNull List<ValueParameterDescriptor> unsubstitutedValueParameters, @NotNull TypeSubstitutor substitutor3, boolean dropOriginal, boolean preserveSourceElement, @Nullable boolean[] wereChanges) {
        ArrayList<ValueParameterDescriptor> result2 = new ArrayList<ValueParameterDescriptor>(unsubstitutedValueParameters.size());
        for (ValueParameterDescriptor unsubstitutedValueParameter : unsubstitutedValueParameters) {
            KotlinType substituteVarargElementType;
            KotlinType substitutedType = substitutor3.substitute(unsubstitutedValueParameter.getType(), Variance.IN_VARIANCE);
            KotlinType varargElementType = unsubstitutedValueParameter.getVarargElementType();
            KotlinType kotlinType = substituteVarargElementType = varargElementType == null ? null : substitutor3.substitute(varargElementType, Variance.IN_VARIANCE);
            if (substitutedType == null) {
                return null;
            }
            if ((substitutedType != unsubstitutedValueParameter.getType() || varargElementType != substituteVarargElementType) && wereChanges != null) {
                wereChanges[0] = true;
            }
            result2.add(new ValueParameterDescriptorImpl(substitutedDescriptor, dropOriginal ? null : unsubstitutedValueParameter, unsubstitutedValueParameter.getIndex(), unsubstitutedValueParameter.getAnnotations(), unsubstitutedValueParameter.getName(), substitutedType, unsubstitutedValueParameter.declaresDefaultValue(), unsubstitutedValueParameter.isCrossinline(), unsubstitutedValueParameter.isNoinline(), substituteVarargElementType, preserveSourceElement ? unsubstitutedValueParameter.getSource() : SourceElement.NO_SOURCE));
        }
        return result2;
    }

    @Override
    @Nullable
    public FunctionDescriptor getInitialSignatureDescriptor() {
        return this.initialSignatureDescriptor;
    }

    private void setInitialSignatureDescriptor(@Nullable FunctionDescriptor initialSignatureDescriptor) {
        this.initialSignatureDescriptor = initialSignatureDescriptor;
    }

    public <V> void putInUserDataMap(FunctionDescriptor.UserDataKey<V> key, Object value) {
        this.userDataMap.put(key, value);
    }

    static /* synthetic */ ReceiverParameterDescriptor access$000(FunctionDescriptorImpl x0) {
        return x0.dispatchReceiverParameter;
    }

    public class CopyConfiguration
    implements FunctionDescriptor.CopyBuilder<FunctionDescriptor> {
        @NotNull
        protected TypeSubstitution substitution;
        @NotNull
        protected DeclarationDescriptor newOwner;
        @NotNull
        protected Modality newModality;
        @NotNull
        protected Visibility newVisibility;
        @Nullable
        protected FunctionDescriptor original = null;
        @NotNull
        protected CallableMemberDescriptor.Kind kind;
        @NotNull
        protected List<ValueParameterDescriptor> newValueParameterDescriptors;
        @Nullable
        protected KotlinType newExtensionReceiverParameterType;
        @Nullable
        protected ReceiverParameterDescriptor dispatchReceiverParameter = FunctionDescriptorImpl.access$000(FunctionDescriptorImpl.this);
        @NotNull
        protected KotlinType newReturnType;
        @Nullable
        protected Name name;
        protected boolean copyOverrides = true;
        protected boolean signatureChange = false;
        protected boolean preserveSourceElement = false;
        protected boolean dropOriginalInContainingParts = false;
        private boolean isHiddenToOvercomeSignatureClash = FunctionDescriptorImpl.this.isHiddenToOvercomeSignatureClash();
        private List<TypeParameterDescriptor> newTypeParameters = null;
        private Annotations additionalAnnotations = null;
        private boolean isHiddenForResolutionEverywhereBesideSupercalls = FunctionDescriptorImpl.this.isHiddenForResolutionEverywhereBesideSupercalls();
        private Map<FunctionDescriptor.UserDataKey<?>, Object> userDataMap = new LinkedHashMap();
        private Boolean newHasSynthesizedParameterNames = null;
        protected boolean justForTypeSubstitution = false;
        private boolean isSuspend;

        public CopyConfiguration(@NotNull TypeSubstitution substitution2, @NotNull DeclarationDescriptor newOwner, @NotNull Modality newModality, @NotNull Visibility newVisibility, @NotNull CallableMemberDescriptor.Kind kind, @Nullable List<ValueParameterDescriptor> newValueParameterDescriptors, @NotNull KotlinType newExtensionReceiverParameterType, @Nullable KotlinType newReturnType, Name name2, boolean isSuspend) {
            this.substitution = substitution2;
            this.newOwner = newOwner;
            this.newModality = newModality;
            this.newVisibility = newVisibility;
            this.kind = kind;
            this.newValueParameterDescriptors = newValueParameterDescriptors;
            this.newExtensionReceiverParameterType = newExtensionReceiverParameterType;
            this.newReturnType = newReturnType;
            this.name = name2;
            this.isSuspend = isSuspend;
        }

        @NotNull
        public CopyConfiguration setOwner(@NotNull DeclarationDescriptor owner) {
            this.newOwner = owner;
            return this;
        }

        @NotNull
        public CopyConfiguration setModality(@NotNull Modality modality) {
            this.newModality = modality;
            return this;
        }

        @NotNull
        public CopyConfiguration setVisibility(@NotNull Visibility visibility) {
            this.newVisibility = visibility;
            return this;
        }

        @NotNull
        public CopyConfiguration setKind(@NotNull CallableMemberDescriptor.Kind kind) {
            this.kind = kind;
            return this;
        }

        @NotNull
        public CopyConfiguration setCopyOverrides(boolean copyOverrides) {
            this.copyOverrides = copyOverrides;
            return this;
        }

        @NotNull
        public CopyConfiguration setName(@NotNull Name name2) {
            this.name = name2;
            return this;
        }

        @NotNull
        public CopyConfiguration setValueParameters(@NotNull List<ValueParameterDescriptor> parameters2) {
            this.newValueParameterDescriptors = parameters2;
            return this;
        }

        @NotNull
        public CopyConfiguration setTypeParameters(@NotNull List<TypeParameterDescriptor> parameters2) {
            this.newTypeParameters = parameters2;
            return this;
        }

        @NotNull
        public CopyConfiguration setReturnType(@NotNull KotlinType type2) {
            this.newReturnType = type2;
            return this;
        }

        @NotNull
        public CopyConfiguration setExtensionReceiverType(@Nullable KotlinType type2) {
            this.newExtensionReceiverParameterType = type2;
            return this;
        }

        @NotNull
        public CopyConfiguration setDispatchReceiverParameter(@Nullable ReceiverParameterDescriptor dispatchReceiverParameter) {
            this.dispatchReceiverParameter = dispatchReceiverParameter;
            return this;
        }

        @NotNull
        public CopyConfiguration setOriginal(@Nullable CallableMemberDescriptor original) {
            this.original = (FunctionDescriptor)original;
            return this;
        }

        @NotNull
        public CopyConfiguration setSignatureChange() {
            this.signatureChange = true;
            return this;
        }

        @NotNull
        public CopyConfiguration setPreserveSourceElement() {
            this.preserveSourceElement = true;
            return this;
        }

        @NotNull
        public CopyConfiguration setDropOriginalInContainingParts() {
            this.dropOriginalInContainingParts = true;
            return this;
        }

        @NotNull
        public CopyConfiguration setIsSuspend(boolean isSuspend) {
            this.isSuspend = isSuspend;
            return this;
        }

        @NotNull
        public CopyConfiguration setHiddenToOvercomeSignatureClash() {
            this.isHiddenToOvercomeSignatureClash = true;
            return this;
        }

        @NotNull
        public CopyConfiguration setHiddenForResolutionEverywhereBesideSupercalls() {
            this.isHiddenForResolutionEverywhereBesideSupercalls = true;
            return this;
        }

        @NotNull
        public CopyConfiguration setAdditionalAnnotations(@NotNull Annotations additionalAnnotations) {
            this.additionalAnnotations = additionalAnnotations;
            return this;
        }

        public CopyConfiguration setHasSynthesizedParameterNames(boolean value) {
            this.newHasSynthesizedParameterNames = value;
            return this;
        }

        @NotNull
        public CopyConfiguration setSubstitution(@NotNull TypeSubstitution substitution2) {
            this.substitution = substitution2;
            return this;
        }

        @Override
        @NotNull
        public <V> FunctionDescriptor.CopyBuilder<FunctionDescriptor> putUserData(@NotNull FunctionDescriptor.UserDataKey<V> userDataKey, V value) {
            this.userDataMap.put(userDataKey, value);
            return this;
        }

        @Override
        @Nullable
        public FunctionDescriptor build() {
            return FunctionDescriptorImpl.this.doSubstitute(this);
        }

        @Nullable
        public FunctionDescriptor getOriginal() {
            return this.original;
        }

        @NotNull
        public TypeSubstitution getSubstitution() {
            return this.substitution;
        }

        @NotNull
        public CopyConfiguration setJustForTypeSubstitution(boolean value) {
            this.justForTypeSubstitution = value;
            return this;
        }
    }
}

